/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notifyirb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbBean;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolNotifyIrbServiceImpl
implements ProtocolNotifyIrbService {
    private static final Log LOG = LogFactory.getLog(ProtocolNotifyIrbServiceImpl.class);
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private KcNotificationService kcNotificationService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    public void submitIrbNotification(Protocol protocol, ProtocolNotifyIrbBean notifyIrbBean) throws WorkflowException {
        ProtocolSubmission submission = this.createProtocolSubmission(protocol, notifyIrbBean);
        ProtocolAction protocolAction = new ProtocolAction(protocol, submission, "116");
        protocolAction.setComments(notifyIrbBean.getComment());
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (!CollectionUtils.isEmpty(notifyIrbBean.getQuestionnaireHelper().getAnswerHeaders())) {
            this.saveQuestionnaire(notifyIrbBean, submission.getSubmissionNumber());
            notifyIrbBean.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
        }
        this.cleanUnreferencedQuestionnaire(protocol.getProtocolNumber());
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        protocol.refreshReferenceObject("protocolSubmissions");
    }

    private void saveQuestionnaire(ProtocolNotifyIrbBean notifyIrbBean, Integer submissionNumber) {
        ArrayList<AnswerHeader> saveHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : notifyIrbBean.getQuestionnaireHelper().getAnswerHeaders()) {
            if (answerHeader.getAnswerHeaderId() == null) continue;
            answerHeader.setModuleSubItemKey(submissionNumber.toString());
            if (answerHeader.getModuleItemKey().matches(".*[A-Z]$")) {
                answerHeader.setModuleItemKey(answerHeader.getModuleItemKey().substring(0, answerHeader.getModuleItemKey().length() - 1));
            }
            saveHeaders.add(answerHeader);
        }
        if (!saveHeaders.isEmpty()) {
            this.businessObjectService.save(saveHeaders);
        }
    }

    private void cleanUnreferencedQuestionnaire(String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber + "T");
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)answerHeaders)) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected ProtocolSubmission createProtocolSubmission(Protocol protocol, ProtocolNotifyIrbBean notifyIrbBean) {
        ProtocolSubmissionBuilder submissionBuilder = new ProtocolSubmissionBuilder(protocol, "112");
        submissionBuilder.setProtocolReviewTypeCode(notifyIrbBean.getReviewTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(notifyIrbBean.getSubmissionQualifierTypeCode());
        submissionBuilder.setSubmissionStatus("100");
        submissionBuilder.setCommittee(notifyIrbBean.getCommitteeId());
        submissionBuilder.setComments(notifyIrbBean.getComment());
        submissionBuilder.setActionAttachments(notifyIrbBean.getActionAttachments());
        ProtocolSubmission submission = submissionBuilder.create();
        submission.setScheduleId(null);
        submission.setScheduleIdFk(null);
        return submission;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

