/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import java.util.HashMap;
import org.kuali.kra.irb.actions.print.ProtocolPrintingService;
import org.kuali.kra.protocol.actions.print.ProtocolPrintHelper;
import org.kuali.kra.protocol.actions.print.ProtocolPrintType;
import org.kuali.kra.protocol.actions.print.ProtocolPrintingServiceImplBase;

public class ProtocolPrintingServiceImpl
extends ProtocolPrintingServiceImplBase
implements ProtocolPrintingService {
    @Override
    protected HashMap<ProtocolPrintType, ProtocolPrintHelper> getProtocolPrintParameterHook() {
        HashMap<ProtocolPrintType, ProtocolPrintHelper> printParameter = new HashMap<ProtocolPrintType, ProtocolPrintHelper>();
        for (ProtocolPrintType protocolPrintType : ProtocolPrintType.values()) {
            ProtocolPrintHelper printHelper = null;
            switch (protocolPrintType) {
                case PROTOCOL_FULL_PROTOCOL_REPORT: {
                    printHelper = new ProtocolPrintHelper(IRBPrintTypes.PROTOCOL_FULL_PROTOCOL_REPORT.getTemplate(), IRBPrintTypes.PROTOCOL_FULL_PROTOCOL_REPORT.getReportName(), IRBPrintTypes.PROTOCOL_FULL_PROTOCOL_REPORT.getFileName());
                    break;
                }
                case PROTOCOL_PROTOCOL_HISTORY_REPORT: {
                    printHelper = new ProtocolPrintHelper(IRBPrintTypes.PROTOCOL_PROTOCOL_HISTORY_REPORT.getTemplate(), IRBPrintTypes.PROTOCOL_PROTOCOL_HISTORY_REPORT.getReportName(), IRBPrintTypes.PROTOCOL_PROTOCOL_HISTORY_REPORT.getFileName());
                    break;
                }
                case PROTOCOL_REVIEW_COMMENTS_REPORT: {
                    printHelper = new ProtocolPrintHelper(IRBPrintTypes.PROTOCOL_REVIEW_COMMENTS_REPORT.getTemplate(), IRBPrintTypes.PROTOCOL_REVIEW_COMMENTS_REPORT.getReportName(), IRBPrintTypes.PROTOCOL_REVIEW_COMMENTS_REPORT.getFileName());
                    break;
                }
                case PROTOCOL_SUMMARY_VIEW_REPORT: {
                    printHelper = new ProtocolPrintHelper(IRBPrintTypes.PROTOCOL_SUMMARY_VIEW_REPORT.getTemplate(), IRBPrintTypes.PROTOCOL_SUMMARY_VIEW_REPORT.getReportName(), IRBPrintTypes.PROTOCOL_SUMMARY_VIEW_REPORT.getFileName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown report type specified");
                }
            }
            printParameter.put(protocolPrintType, printHelper);
        }
        return printParameter;
    }

    public static enum IRBPrintTypes {
        PROTOCOL_SUMMARY_VIEW_REPORT("ProtocolSummary.xsl", "ProtocolSummary", "Protocol_Summary_Report.pdf"),
        PROTOCOL_FULL_PROTOCOL_REPORT("ProtocolSummary.xsl", "FullProtocolReport", "Full_Protocol_Report.pdf"),
        PROTOCOL_PROTOCOL_HISTORY_REPORT("ProtocolHistoryReport.xsl", "ProtocolHistoryReport", "Protocol_History_Report.pdf"),
        PROTOCOL_REVIEW_COMMENTS_REPORT("ReviewCommentsReport.xsl", "ProtocolReviewComments", "Protocol_Review_Comments_Report.pdf");

        private final String template;
        private final String reportName;
        private final String fileName;

        private IRBPrintTypes(String template, String reportName, String fileName) {
            this.template = template;
            this.reportName = reportName;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getReportName() {
            return this.reportName;
        }
    }
}

