/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import edu.mit.irb.irbnamespace.CorrespondentDocument;
import edu.mit.irb.irbnamespace.InvestigatorDocument;
import edu.mit.irb.irbnamespace.KeyStudyPersonDocument;
import edu.mit.irb.irbnamespace.PersonDocument;
import edu.mit.irb.irbnamespace.ProtocolDocument;
import edu.mit.irb.irbnamespace.ProtocolMasterDataDocument;
import edu.mit.irb.irbnamespace.ProtocolReviewerDocument;
import edu.mit.irb.irbnamespace.ResearchAreaDocument;
import edu.mit.irb.irbnamespace.SpecialReviewDocument;
import edu.mit.irb.irbnamespace.SubmissionDetailsDocument;
import edu.mit.irb.irbnamespace.VulnerableSubjectDocument;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.CommitteeXmlStream;
import org.kuali.kra.committee.print.IrbPrintXmlUtilService;
import org.kuali.kra.committee.print.ScheduleXmlStream;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonRolodex;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReview;
import org.kuali.kra.protocol.actions.print.ProtocolXmlStreamBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;
import org.kuali.kra.service.KcPersonService;

public class ProtocolXmlStream
extends ProtocolXmlStreamBase {
    private IrbPrintXmlUtilService irbPrintXmlUtilService;
    private KcPersonService kcPersonService;
    private ScheduleXmlStream scheduleXmlStream;
    private CommitteeXmlStream committeeXmlStream;

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolDocument protocolDocumentType = ProtocolDocument.Factory.newInstance();
        protocolDocumentType.setProtocol(this.getProtocol(protocol));
        HashMap<String, XmlObject> xmlObjectMap = new HashMap<String, XmlObject>();
        xmlObjectMap.put("Protocol", (XmlObject)protocolDocumentType);
        return xmlObjectMap;
    }

    public String generateXmlStreamForNotification(Protocol protocol) {
        ProtocolDocument protocolDocumentType = ProtocolDocument.Factory.newInstance();
        protocolDocumentType.setProtocol(this.getProtocol(protocol));
        return protocolDocumentType.toString();
    }

    public ProtocolDocument.Protocol getProtocol(Protocol protocolInfoBean, Integer submissionNumber) {
        ProtocolDocument.Protocol protocolType = ProtocolDocument.Protocol.Factory.newInstance();
        this.setProtocolMasterData(protocolInfoBean, protocolType);
        this.addProtocolPersons(protocolInfoBean, protocolType);
        this.addResearchArea(protocolInfoBean, protocolType);
        this.addFundingSource(protocolInfoBean, protocolType);
        this.addVulnerableSubject(protocolInfoBean, protocolType);
        this.addSpecialReview(protocolInfoBean, protocolType);
        this.addSubmissionDetails(protocolInfoBean, protocolType, submissionNumber, "Yes");
        Integer parentSubmissionNumber = this.getParentSubmissionNumber(protocolInfoBean, submissionNumber);
        this.addSubmissionDetails(protocolInfoBean, protocolType, parentSubmissionNumber, "No");
        this.addRiskLevels(protocolInfoBean, protocolType);
        return protocolType;
    }

    private Integer getParentSubmissionNumber(Protocol protocolInfoBean, Integer submissionNumber) {
        return 0;
    }

    public ProtocolDocument.Protocol getProtocol(Protocol protocol) {
        ProtocolDocument.Protocol protocolType = ProtocolDocument.Protocol.Factory.newInstance();
        this.setProtocolMasterData(protocol, protocolType);
        this.addProtocolPersons(protocol, protocolType);
        this.addResearchArea(protocol, protocolType);
        this.addFundingSource(protocol, protocolType);
        this.addVulnerableSubject(protocol, protocolType);
        this.addSpecialReview(protocol, protocolType);
        this.addSubmissionDetails(protocol, protocolType);
        this.addRiskLevels(protocol, protocolType);
        return protocolType;
    }

    private void addRiskLevels(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolRiskLevel> cvRiskLevels = protocol.getProtocolRiskLevels();
        for (ProtocolRiskLevel protocolRiskLevelBean : cvRiskLevels) {
            protocolRiskLevelBean.refreshNonUpdateableReferences();
            ProtocolDocument.Protocol.RiskLevels riskLevelsType = protocolType.addNewRiskLevels();
            if (protocolRiskLevelBean.getRiskLevelCode() != null) {
                riskLevelsType.setRiskLevelCode(new BigInteger(protocolRiskLevelBean.getRiskLevelCode()));
                riskLevelsType.setRiskLevelDescription(protocolRiskLevelBean.getRiskLevel().getDescription());
            }
            if (protocolRiskLevelBean.getComments() != null) {
                riskLevelsType.setComments(protocolRiskLevelBean.getComments());
            }
            if (protocolRiskLevelBean.getDateAssigned() != null) {
                riskLevelsType.setDateAssigned(this.getDateTimeService().getCalendar((Date)protocolRiskLevelBean.getDateAssigned()));
            }
            if (protocolRiskLevelBean.getUpdateTimestamp() != null) {
                riskLevelsType.setDateUpdated(this.getDateTimeService().getCalendar((Date)protocolRiskLevelBean.getUpdateTimestamp()));
            }
            if (protocolRiskLevelBean.getStatus() != null) {
                if (protocolRiskLevelBean.getStatus().equalsIgnoreCase("A")) {
                    riskLevelsType.setStatus("Active");
                } else if (protocolRiskLevelBean.getStatus().equalsIgnoreCase("I")) {
                    riskLevelsType.setStatus("Inactive");
                }
            }
            if (protocolRiskLevelBean.getUpdateUser() != null) {
                riskLevelsType.setUpdateUser(protocolRiskLevelBean.getUpdateUser());
            }
            if (protocolRiskLevelBean.getUpdateTimestamp() == null) continue;
            riskLevelsType.setUpdateTimestamp(this.getDateTimeService().getCalendar((Date)protocolRiskLevelBean.getUpdateTimestamp()));
        }
    }

    private void addSubmissionDetails(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        this.addSubmissionDetails(protocol, protocolType, null, "No");
    }

    private void addSubmissionDetails(Protocol protocol, ProtocolDocument.Protocol protocolType, Integer submissionNumber, String currentFlag) {
        ProtocolSubmission submissionInfoBean = null;
        ProtocolSubmission protocolSubmission = submissionInfoBean = submissionNumber == null ? protocol.getProtocolSubmission() : this.findProtocolSubmission(protocol, submissionNumber);
        if (submissionInfoBean == null || submissionInfoBean.getSubmissionNumber() == null) {
            return;
        }
        submissionInfoBean.refreshNonUpdateableReferences();
        ProtocolDocument.Protocol.Submissions submission = protocolType.addNewSubmissions();
        SubmissionDetailsDocument.SubmissionDetails submissionDetail = submission.addNewSubmissionDetails();
        submissionDetail.setAbstainerCount(BigInteger.valueOf(submissionInfoBean.getAbstainerCount().intValue()));
        if (submissionInfoBean.getNoVoteCount() != null) {
            submissionDetail.setNoVote(BigInteger.valueOf(submissionInfoBean.getNoVoteCount().intValue()));
        }
        submissionDetail.setProtocolNumber(submissionInfoBean.getProtocolNumber());
        if (submissionInfoBean.getProtocolReviewType() != null) {
            submissionDetail.setProtocolReviewTypeCode(new BigInteger(submissionInfoBean.getProtocolReviewTypeCode()));
            submissionDetail.setProtocolReviewTypeDesc(submissionInfoBean.getProtocolReviewType().getDescription());
        }
        List<ProtocolReviewer> vecReviewers = submissionInfoBean.getProtocolReviewers();
        for (org.kuali.kra.irb.actions.submit.ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerDocument.ProtocolReviewer protocolReviewerType = submissionDetail.addNewProtocolReviewer();
            if (protocolReviewer.getProtocolReviewerType() != null) {
                protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
                protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
            }
            PersonDocument.Person personType = protocolReviewerType.addNewPerson();
            boolean isNonEmployee = protocolReviewer.getNonEmployeeFlag();
            if (isNonEmployee) {
                ProtocolPersonRolodex rolodex = (ProtocolPersonRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolPersonRolodex.class, (Object)protocolReviewer.getRolodexId());
                this.getIrbPrintXmlUtilService().setPersonXml(rolodex, personType);
                continue;
            }
            KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(protocolReviewer.getPersonId());
            this.getIrbPrintXmlUtilService().setPersonXml(kcPerson, personType);
        }
        submissionDetail.setSubmissionComments(submissionInfoBean.getComments());
        if (submissionInfoBean.getSubmissionDate() != null) {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((Date)submissionInfoBean.getSubmissionDate()));
        } else {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCurrentCalendar());
        }
        submissionDetail.setSubmissionNumber(BigInteger.valueOf(submissionInfoBean.getSubmissionNumber().intValue()));
        if (submissionInfoBean.getSubmissionStatus() != null) {
            submissionDetail.setSubmissionStatusCode(new BigInteger(submissionInfoBean.getSubmissionStatusCode()));
            submissionDetail.setSubmissionStatusDesc(submissionInfoBean.getSubmissionStatus().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionType() != null) {
            submissionDetail.setSubmissionTypeCode(new BigInteger(submissionInfoBean.getSubmissionTypeCode()));
            submissionDetail.setSubmissionTypeDesc(submissionInfoBean.getProtocolSubmissionType().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionQualifierType() != null) {
            String code = submissionInfoBean.getSubmissionTypeQualifierCode();
            submissionDetail.setSubmissionTypeQualifierCode(code == null ? new BigInteger("0") : new BigInteger(code));
            submissionDetail.setSubmissionTypeQualifierDesc(submissionInfoBean.getProtocolSubmissionQualifierType().getDescription());
        }
        submissionDetail.setVotingComments(submissionInfoBean.getVotingComments());
        if (submissionInfoBean.getYesVoteCount() != null) {
            submissionDetail.setYesVote(BigInteger.valueOf(submissionInfoBean.getYesVoteCount().intValue()));
        }
        this.getIrbPrintXmlUtilService().setProtocolSubmissionAction(submissionInfoBean, submissionDetail);
        this.getIrbPrintXmlUtilService().setSubmissionCheckListinfo(submissionInfoBean, submissionDetail);
        submission.setCurrentSubmissionFlag(currentFlag);
        this.setMinutes(submissionInfoBean, submission);
        if (submissionInfoBean.getCommitteeId() != null) {
            Committee committee = submissionInfoBean.getCommittee();
            this.getCommitteeXmlStream().setCommitteeMasterData(committee, submission.addNewCommitteeMasterData());
            this.getCommitteeXmlStream().setCommitteeMembers(committee, submission);
        }
        if (submissionInfoBean.getScheduleId() != null) {
            CommitteeSchedule committeeSchedule = submissionInfoBean.getCommitteeSchedule();
            this.getScheduleXmlStream().setScheduleMasterData(committeeSchedule, submission.addNewScheduleMasterData());
            ProtocolDocument.Protocol.Submissions.NextSchedule nextSchedule = submission.addNewNextSchedule();
            this.getScheduleXmlStream().setNextSchedule(committeeSchedule, nextSchedule.addNewScheduleMasterData());
        }
    }

    protected void setMinutes(ProtocolSubmission submissionInfoBean, ProtocolDocument.Protocol.Submissions submission) {
        CommitteeSchedule committeeSchedule = submissionInfoBean.getCommitteeSchedule();
        if (committeeSchedule != null) {
            this.getIrbPrintXmlUtilService().setProtocolReviewMinutes(committeeSchedule, submissionInfoBean, submission);
        }
    }

    private ProtocolSubmission findProtocolSubmission(Protocol protocol, Integer submissionNumber) {
        List<ProtocolSubmissionBase> protocolSubmissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmission protocolSubmission : protocolSubmissions) {
            if (!protocolSubmission.getSubmissionNumber().equals(submissionNumber)) continue;
            return protocolSubmission;
        }
        return null;
    }

    private void addSpecialReview(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolSpecialReviewBase> vecSpecialReview = protocol.getSpecialReviews();
        for (ProtocolSpecialReview protocolSpecialReview : vecSpecialReview) {
            protocolSpecialReview.refreshNonUpdateableReferences();
            SpecialReviewDocument.SpecialReview specialReview = protocolType.addNewSpecialReview();
            if (protocolSpecialReview.getApplicationDate() != null) {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCalendar((Date)protocolSpecialReview.getApplicationDate()));
            } else {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (protocolSpecialReview.getApprovalDate() != null) {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCalendar((Date)protocolSpecialReview.getApprovalDate()));
            } else {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (protocolSpecialReview.getApprovalType() != null) {
                specialReview.setSpecialReviewApprovalTypeCode(new BigInteger(protocolSpecialReview.getApprovalTypeCode()));
                specialReview.setSpecialReviewApprovalTypeDesc(protocolSpecialReview.getApprovalType().getDescription());
            }
            specialReview.setSpecialReviewComments(protocolSpecialReview.getComments());
            if (protocolSpecialReview.getSpecialReviewNumber() != null) {
                specialReview.setSpecialReviewNumber(BigInteger.valueOf(protocolSpecialReview.getSpecialReviewNumber().intValue()));
            }
            specialReview.setSpecialReviewProtocolNumber(protocolSpecialReview.getProtocolNumber());
            if (protocolSpecialReview.getSpecialReviewType() == null) continue;
            specialReview.setSpecialReviewTypeCode(new BigInteger(protocolSpecialReview.getSpecialReviewTypeCode()));
            specialReview.setSpecialReviewTypeDesc(protocolSpecialReview.getSpecialReviewType().getDescription());
        }
    }

    private void addVulnerableSubject(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolParticipant> protocolParticipants = protocol.getProtocolParticipants();
        for (ProtocolParticipant protocolParticipant : protocolParticipants) {
            protocolParticipant.refreshNonUpdateableReferences();
            VulnerableSubjectDocument.VulnerableSubject vulnerableSubject = protocolType.addNewVulnerableSubject();
            if (protocolParticipant.getParticipantType() == null) continue;
            vulnerableSubject.setVulnerableSubjectTypeCode(new BigInteger(protocolParticipant.getParticipantTypeCode()));
            vulnerableSubject.setVulnerableSubjectTypeDesc(protocolParticipant.getParticipantType().getDescription());
        }
    }

    private void addFundingSource(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
        for (ProtocolFundingSource protocolFundingSource : vecFundingSource) {
            ProtocolDocument.Protocol.FundingSource fundingSource = protocolType.addNewFundingSource();
            String fundingSourceCode = protocolFundingSource.getFundingSourceNumber();
            int fundingSourceTypeCode = Integer.valueOf(protocolFundingSource.getFundingSourceTypeCode());
            String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
            fundingSource.setFundingSourceName(fundingSourceName);
            if (protocolFundingSource.getFundingSourceType() != null) continue;
            fundingSource.setTypeOfFundingSource(protocolFundingSource.getFundingSourceType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsorBean = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsorBean != null) {
                name = sponsorBean.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unitBean = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unitBean != null) {
                name = unitBean.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void addResearchArea(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolResearchAreaBase> researchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchArea protocolResearchArea : researchAreas) {
            protocolResearchArea.refreshNonUpdateableReferences();
            ResearchAreaDocument.ResearchArea researchArea = protocolType.addNewResearchArea();
            researchArea.setResearchAreaCode(protocolResearchArea.getResearchAreaCode());
            researchArea.setResearchAreaDescription(protocolResearchArea.getResearchAreas().getDescription());
        }
    }

    private void addProtocolPersons(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        List<ProtocolPersonBase> vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPerson protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                InvestigatorDocument.Investigator investigator = protocolType.addNewInvestigator();
                if (protocolPerson.getProtocolPersonRoleId().equals("PI")) {
                    investigator.setPIFlag(true);
                }
                this.getIrbPrintXmlUtilService().setPersonRolodexType(protocolPerson, investigator.addNewPerson());
                continue;
            }
            if (protocolPerson.getProtocolPersonRoleId().equals("SP")) {
                KeyStudyPersonDocument.KeyStudyPerson keyStudyPerson = protocolType.addNewKeyStudyPerson();
                if (protocolPerson.getAffiliationType() != null) {
                    keyStudyPerson.setAffiliation(protocolPerson.getAffiliationType().getDescription());
                }
                if (protocolPerson.getRolodex() != null) {
                    keyStudyPerson.setRole(((ProtocolPersonRolodex)protocolPerson.getRolodex()).getPrimaryTitle());
                } else if (protocolPerson.getPerson() != null) {
                    keyStudyPerson.setRole(protocolPerson.getPerson().getDirectoryTitle());
                }
                this.getIrbPrintXmlUtilService().setPersonRolodexType(protocolPerson, keyStudyPerson.addNewPerson());
                continue;
            }
            if (!protocolPerson.getProtocolPersonRoleId().equals("CRC") && !protocolPerson.getProtocolPersonRoleId().equals("CA")) continue;
            CorrespondentDocument.Correspondent correspondent = protocolType.addNewCorrespondent();
            correspondent.setTypeOfCorrespondent(protocolPerson.getProtocolPersonRole().getDescription());
            this.getIrbPrintXmlUtilService().setPersonRolodexType(protocolPerson, correspondent.addNewPerson());
        }
    }

    private void setProtocolMasterData(Protocol protocol, ProtocolDocument.Protocol protocolType) {
        ProtocolMasterDataDocument.ProtocolMasterData protocolMaster = protocolType.addNewProtocolMasterData();
        if (protocol == null) {
            return;
        }
        protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
        protocolMaster.setSequenceNumber(BigInteger.valueOf(protocol.getSequenceNumber().intValue()));
        protocolMaster.setProtocolTitle(protocol.getTitle());
        protocolMaster.setDocumentNumber(protocol.getProtocolDocument().getDocumentNumber());
        if (protocol.getSubmissionDate() != null) {
            protocolMaster.setApplicationDate(this.getDateTimeService().getCalendar((Date)protocol.getSubmissionDate()));
        }
        if (protocol.getProtocolStatus() != null) {
            protocolMaster.setProtocolStatusCode(new BigInteger(protocol.getProtocolStatusCode()));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
        }
        if (protocol.getProtocolType() != null) {
            protocolMaster.setProtocolTypeCode(new BigInteger(protocol.getProtocolTypeCode()));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
        }
        if (protocol.getDescription() != null) {
            protocolMaster.setProtocolDescription(protocol.getDescription());
        }
        if (protocol.getApprovalDate() != null) {
            protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getApprovalDate()));
        }
        if (protocol.getLastApprovalDate() != null) {
            protocolMaster.setLastApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getLastApprovalDate()));
        }
        if (protocol.getExpirationDate() != null) {
            protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((Date)protocol.getExpirationDate()));
        }
        if (protocol.getProtocolSubmission() != null) {
            protocolMaster.setBillableFlag(protocol.getProtocolSubmission().isBillable());
        }
        if (protocol.getFdaApplicationNumber() != null) {
            protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
        }
        if (protocol.getReferenceNumber1() != null) {
            protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
        }
        if (protocol.getReferenceNumber2() != null) {
            protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
        }
    }

    public void setIrbPrintXmlUtilService(IrbPrintXmlUtilService irbPrintXmlUtilService) {
        this.irbPrintXmlUtilService = irbPrintXmlUtilService;
    }

    public IrbPrintXmlUtilService getIrbPrintXmlUtilService() {
        return this.irbPrintXmlUtilService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setScheduleXmlStream(ScheduleXmlStream scheduleXmlStream) {
        this.scheduleXmlStream = scheduleXmlStream;
    }

    public ScheduleXmlStream getScheduleXmlStream() {
        return this.scheduleXmlStream;
    }

    public void setCommitteeXmlStream(CommitteeXmlStream comitteeXmlStream) {
        this.committeeXmlStream = comitteeXmlStream;
    }

    public CommitteeXmlStream getCommitteeXmlStream() {
        return this.committeeXmlStream;
    }
}

