/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.risklevel;

import java.util.List;
import org.kuali.kra.irb.actions.risklevel.ProtocolAddRiskLevelEvent;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolAddRiskLevelRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<ProtocolAddRiskLevelEvent> {
    @Override
    public boolean processRules(ProtocolAddRiskLevelEvent event) {
        boolean isValid = true;
        String errorPathKey = event.getPropertyName() + ".newProtocolRiskLevel";
        GlobalVariables.getMessageMap().addToErrorPath(errorPathKey);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)event.getProtocolRiskLevel());
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPathKey);
        isValid &= GlobalVariables.getMessageMap().hasNoErrors();
        return isValid &= this.validateOneEntryPerRiskLevel(event.getProtocolRiskLevel(), event.getProtocolDocument().getProtocol().getProtocolRiskLevels(), errorPathKey);
    }

    private boolean validateOneEntryPerRiskLevel(ProtocolRiskLevel newProtocolRiskLevel, List<ProtocolRiskLevel> protocolRiskLevels, String errorPathKey) {
        boolean isValid = true;
        for (ProtocolRiskLevel protocolRiskLevel : protocolRiskLevels) {
            if (!protocolRiskLevel.getRiskLevelCode().equals(newProtocolRiskLevel.getRiskLevelCode()) || !"A".equals(protocolRiskLevel.getStatus()) || !"A".equals(newProtocolRiskLevel.getStatus())) continue;
            isValid = false;
            GlobalVariables.getMessageMap().putError(errorPathKey + ".riskLevelCode", "error.duplicate.risk.level", new String[0]);
        }
        return isValid;
    }
}

