/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.risklevel;

import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.risklevel.ProtocolUpdateRiskLevelEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolUpdateRiskLevelRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<ProtocolUpdateRiskLevelEvent> {
    @Override
    public boolean processRules(ProtocolUpdateRiskLevelEvent event) {
        boolean isValid = true;
        int index = event.getIndex();
        String errorPathKey = "document.protocol.protocolRiskLevels[" + index + "]";
        ProtocolRiskLevel persistedProtocolRiskLevel = event.getProtocolDocument().getProtocol().getProtocolRiskLevels().get(index);
        GlobalVariables.getMessageMap().addToErrorPath(errorPathKey);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)persistedProtocolRiskLevel);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPathKey);
        isValid &= GlobalVariables.getMessageMap().hasNoErrors();
        return isValid &= this.validateDateInactivated(persistedProtocolRiskLevel, errorPathKey);
    }

    private boolean validateDateInactivated(ProtocolRiskLevel updatedProtocolRiskLevel, String errorPathKey) {
        boolean isValid = true;
        if (updatedProtocolRiskLevel.getDateInactivated() == null) {
            isValid = false;
            GlobalVariables.getMessageMap().putError(errorPathKey + ".dateInactivated", "error.date.inactivated.required", new String[0]);
        }
        return isValid;
    }
}

