/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;

public class ProtocolActionMapping
extends ProtocolActionMappingBase {
    private static final Map<String, String> ACTION_TYPE_SUBMISSION_TYPE_MAP;
    private static final List<String> APPROVE_ACTION_TYPES;

    public ProtocolActionMapping(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        super(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
    }

    @Override
    protected Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook() {
        return CommitteeScheduleMinute.class;
    }

    @Override
    public boolean getSubmissionCount() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        HashMap<String, String> negativeFieldValues = new HashMap<String, String>();
        negativeFieldValues.put("submissionTypeCode", ACTION_TYPE_SUBMISSION_TYPE_MAP.get(this.actionTypeCode));
        return this.businessObjectService.countMatching(ProtocolSubmission.class, positiveFieldValues, negativeFieldValues) == 0;
    }

    @Override
    public boolean getSubmissionCountCond2() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        return this.businessObjectService.countMatching(ProtocolSubmission.class, positiveFieldValues) == 0;
    }

    @Override
    public boolean getSubmissionCountCond4() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        positiveFieldValues.put("submissionStatusCode", this.getPendingSubmissionStatusCodes());
        positiveFieldValues.put("submissionTypeCode", Arrays.asList("113", "110", "108", "109", "111", "114"));
        return this.businessObjectService.countMatching(ProtocolSubmission.class, positiveFieldValues) == 0;
    }

    private List<String> getPendingSubmissionStatusCodes() {
        ArrayList<String> submissionStatusCodes = new ArrayList<String>();
        submissionStatusCodes.add("100");
        submissionStatusCodes.add("101");
        submissionStatusCodes.add("102");
        return submissionStatusCodes;
    }

    @Override
    public boolean getSubmissionCountCond5() {
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(ProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return submissions.isEmpty() || !this.getPendingSubmissionStatusCodes().contains(((ProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    @Override
    public boolean getSubmissionCountForWithdraw() {
        List<String> statusCodes = Arrays.asList("100", "101", "102", "201", "202");
        HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
        positiveFieldValues.put("protocolNumber", this.protocol.getProtocolNumber());
        positiveFieldValues.put("sequenceNumber", this.protocol.getSequenceNumber());
        List submissions = (List)this.businessObjectService.findMatchingOrderBy(ProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
        return !submissions.isEmpty() && statusCodes.contains(((ProtocolSubmission)submissions.get(0)).getSubmissionStatusCode());
    }

    public boolean isInitialProtocol() {
        boolean initialProtocol = true;
        for (ProtocolActionBase action : this.protocol.getProtocolActions()) {
            if (!APPROVE_ACTION_TYPES.contains(action.getProtocolActionTypeCode())) continue;
            initialProtocol = false;
            break;
        }
        return initialProtocol;
    }

    public boolean isSubmitForRevision() {
        ProtocolSubmission prevSubmission;
        boolean revisionSubmission = false;
        if (this.protocol.getProtocolSubmissions().size() >= 2 && ("202".equals((prevSubmission = (ProtocolSubmission)this.protocol.getProtocolSubmissions().get(this.protocol.getProtocolSubmissions().size() - 2)).getSubmissionStatusCode()) || "201".equals(prevSubmission.getSubmissionStatusCode()))) {
            revisionSubmission = true;
        }
        return revisionSubmission;
    }

    static {
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("302", "110");
        codeMap.put("306", "110");
        codeMap.put("207", "111");
        codeMap.put("211", "113");
        codeMap.put("212", "114");
        codeMap.put("300", "109");
        codeMap.put("301", "108");
        ACTION_TYPE_SUBMISSION_TYPE_MAP = Collections.unmodifiableMap(codeMap);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("204");
        codes.add("205");
        codes.add("206");
        APPROVE_ACTION_TYPES = codes;
    }
}

