/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionQualifierType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ValidProtoSubRevType;
import org.kuali.kra.irb.actions.submit.ValidProtoSubTypeQual;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ExecuteProtocolSubmitActionRule;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolSubmitActionRule
extends ResearchDocumentRuleBase
implements ExecuteProtocolSubmitActionRule {
    private static final String MANDATORY = "M";
    private ParameterService parameterService;
    private CommitteeService committeeService;

    @Override
    public boolean processSubmitAction(ProtocolDocumentBase document, org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction submitAction) {
        boolean isValid = this.validateSubmissionType((ProtocolDocument)document, (ProtocolSubmitAction)submitAction);
        isValid &= this.validateProtocolReviewType((ProtocolSubmitAction)submitAction);
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((String)submitAction.getProtocolReviewTypeCode())) {
            isValid &= this.isValidSubmReviewType((ProtocolSubmitAction)submitAction);
        }
        if (this.isMandatory()) {
            isValid &= this.validateCommittee((ProtocolSubmitAction)submitAction);
            isValid &= this.validateSchedule((ProtocolSubmitAction)submitAction);
        }
        isValid &= this.validateCheckLists((ProtocolSubmitAction)submitAction);
        isValid &= this.validateReviewers((ProtocolSubmitAction)submitAction);
        return isValid &= this.checkNoSpoofing((ProtocolSubmitAction)submitAction);
    }

    private boolean validateCommittee(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((String)submitAction.getNewCommitteeId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.committeeId", "error.protocol.submission.committee.required", new String[0]);
        }
        return valid;
    }

    private boolean validateSchedule(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((String)submitAction.getNewScheduleId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.scheduleId", "error.protocol.submission.schedule.required", new String[0]);
        }
        return valid;
    }

    private boolean isSubmissionTypeInvalidForProtocolStatus(ProtocolDocument document, String submissionTypeCode) {
        String protocolStatusCode = document.getProtocol().getProtocolStatusCode();
        return StringUtils.isNotBlank((String)protocolStatusCode) && (StringUtils.equals((String)"102", (String)protocolStatusCode) || StringUtils.equals((String)"104", (String)protocolStatusCode)) && !StringUtils.equals((String)"103", (String)submissionTypeCode) && !StringUtils.equals((String)"101", (String)submissionTypeCode);
    }

    private boolean validateSubmissionType(ProtocolDocument document, ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String submissionTypeCode = submitAction.getSubmissionTypeCode();
        if (StringUtils.isBlank((String)submissionTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.submissionTypeCode", "error.protocol.submissionTypeCode.notFound", new String[0]);
        } else {
            isValid = this.isValidSubmTypeQual(submitAction);
        }
        return isValid;
    }

    private boolean validateProtocolReviewType(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String protocolReviewTypeCode = submitAction.getProtocolReviewTypeCode();
        if (StringUtils.isBlank((String)protocolReviewTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound", new String[0]);
        } else if (this.isReviewTypeInvalid(protocolReviewTypeCode)) {
            isValid = false;
            this.reportError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.invalid", protocolReviewTypeCode);
        }
        return isValid;
    }

    private boolean validateCheckLists(ProtocolSubmitAction submitAction) {
        String protocolReviewTypeCode = submitAction.getProtocolReviewTypeCode();
        if (StringUtils.equals((String)protocolReviewTypeCode, (String)"3")) {
            List<ExemptStudiesCheckListItem> checkList = submitAction.getExemptStudiesCheckList();
            for (ExemptStudiesCheckListItem item : checkList) {
                if (!item.getChecked()) continue;
                return true;
            }
            this.reportError("actionHelper.protocolSubmitAction", "error.protocol.checkList.one", new String[0]);
            return false;
        }
        if (StringUtils.equals((String)protocolReviewTypeCode, (String)"2")) {
            List<ExpeditedReviewCheckListItem> checkList = submitAction.getExpeditedReviewCheckList();
            for (ExpeditedReviewCheckListItem item : checkList) {
                if (!item.getChecked()) continue;
                return true;
            }
            this.reportError("actionHelper.protocolSubmitAction", "error.protocol.checkList.one", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateReviewers(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        List<ProtocolReviewerBeanBase> reviewers = submitAction.getReviewers();
        for (int i = 0; i < reviewers.size(); ++i) {
            ProtocolReviewerBean reviewer = (ProtocolReviewerBean)reviewers.get(i);
            if (this.isReviewerValid(reviewer, i)) continue;
            isValid = false;
        }
        return isValid;
    }

    public boolean checkNoSpoofing(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        List<ProtocolReviewerBeanBase> submittedReviewers = submitAction.getReviewers();
        if (null != submittedReviewers && submittedReviewers.size() > 0) {
            if (StringUtils.isBlank((String)submitAction.getCommitteeId())) {
                isValid = false;
            } else {
                List<CommitteeMembershipBase> actualReviewers = submitAction.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(submitAction.getCommitteeId(), submitAction.getScheduleId()));
                for (int i = 0; i < submittedReviewers.size(); ++i) {
                    ProtocolReviewerBean reviewer = (ProtocolReviewerBean)submittedReviewers.get(i);
                    if (this.isReviewerInList(reviewer, actualReviewers, i)) continue;
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    private boolean isReviewerInList(ProtocolReviewerBean reviewer, List<CommitteeMembership> actualReviewers, int reviewerIndex) {
        boolean valid = false;
        for (CommitteeMembership member : actualReviewers) {
            if (!StringUtils.isBlank((String)member.getPersonId())) {
                if (!StringUtils.equals((String)reviewer.getPersonId(), (String)member.getPersonId())) continue;
                valid = true;
                break;
            }
            if (!StringUtils.equals((String)reviewer.getPersonId(), (String)member.getRolodexId().toString())) continue;
            valid = true;
            break;
        }
        if (!valid) {
            String parameterName = "actionHelper.protocolSubmitAction.reviewer[" + reviewerIndex + "].reviewerUnavailable";
            this.reportError(parameterName, "error.protocol.reviewer.unavailable", reviewer.getFullName());
        }
        return valid;
    }

    private boolean isReviewerValid(ProtocolReviewerBean reviewer, int reviewerIndex) {
        boolean isValid = true;
        String reviewerTypeCode = reviewer.getReviewerTypeCode();
        String parameterName = "actionHelper.protocolSubmitAction.reviewer[" + reviewerIndex + "].reviewerTypeCode";
        if (!StringUtils.isBlank((String)reviewerTypeCode) && this.isReviewerTypeInvalid(reviewerTypeCode)) {
            isValid = false;
            this.reportError(parameterName, "error.protocol.reviewerTypeCode.invalid", reviewer.getFullName());
        }
        return isValid;
    }

    private boolean isValidSubmReviewType(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((String)submitAction.getProtocolReviewTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubRevTypes = (List)this.getBusinessObjectService().findMatching(ValidProtoSubRevType.class, fieldValues);
            if (!validProtoSubRevTypes.isEmpty()) {
                ArrayList<String> reviewTypes = new ArrayList<String>();
                for (ValidProtoSubRevType validProtoSubRevType : validProtoSubRevTypes) {
                    reviewTypes.add(validProtoSubRevType.getProtocolReviewTypeCode());
                }
                if (!reviewTypes.contains(submitAction.getProtocolReviewTypeCode()) && !this.isReviewTypeInvalid(submitAction.getProtocolReviewTypeCode())) {
                    GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "invalid.submreviewtype", new String[]{((ProtocolSubmissionType)this.getBo(ProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode())).getDescription(), ((ProtocolReviewType)this.getBo(ProtocolReviewType.class, "reviewTypeCode", submitAction.getProtocolReviewTypeCode())).getDescription()});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isValidSubmTypeQual(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubTypeQuals = (List)this.getBusinessObjectService().findMatching(ValidProtoSubTypeQual.class, fieldValues);
            if (!validProtoSubTypeQuals.isEmpty()) {
                ArrayList<String> typeQuals = new ArrayList<String>();
                for (ValidProtoSubTypeQual validProtoSubTypeQual : validProtoSubTypeQuals) {
                    typeQuals.add(validProtoSubTypeQual.getSubmissionTypeQualCode());
                }
                if (StringUtils.isBlank((String)submitAction.getSubmissionQualifierTypeCode()) || !typeQuals.contains(submitAction.getSubmissionQualifierTypeCode())) {
                    String desc = "";
                    ProtocolSubmissionQualifierType typeQual = (ProtocolSubmissionQualifierType)this.getBo(ProtocolSubmissionQualifierType.class, "submissionQualifierTypeCode", submitAction.getSubmissionQualifierTypeCode());
                    if (typeQual != null) {
                        desc = typeQual.getDescription();
                    }
                    GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.submissionQualifierTypeCode", "invalid.submtypequal", new String[]{((ProtocolSubmissionType)this.getBo(ProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode())).getDescription(), desc});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isSubmissionTypeInvalid(String submissionTypeCode) {
        return !this.existsUnique(ProtocolSubmissionType.class, "submissionTypeCode", submissionTypeCode);
    }

    private boolean isReviewTypeInvalid(String reviewTypeCode) {
        return !this.existsUnique(ProtocolReviewType.class, "reviewTypeCode", reviewTypeCode);
    }

    private boolean isReviewerTypeInvalid(String reviewerTypeCode) {
        return !this.existsUnique(ProtocolReviewerType.class, "reviewerTypeCode", reviewerTypeCode);
    }

    private boolean existsUnique(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        if (keyField != null) {
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, keyField);
            if (businessObjectService.countMatching(boType, fieldValues) == 1) {
                return true;
            }
        }
        return false;
    }

    private BusinessObject getBo(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(propertyName, keyField);
        List results = (List)this.getBusinessObjectService().findMatching(boType, fieldValues);
        if (results.isEmpty()) {
            return null;
        }
        return (BusinessObject)results.get(0);
    }

    private boolean isMandatory() {
        String param = this.getParameterService().getParameterValueAsString(ProtocolDocument.class, "IRB_COMM_SELECTION_DURING_SUBMISSION");
        return StringUtils.equalsIgnoreCase((String)MANDATORY, (String)param);
    }

    @Override
    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    private CommitteeService getCommitteeService() {
        if (null == this.committeeService) {
            this.committeeService = KraServiceLocator.getService(CommitteeService.class);
        }
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }
}

