/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class SubmissionTypeValuesFinder
extends IrbActionsKeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        Collection submissionTypes = this.getKeyValuesService().findAll(ProtocolSubmissionType.class);
        for (ProtocolSubmissionType submissionType : submissionTypes) {
            if (!this.isSubmitForReviewType(submissionType)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(submissionType.getSubmissionTypeCode(), submissionType.getDescription()));
        }
        return keyValues;
    }

    private boolean isSubmitForReviewType(ProtocolSubmissionType submissionType) {
        Collection<String> typeCodes = this.getValidSubmissionTypes();
        for (String typeCode : typeCodes) {
            if (!StringUtils.equals((String)typeCode, (String)submissionType.getSubmissionTypeCode())) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getValidSubmissionTypes() {
        ArrayList<String> types = new ArrayList<String>();
        ProtocolForm pf = (ProtocolForm)KNSGlobalVariables.getKualiForm();
        if (pf != null) {
            String currentStatus = pf.getProtocolDocument().getProtocol().getProtocolStatusCode();
            if (this.displayInitialSubmission(currentStatus)) {
                types.add("100");
            }
            if (this.displayAmendment(currentStatus, pf.getProtocolDocument().getProtocol())) {
                types.add("102");
            }
            if (this.displayContinuation(currentStatus, pf.getProtocolDocument().getProtocol())) {
                types.add("101");
            }
            if (this.displayContinuationWithAmendment(currentStatus, pf.getProtocolDocument().getProtocol())) {
                types.add("115");
            }
            if (this.displayResponseToPrevIRBNotication(currentStatus)) {
                types.add("103");
            }
            if (this.displayResubmission(currentStatus)) {
                types.add("116");
            }
        }
        return types;
    }

    private boolean displayInitialSubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "304", "101", "402"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayResponseToPrevIRBNotication(String currentStatus) {
        String[] validStatuses = new String[]{"102", "104", "103", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayAmendment(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "105", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasAmmendmentProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuation(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "106", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasRenewalProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuationWithAmendment(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "106", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasRenewalProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean hasAmmendmentProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("A");
    }

    private boolean hasRenewalProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("R");
    }

    private boolean displayResubmission(String currentStatus) {
        String[] validStatuses = new String[]{"304", "101", "107"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean validateCurrentStatus(String currentStatus, String[] validStatuses) {
        for (String status : validStatuses) {
            if (!StringUtils.equals((String)currentStatus, (String)status)) continue;
            return true;
        }
        return false;
    }
}

