/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.auth.ModifyProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;

public abstract class ModifyAmendmentAuthorizer
extends ModifyProtocolAuthorizer {
    private String moduleTypeCode;
    private ProtocolAmendRenewService protocolAmendRenewService;

    protected ModifyAmendmentAuthorizer(String moduleTypeCode) {
        this.moduleTypeCode = moduleTypeCode;
    }

    @Override
    public boolean isAuthorized(String userId, ProtocolTask task) {
        Protocol protocol = task.getProtocol();
        boolean hasPermission = super.isAuthorized(userId, task);
        if (hasPermission && this.isAmendmentOrRenewal(protocol)) {
            hasPermission = this.canModifyModule(protocol, this.moduleTypeCode);
        }
        if (hasPermission && protocol.isCorrectionMode()) {
            hasPermission = this.canCorrectModule(protocol, this.moduleTypeCode);
        }
        return hasPermission;
    }

    private boolean canCorrectModule(Protocol protocol, String moduleTypeCode) {
        List<Object> availableModules = new ArrayList();
        try {
            availableModules = this.protocolAmendRenewService.getAvailableModules(protocol.getProtocolNumber());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return availableModules.contains(moduleTypeCode);
    }

    private boolean canModifyModule(Protocol protocol, String moduleTypeCode) {
        return protocol.getProtocolAmendRenewal().hasModule(moduleTypeCode);
    }

    public void setProtocolAmendRenewService(ProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }
}

