/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentTypeGroup;
import org.kuali.kra.lookup.keyvalue.ConditionValuesFinder;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.kra.lookup.keyvalue.SortedValuesFinder;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.TypedAttachment;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public class ProtocolAttachmentTypeByGroupValuesFinder<T extends ProtocolAttachmentBase>
extends KeyValuesBase {
    private static final long serialVersionUID = 1806457024473671666L;
    private static final String GROUP_CODE_NAME = "groupCode";
    private static final String TYPE_DESCRIPTION_NAME = "type.description";
    private static final String TYPE_CODE_NAME = "type.code";
    private String groupCode;
    private Collection<T> filterTypes;

    public List<KeyValue> getKeyValues() {
        this.validateRequiredProperties();
        List exemptionTypes = this.createKeyValuesFinder().getKeyValues();
        return this.filterUsedTypes(exemptionTypes);
    }

    KeyValuesFinder createKeyValuesFinder() {
        ConditionValuesFinder<ProtocolAttachmentTypeGroup> condFinder = new ConditionValuesFinder<ProtocolAttachmentTypeGroup>();
        condFinder.setClazz(ProtocolAttachmentTypeGroup.class);
        condFinder.setKey(TYPE_CODE_NAME);
        condFinder.setValue(TYPE_DESCRIPTION_NAME);
        condFinder.setConditions(Collections.singletonMap(GROUP_CODE_NAME, this.getGroupCode()));
        return new PrefixValuesFinder(new SortedValuesFinder((KeyValuesFinder)condFinder));
    }

    private List<KeyValue> filterUsedTypes(List<KeyValue> unfiltered) {
        assert (unfiltered != null) : "unfiltered is null";
        ArrayList<KeyValue> filtered = new ArrayList<KeyValue>();
        for (KeyValue item : unfiltered) {
            if (this.containsType(item.getKey())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    private boolean containsType(String typeCode) {
        if (this.filterTypes == null) {
            return false;
        }
        for (TypedAttachment attachment : this.filterTypes) {
            if (!attachment.getType().getCode().equals(typeCode)) continue;
            return true;
        }
        return false;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public Collection<T> getFilterTypes() {
        return this.filterTypes != null ? new ArrayList<T>(this.filterTypes) : null;
    }

    public void setFilterTypes(Collection<T> filterTypes) {
        this.filterTypes = filterTypes != null ? new ArrayList<T>(filterTypes) : null;
    }

    private void validateRequiredProperties() {
        if (StringUtils.isBlank((String)this.groupCode)) {
            throw new IllegalStateException("the groupCode has not been set to a non-blank value");
        }
    }
}

