/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.permission;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.permissions.bo.PermissionsRoleState;
import org.kuali.kra.common.permissions.bo.PermissionsUserEditRoles;
import org.kuali.kra.common.permissions.rule.event.EditUserPermissionsRolesEvent;
import org.kuali.kra.common.permissions.web.bean.Role;
import org.kuali.kra.common.permissions.web.bean.RoleState;
import org.kuali.kra.common.permissions.web.bean.User;
import org.kuali.kra.common.permissions.web.bean.UserState;
import org.kuali.kra.common.permissions.web.struts.action.PermissionsActionHelperBase;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsForm;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsHelperBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.permission.ProtocolPermissionsAction;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

class ProtocolPermissionsActionHelper
extends PermissionsActionHelperBase {
    ProtocolPermissionsAction protocolPermissionsAction;
    private static final String SET_EDIT_ROLES_METHOD = "setEditRoles";
    private static final String MAINTAIN_IRB_QUESTIONNAIRE = "Maintain IRB Questionnaire";
    private static final String PROTOCOL_DELETER = "Protocol Deleter";

    public ProtocolPermissionsActionHelper(ProtocolPermissionsAction protocolPermissionsAction) {
        super(protocolPermissionsAction);
        this.protocolPermissionsAction = protocolPermissionsAction;
    }

    @Override
    protected void addUserToRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        this.getKraAuthorizationService().addRole(userId, roleName, protocolDocument.getProtocol());
    }

    @Override
    protected void removeUserFromRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        this.getKraAuthorizationService().removeRole(userId, roleName, protocolDocument.getProtocol());
    }

    private KraAuthorizationService getKraAuthorizationService() {
        return KraServiceLocator.getService(KraAuthorizationService.class);
    }

    @Override
    public ActionForward editRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        int lineNum = this.getLineNum(request);
        User user = permissionsHelper.getUsers().get(lineNum);
        PermissionsUserEditRoles editRoles = new PermissionsUserEditRoles();
        editRoles.setLineNum(lineNum);
        editRoles.setJavaScriptEnabled(this.isJavaScriptEnabled(request));
        editRoles.setUserName(user.getPerson().getUserName());
        editRoles.setPrinipalInvestigator(this.isPrincipalInvestigator((ProtocolDocument)permissionsForm.getDocument(), user.getPerson().getPersonId()));
        ArrayList<PermissionsRoleState> roleStates = new ArrayList<PermissionsRoleState>();
        List<Role> roles = permissionsHelper.getNormalRoles();
        for (Role role : roles) {
            if (!"Viewer".equalsIgnoreCase(role.getDisplayName()) && !"Aggregator".equalsIgnoreCase(role.getDisplayName()) && !role.getDisplayName().equalsIgnoreCase(MAINTAIN_IRB_QUESTIONNAIRE) && !role.getDisplayName().equalsIgnoreCase(PROTOCOL_DELETER)) continue;
            PermissionsRoleState roleState = new PermissionsRoleState(role);
            roleStates.add(roleState);
        }
        editRoles.setRoleStates(roleStates);
        List<Role> userRoles = user.getRoles();
        for (Role userRole : userRoles) {
            editRoles.setRoleState(userRole.getName(), Boolean.TRUE);
        }
        permissionsHelper.setUserEditRoles(editRoles);
        return mapping.findForward("permissionsEditRoles");
    }

    @Override
    public ActionForward setEditRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = null;
        PermissionsHelperBase permissionsHelper = ((PermissionsForm)form).getPermissionsHelper();
        PermissionsForm permissionsForm = (PermissionsForm)form;
        Document doc = permissionsForm.getDocument();
        if (!permissionsHelper.canModifyPermissions()) {
            return this.protocolPermissionsAction.processAuthorizationViolation(SET_EDIT_ROLES_METHOD, mapping, form, request, response);
        }
        PermissionsUserEditRoles editRoles = permissionsHelper.getEditRoles();
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new EditUserPermissionsRolesEvent(doc, permissionsHelper.getUsers(), editRoles));
        if (!rulePassed) {
            actionForward = mapping.findForward("permissionsEditRoles");
        } else {
            this.updateRoles(editRoles, permissionsHelper);
            actionForward = editRoles.getJavaScriptEnabled() ? mapping.findForward("permissionsCloseEditRoles") : mapping.findForward("basic");
        }
        return actionForward;
    }

    private void updateRoles(PermissionsUserEditRoles editRoles, PermissionsHelperBase permissionsHelper) {
        Role rolePI = null;
        Role roleCOI = null;
        UserState userState = permissionsHelper.getUserState(editRoles.getUserName());
        List<RoleState> statesList = userState.getRoleStates();
        for (RoleState roleState : statesList) {
            if ("COI".equalsIgnoreCase(roleState.getRole().getName()) && roleState.isAssigned()) {
                roleCOI = roleState.getRole();
            }
            if (!"PI".equalsIgnoreCase(roleState.getRole().getName()) || !roleState.isAssigned()) continue;
            rolePI = roleState.getRole();
        }
        userState.clearAssignments();
        List<PermissionsRoleState> roleStates = editRoles.getRoleStates();
        PermissionsRoleState permissionsRoleState = null;
        if (roleCOI != null) {
            permissionsRoleState = new PermissionsRoleState(roleCOI);
            permissionsRoleState.setState(true);
            if (permissionsRoleState != null || permissionsRoleState.getState().booleanValue()) {
                roleStates.add(permissionsRoleState);
            }
        }
        if (rolePI != null) {
            permissionsRoleState = new PermissionsRoleState(rolePI);
            permissionsRoleState.setState(true);
            if (permissionsRoleState != null || permissionsRoleState.getState().booleanValue()) {
                roleStates.add(permissionsRoleState);
            }
        }
        for (PermissionsRoleState roleState : roleStates) {
            if (!roleState.getState().booleanValue()) continue;
            userState.setAssigned(roleState.getRole().getName(), true);
        }
        if (!userState.hasAnyRole() && permissionsHelper.getUnassignedRoleName() != null) {
            userState.setAssigned(permissionsHelper.getUnassignedRoleName(), true);
        }
    }

    private int getLineNum(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            return Integer.parseInt(lineNumStr);
        }
        catch (Exception ex) {
            return this.getLineToDelete(request);
        }
    }

    private boolean isJavaScriptEnabled(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            Integer.parseInt(lineNumStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private int getLineToDelete(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    private int getSelectedLine(HttpServletRequest request) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    private boolean isPrincipalInvestigator(ProtocolDocument protocolDocument, String personId) {
        return StringUtils.equals((String)personId, (String)protocolDocument.getProtocol().getPrincipalInvestigatorId());
    }
}

