/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.protocol.ProtocolNumberService;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.ProtocolHelperBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;

public class ProtocolHelper
extends ProtocolHelperBase {
    private static final long serialVersionUID = 1236584866243874926L;
    private ProtocolParticipant newProtocolParticipant;
    private boolean modifySubjects = false;

    public ProtocolHelper(ProtocolForm form) {
        super(form);
        this.setNewProtocolParticipant(new ProtocolParticipant());
    }

    @Override
    protected Protocol getProtocol() {
        return (Protocol)super.getProtocol();
    }

    @Override
    protected void initializePermissions(ProtocolBase protocol) {
        super.initializePermissions(protocol);
        this.initializeModifySubjectsPermission((Protocol)protocol);
    }

    private void initializeModifySubjectsPermission(Protocol protocol) {
        ProtocolTask task = new ProtocolTask("modifyProtocolSubjects", protocol);
        this.modifySubjects = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    @Override
    public void syncSpecialReviewsWithFundingSources() throws WorkflowException {
        String protocolNumber;
        String fundingSourceTypeCode;
        String fundingSourceNumber;
        for (ProtocolFundingSourceBase protocolFundingSource : this.getProtocol().getProtocolFundingSources()) {
            fundingSourceNumber = ((ProtocolFundingSource)protocolFundingSource).getFundingSourceNumber();
            fundingSourceTypeCode = ((ProtocolFundingSource)protocolFundingSource).getFundingSourceTypeCode();
            protocolNumber = this.getProtocol().getProtocolNumber();
            if (this.getSpecialReviewService().isLinkedToSpecialReview(fundingSourceNumber, fundingSourceTypeCode, protocolNumber)) continue;
            Date applicationDate = this.getProtocol().getProtocolSubmission().getSubmissionDate();
            Date approvalDate = this.getProtocol().getLastApprovalDate() == null ? this.getProtocol().getApprovalDate() : this.getProtocol().getLastApprovalDate();
            Date expirationDate = this.getProtocol().getExpirationDate();
            ArrayList<String> exemptionTypeCodes = new ArrayList<String>();
            for (ProtocolExemptStudiesCheckListItem checkListItem : this.getProtocol().getProtocolSubmission().getExemptStudiesCheckList()) {
                exemptionTypeCodes.add(checkListItem.getExemptStudiesCheckListCode());
            }
            this.getSpecialReviewService().addSpecialReviewForProtocolFundingSource(fundingSourceNumber, fundingSourceTypeCode, protocolNumber, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        }
        for (ProtocolFundingSourceBase protocolFundingSource : this.getDeletedProtocolFundingSources()) {
            fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
            fundingSourceTypeCode = String.valueOf(protocolFundingSource.getFundingSourceTypeCode());
            protocolNumber = this.getProtocol().getProtocolNumber();
            this.getSpecialReviewService().deleteSpecialReviewForProtocolFundingSource(fundingSourceNumber, fundingSourceTypeCode, protocolNumber);
        }
        this.getDeletedProtocolFundingSources().clear();
    }

    @Override
    protected ProtocolNumberService getProtocolNumberService() {
        return KraServiceLocator.getService(ProtocolNumberService.class);
    }

    @Override
    public ProtocolPersonnelService getProtocolPersonnelService() {
        ProtocolPersonnelService theService = KraServiceLocator.getService(ProtocolPersonnelService.class);
        return theService;
    }

    public ProtocolParticipant getNewProtocolParticipant() {
        return this.newProtocolParticipant;
    }

    public void setNewProtocolParticipant(ProtocolParticipant newProtocolParticipant) {
        this.newProtocolParticipant = newProtocolParticipant;
    }

    public boolean getModifySubjects() {
        return this.modifySubjects;
    }

    public boolean isRoleIRBAdmin() {
        Role roleInfo = this.getRoleService().getRoleByNamespaceCodeAndName("KC-UNT", "IRB Administrator");
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleInfo.getId());
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualifications = new HashMap(qualifiedRoleAttributes);
        return this.getRoleService().principalHasRole(this.getUserIdentifier(), roleIds, qualifications);
    }

    @Override
    protected boolean getProtocolProposalDevelopmentLinkingHook() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.development.proposal.linking.enabled");
    }

    @Override
    protected Class<? extends org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService> getProtocolFundingSourceServiceClassHook() {
        return ProtocolFundingSourceService.class;
    }

    @Override
    protected ProtocolFundingSourceBase getNewProtocolFundingSourceInstanceHook() {
        return new ProtocolFundingSource();
    }

    @Override
    protected ProtocolLocationBase getNewProtocolLocationInstanceHook() {
        return new ProtocolLocation();
    }

    @Override
    protected String getBillableParameterHook() {
        return "irb.protocol.billable";
    }

    @Override
    protected String getReferenceID1ParameterNameHook() {
        return "irb.protocol.referenceID1";
    }

    @Override
    protected String getReferenceID2ParameterNameHook() {
        return "irb.protocol.referenceID2";
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocol", (Protocol)protocol);
    }

    @Override
    public ProtocolTaskBase getNewInstanceModifyProtocolBillableTaskNewHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyBillable", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolGeneralInfoTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocolGeneralInfo", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolFundingSourceTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocolFundingSource", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolReferencesTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocolReferences", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolOrganizationsTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocolOrganizations", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceModifyProtocolResearchAreasTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocolAreasOfResearch", (Protocol)protocol);
    }

    @Override
    protected ProtocolTaskBase getNewInstanceCreateProposalDevelopmentTaskHook(ProtocolBase protocol) {
        return new ProtocolTask("createProposalForIrbProtocol", (Protocol)protocol);
    }

    @Override
    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook() {
        return ProtocolDocument.class;
    }

    @Override
    protected ProtocolActionBase createProtocolCreatedTypeProtocolActionInstanceHook(ProtocolBase protocol) {
        return new ProtocolAction((Protocol)protocol, null, "100");
    }

    @Override
    protected ProtocolUnitBase createNewProtocolUnitInstanceHook() {
        return new ProtocolUnit();
    }

    @Override
    protected ProtocolPersonBase createNewProtocolPersonInstanceHook() {
        return new ProtocolPerson();
    }
}

