/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.SaveProtocolFundingSourceLinkEvent;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class SaveProtocolFundingSourceLinkRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<SaveProtocolFundingSourceLinkEvent> {
    private static final String FUNDING_SOURCE_NUMBER = "fundingSourceNumber";
    private SpecialReviewService specialReviewService;
    private AwardService awardService;
    private InstitutionalProposalService institutionalProposalService;

    @Override
    public boolean processRules(SaveProtocolFundingSourceLinkEvent event) {
        boolean rulePassed = true;
        for (ProtocolFundingSourceBase protocolFundingSource : event.getProtocolFundingSources()) {
            String fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
            String fundingSourceTypeCode = protocolFundingSource.getFundingSourceTypeCode();
            String protocolNumber = protocolFundingSource.getProtocolNumber();
            if (this.getSpecialReviewService().isLinkedToSpecialReview(fundingSourceNumber, fundingSourceTypeCode, protocolNumber)) continue;
            rulePassed &= this.validateProtocolFundingSource((ProtocolFundingSource)protocolFundingSource);
        }
        for (ProtocolFundingSourceBase protocolFundingSource : event.getDeletedProtocolFundingSources()) {
            rulePassed &= this.validateProtocolFundingSource((ProtocolFundingSource)protocolFundingSource);
        }
        return rulePassed;
    }

    private boolean validateProtocolFundingSource(ProtocolFundingSource protocolFundingSource) {
        InstitutionalProposal institutionalProposal;
        boolean isValid = true;
        String fundingSourceType = protocolFundingSource.getFundingSourceTypeCode();
        String fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
        if (StringUtils.equals((String)"6", (String)String.valueOf(fundingSourceType))) {
            Award award = this.getAward(fundingSourceNumber);
            if (!award.getAwardDocument().getPessimisticLocks().isEmpty()) {
                isValid = false;
                this.reportError(FUNDING_SOURCE_NUMBER, "error.protocol.fundingSource.award.locked", fundingSourceNumber);
            }
        } else if (StringUtils.equals((String)"5", (String)String.valueOf(fundingSourceType)) && !(institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber)).getInstitutionalProposalDocument().getPessimisticLocks().isEmpty()) {
            isValid = false;
            this.reportError(FUNDING_SOURCE_NUMBER, "error.protocol.fundingSource.institutional.proposal.locked", fundingSourceNumber);
        }
        return isValid;
    }

    private Award getAward(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award;
    }

    private InstitutionalProposal getInstitutionalProposal(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal;
    }

    private SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = KraServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KraServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

