/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.participant;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.protocol.participant.AddProtocolParticipantEvent;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolParticipantRuleBase
extends ResearchDocumentRuleBase {
    private static final String DOT = ".";
    private static final String PARTICIPANT_TYPE_CODE_FIELD = "participantTypeCode";

    public boolean processAddProtocolParticipantEvent(AddProtocolParticipantEvent addProtocolParticipantEvent) {
        boolean rulePassed = true;
        ProtocolParticipant newProtocolParticipant = addProtocolParticipantEvent.getNewProtocolParticipant();
        List<ProtocolParticipant> protocolParticipants = addProtocolParticipantEvent.getProtocolParticipants();
        String errorPath = addProtocolParticipantEvent.getErrorPathPrefix();
        this.getKnsDictionaryValidationService().validateBusinessObject((BusinessObject)newProtocolParticipant);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        return rulePassed &= this.validateUniqueParticipantType(newProtocolParticipant, protocolParticipants, errorPath);
    }

    private boolean validateUniqueParticipantType(ProtocolParticipant newProtocolParticipant, List<ProtocolParticipant> protocolParticipants, String errorPath) {
        boolean isValid = true;
        for (ProtocolParticipant protocolParticipant : protocolParticipants) {
            if (!StringUtils.equals((String)protocolParticipant.getParticipantTypeCode(), (String)newProtocolParticipant.getParticipantTypeCode())) continue;
            isValid = false;
            this.reportError(errorPath + DOT + PARTICIPANT_TYPE_CODE_FIELD, "error.protocol.participantType.duplicate", new String[0]);
            break;
        }
        return isValid;
    }
}

