/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.questionnaire.SaveProtocolQuestionnaireEvent;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public class ProtocolQuestionnaireAction
extends ProtocolAction {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        Document document = protocolForm.getDocument();
        List<AnswerHeader> answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders();
        if (this.applyRules((KualiDocumentEvent)new SaveQuestionnaireAnswerEvent(document, answerHeaders)) && this.applyRules((KualiDocumentEvent)new SaveProtocolQuestionnaireEvent(document, answerHeaders))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
        }
    }

    @Override
    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolForm)form).getQuestionnaireHelper().updateQuestionnaireAnswer(this.getLineToDelete(request));
        this.getBusinessObjectService().save((PersistableBusinessObject)((ProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(this.getLineToDelete(request)));
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        if (request.getParameter("refreshCaller") != null && request.getParameter("refreshCaller").toString().equals("kualiLookupable")) {
            for (Object obj : request.getParameterMap().keySet()) {
                if (StringUtils.indexOf((String)((String)obj), (String)"questionnaireHelper.answerHeaders[") != 0) continue;
                ((ProtocolForm)form).getQuestionnaireHelper().updateChildIndicator(Integer.parseInt(StringUtils.substringBetween((String)((String)obj), (String)"questionnaireHelper.answerHeaders[", (String)"].answers[")));
            }
        }
        return forward;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        ((ProtocolForm)form).getQuestionnaireHelper().prepareView();
        ((ProtocolForm)form).getQuestionnaireHelper().populateAnswers();
        ((ProtocolForm)form).getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return actionForward;
    }

    @Override
    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<AnswerHeader> answerHeaders;
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        Document document = protocolForm.getDocument();
        if (this.applyRules((KualiDocumentEvent)new SaveQuestionnaireAnswerEvent(document, answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders()))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
            forward = super.saveOnClose(mapping, form, request, response);
        }
        return forward;
    }

    @Override
    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProtocolForm protocolForm = (ProtocolForm)form;
        int answerHeaderIndex = this.getSelectedLine(request);
        reportParameters.put("questionnaireId", ((ProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(answerHeaderIndex).getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", ((ProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(answerHeaderIndex).getQuestionnaire().getTemplate());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(protocolForm.getProtocolDocument().getProtocol(), reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward summaryQuestionnairePop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String protocolNumber;
        ProtocolForm protocolForm = (ProtocolForm)form;
        String sequenceNumber = request.getParameter(SEQUENCE_NUMBER);
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean("7", protocolNumber, (protocolNumber = request.getParameter(PROTOCOL_NUMBER)).contains("A") || protocolNumber.contains("R") ? "1" : "0", sequenceNumber, true);
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean));
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getAnsweredQuestionnaire(protocolForm.getQuestionnaireHelper().getAnswerHeaders()));
        ActionForward forward = mapping.findForward("viewQuestionnaire");
        protocolForm.getQuestionnaireHelper().resetHeaderLabels();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return forward;
    }

    public ActionForward summaryQuestionnaireAjax(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String sequenceNumber = request.getParameter(SEQUENCE_NUMBER);
        String protocolNumber = request.getParameter(PROTOCOL_NUMBER);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, protocolNumber);
        keyValues.put(SEQUENCE_NUMBER, sequenceNumber);
        Protocol protocol = (Protocol)((List)this.getBusinessObjectService().findMatching(Protocol.class, keyValues)).get(0);
        String subModuleCode = "0";
        if (protocol.isRenewal()) {
            subModuleCode = "1";
            if (protocol.isRenewalWithoutAmendment()) {
                subModuleCode = "3";
            }
        }
        if (protocol.isAmendment()) {
            subModuleCode = "4";
        }
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean("7", protocolNumber, subModuleCode, sequenceNumber, true);
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean));
        if (protocol.isAmendment() || protocol.isRenewal()) {
            moduleQuestionnaireBean.setModuleSubItemCode("0");
            List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
            if (!answerHeaders.isEmpty()) {
                protocolForm.getQuestionnaireHelper().getAnswerHeaders().addAll(answerHeaders);
            }
        }
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getAnsweredQuestionnaire(protocolForm.getQuestionnaireHelper().getAnswerHeaders()));
        ActionForward forward = mapping.findForward("ajaxQuestionnaire");
        protocolForm.getQuestionnaireHelper().resetHeaderLabels();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return forward;
    }

    private List<AnswerHeader> getAnsweredQuestionnaire(List<AnswerHeader> answerHeaders) {
        ArrayList<AnswerHeader> savedHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : answerHeaders) {
            if (answerHeader.getAnswerHeaderId() == null) continue;
            savedHeaders.add(answerHeader);
        }
        return savedHeaders;
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }
}

