/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = Logger.getLogger(ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl.class);
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        Committee committee;
        Protocol protocol;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String protocolNumber = qualification.get("protocol");
        if (StringUtils.isNotBlank((String)protocolNumber) && (protocol = this.getProtocolByNumber(protocolNumber)) != null && protocol.getProtocolSubmission() != null && (committee = protocol.getProtocolSubmission().getCommittee()) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (membership.getPersonId() == null || !membership.isActive()) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)membership.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        Committee committee;
        Protocol protocol;
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        if (StringUtils.isNotBlank((String)protocolNumber) && (protocol = this.getProtocolByNumber(protocolNumber)) != null && protocol.getProtocolSubmission() != null && (committee = protocol.getProtocolSubmission().getCommittee()) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (membership.getPersonId() == null || !StringUtils.equals((String)principalId, (String)membership.getPersonId())) continue;
                return true;
            }
        }
        return false;
    }

    private Protocol getProtocolByNumber(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        return (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, keymap);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

