/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.bo.AffiliationType;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class IacucProtocolAffiliateTypeDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = Logger.getLogger(IacucProtocolAffiliateTypeDerivedRoleTypeServiceImpl.class);
    protected List<String> requiredAttributes = new ArrayList<String>();

    public IacucProtocolAffiliateTypeDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                if (!StringUtils.equals((String)this.getAffiliationType(person.getAffiliationType().getAffiliationTypeCode()), (String)roleName) || !StringUtils.isNotBlank((String)person.getPerson().getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)person.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                if (!StringUtils.equals((String)principalId, (String)person.getPersonId()) || !StringUtils.equals((String)roleName, (String)this.getAffiliationType(person.getAffiliationType().getAffiliationTypeCode()))) continue;
                return true;
            }
        }
        return false;
    }

    private IacucProtocol getProtocol(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        return (IacucProtocol)this.getBusinessObjectService().findByPrimaryKey(IacucProtocol.class, keymap);
    }

    private String getAffiliationType(Integer affiliationTypeCode) {
        String result = null;
        if (affiliationTypeCode != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("affiliationTypeCode", affiliationTypeCode.toString());
            List affiliationTypes = (List)this.getBusinessObjectService().findMatching(AffiliationType.class, fieldValues);
            if (CollectionUtils.isNotEmpty((Collection)affiliationTypes)) {
                result = ((AffiliationType)((Object)affiliationTypes.get(0))).getDescription();
            }
        }
        return result;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

