/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.OrganizationCorrespondent;
import org.kuali.kra.service.OrganizationService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class OrganizationCorrespondentRoleServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private OrganizationService organizationService;

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String organizationId = qualification.get("organizationId");
        if (StringUtils.isNotBlank((String)organizationId)) {
            List<OrganizationCorrespondent> organizationCorrespondents = this.organizationService.retrieveOrganizationCorrespondentsByOrganizationId(organizationId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!organizationCorrespondent.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String organizationId = qualification.get("organizationId");
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((String)organizationId)) {
            List<OrganizationCorrespondent> organizationCorrespondents = this.organizationService.retrieveOrganizationCorrespondentsByOrganizationId(organizationId);
            for (OrganizationCorrespondent organizationCorrespondent : organizationCorrespondents) {
                if (!StringUtils.isNotBlank((String)organizationCorrespondent.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)organizationCorrespondent.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

