/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.kim.service.ProposalRoleService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.type.KimType;

public class ProposalRoleServiceImpl
implements ProposalRoleService {
    private SystemAuthorizationService systemAuthorizationService;

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    @Override
    public List<Role> getRoles() {
        return this.systemAuthorizationService.getRoles("KC-PD");
    }

    protected boolean isStandardProposalRole(String roleName) {
        return StringUtils.equals((String)roleName, (String)"Aggregator") || StringUtils.equals((String)roleName, (String)"Narrative Writer") || StringUtils.equals((String)roleName, (String)"Budget Creator") || StringUtils.equals((String)roleName, (String)"Viewer");
    }

    protected boolean isRoleUnassigned(String roleName) {
        return StringUtils.equals((String)roleName, (String)"unassigned");
    }

    @Override
    public List<Role> getRolesForDisplay() {
        List<Role> proposalRoles = this.getRoles();
        ArrayList<Role> finalRoleList = new ArrayList<Role>();
        for (Role role : proposalRoles) {
            if (this.isRoleUnassigned(role.getName())) {
                finalRoleList.add(role);
                continue;
            }
            if (!this.isStandardProposalRole(role.getName())) continue;
            finalRoleList.add(role);
        }
        for (Role role : proposalRoles) {
            if (this.isRoleUnassigned(role.getName()) || this.isStandardProposalRole(role.getName())) continue;
            finalRoleList.add(role);
        }
        this.filterDerivedRoles(finalRoleList);
        return finalRoleList;
    }

    protected void filterDerivedRoles(List<Role> roles) {
        Iterator<Role> iter = roles.iterator();
        while (iter.hasNext()) {
            Role role = iter.next();
            KimType type = this.systemAuthorizationService.getKimTypeInfoForRole(role);
            if (!StringUtils.startsWith((String)type.getName(), (String)"Derived Role") && !StringUtils.startsWith((String)type.getName(), (String)"Default")) continue;
            iter.remove();
        }
    }
}

