/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class UnitCorrespondentRoleServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private UnitService unitService;

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String unitNumber = qualification.get("unitNumber");
        if (StringUtils.isNotBlank((String)unitNumber)) {
            List<UnitAdministrator> unitAdministrators = this.unitService.retrieveUnitAdministratorsByUnitNumber(unitNumber);
            for (UnitAdministrator unitAdministrator : unitAdministrators) {
                if (!unitAdministrator.getPersonId().equals(principalId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String unitNumber = qualification.get("unitNumber");
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (StringUtils.isNotBlank((String)unitNumber)) {
            List<UnitAdministrator> unitAdministrators = this.unitService.retrieveUnitAdministratorsByUnitNumber(unitNumber);
            for (UnitAdministrator unitAdministrator : unitAdministrators) {
                if (!StringUtils.isNotBlank((String)unitAdministrator.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)unitAdministrator.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

