/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.krms;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.engine.TermResolver;

public class QuestionResolver
implements TermResolver<Object> {
    private String outputName;
    private Set<String> prereqs;
    private Set<String> params;

    public QuestionResolver(String outputName, Set<String> params) {
        this.outputName = outputName;
        this.prereqs = new HashSet<String>();
        this.prereqs.add("moduleCode");
        this.prereqs.add("moduleItemKey");
        this.params = params == null ? Collections.emptySet() : params;
    }

    public int getCost() {
        return 1;
    }

    public String getOutput() {
        return this.outputName;
    }

    public Set<String> getPrerequisites() {
        return this.prereqs;
    }

    public Set<String> getParameterNames() {
        return this.params;
    }

    public String resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
        String questionnaireId = parameters.get("Questionnaire Ref ID");
        String questionId = parameters.get("Question ID");
        String moduleCode = (String)resolvedPrereqs.get("moduleCode");
        String moduleItemKey = (String)resolvedPrereqs.get("moduleItemKey");
        List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswers(moduleCode, moduleItemKey);
        for (AnswerHeader answerHeader : answerHeaders) {
            if (!answerHeader.getQuestionnaireRefIdFk().equals(questionnaireId)) continue;
            for (Answer answer : answerHeader.getAnswers()) {
                if (!answer.getQuestion().getQuestionId().equals(questionId)) continue;
                return answer.getAnswer();
            }
        }
        return "";
    }

    protected List<AnswerHeader> getQuestionnaireAnswers(String moduleCode, String moduleItemKey) {
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", moduleCode);
        fieldValues.put("moduleItemKey", moduleItemKey);
        return (List)boService.findMatching(AnswerHeader.class, fieldValues);
    }
}

