/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.krms;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.impl.provider.repository.LazyAgendaTree;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.type.AgendaTypeServiceBase;
import org.kuali.rice.krms.impl.util.KRMSServiceLocatorInternal;

public class UnitAgendaTypeService
extends AgendaTypeServiceBase {
    public static final String UNIT_AGENDA_TYPE_ID = "KC1000";
    public static final String QUESTIONNAIRE_AGENDA_TYPE_ID = "KC1004";

    public RemotableAttributeField translateTypeAttribute(KrmsTypeAttribute inputAttribute, KrmsAttributeDefinition attributeDefinition) {
        if ("Unit Number".equals(attributeDefinition.getName())) {
            return this.createUnitField();
        }
        return super.translateTypeAttribute(inputAttribute, attributeDefinition);
    }

    private RemotableAttributeField createUnitField() {
        RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(30));
        controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(40));
        controlBuilder.setWatermark("unit number");
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)"Unit Number");
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel("Unit Number");
        builder.setShortLabel("Unit Number");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(40));
        return builder.build();
    }

    public Agenda loadAgenda(AgendaDefinition agendaDefinition) {
        if (agendaDefinition == null) {
            throw new RiceIllegalArgumentException("agendaDefinition must not be null");
        }
        RepositoryToEngineTranslator repositoryToEngineTranslator = KRMSServiceLocatorInternal.getRepositoryToEngineTranslator();
        if (repositoryToEngineTranslator == null) {
            return null;
        }
        return new UnitAgenda(agendaDefinition.getAttributes(), (AgendaTree)new LazyAgendaTree(agendaDefinition, repositoryToEngineTranslator), agendaDefinition.getTypeId(), agendaDefinition.isActive());
    }

    private static class UnitAgenda
    extends BasicAgenda {
        private Map<String, String> qualifiers;
        private boolean isActive;

        public UnitAgenda(Map<String, String> qualifiers, AgendaTree agendaTree, String agendaTypeId, boolean isActive) {
            super(qualifiers, agendaTree);
            this.isActive = isActive;
            this.qualifiers = new HashMap<String, String>(qualifiers);
            this.qualifiers.put("typeId", agendaTypeId);
        }

        public boolean appliesTo(ExecutionEnvironment environment) {
            if (!this.isActive) {
                return false;
            }
            for (Map.Entry agendaQualifier : environment.getSelectionCriteria().getAgendaQualifiers().entrySet()) {
                String agendaQualifierValue = this.qualifiers.get(agendaQualifier.getKey());
                String environmentQualifierValue = (String)agendaQualifier.getValue();
                if (!("Unit Number".equals(agendaQualifier.getKey()) ? !environmentQualifierValue.equals(agendaQualifierValue) && !this.isChildUnit(environmentQualifierValue, agendaQualifierValue) : !environmentQualifierValue.equals(agendaQualifierValue))) continue;
                return false;
            }
            return true;
        }

        private boolean isChildUnit(String childNumber, String parentNumber) {
            UnitService unitService = KraServiceLocator.getService(UnitService.class);
            Unit childUnit = unitService.getUnit(childNumber);
            Unit parentUnit = unitService.getUnit(parentNumber);
            return childUnit.isParentUnit(parentUnit);
        }
    }
}

