/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.krms.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KcKrmsCacheManager;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.ResultEvent;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.BasicRule;

public class KrmsRulesExecutionServiceImpl
implements KrmsRulesExecutionService {
    protected final Log LOG = LogFactory.getLog(KrmsRulesExecutionServiceImpl.class);
    private KcKrmsCacheManager kcKrmsCacheManager;

    @Override
    public List<String> processUnitValidations(String unitNumber, KrmsRulesContext rulesContext) {
        this.kcKrmsCacheManager.clearCache();
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        rulesContext.populateContextQualifiers(contextQualifiers);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        Facts.Builder factsBuilder = Facts.Builder.create();
        rulesContext.addFacts(factsBuilder);
        Engine engine = KrmsApiServiceLocator.getEngine();
        if (engine == null) {
            this.LOG.error((Object)"Could not resolve KRMS Rules Engine - Unit Validations will not be evaluated!");
        } else {
            EngineResults results = engine.execute(selectionCriteria, factsBuilder.build(), null);
            if (results != null) {
                String errors = (String)results.getAttribute("validations");
                if (errors != null) {
                    String[] errorArray = StringUtils.split((String)errors, (String)",");
                    return Arrays.asList(errorArray);
                }
            } else {
                this.LOG.warn((Object)"Results returned from KRMS Rules Engine was null.");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Boolean> runApplicableRules(List<String> ruleIds, KrmsRulesContext rulesContext, String agendaTypeId) {
        HashMap<String, Boolean> ruleResults = new HashMap<String, Boolean>();
        if (rulesContext != null) {
            String namespace = rulesContext.getClass().getAnnotation(ParameterConstants.NAMESPACE.class).namespace();
            HashMap<String, String> contextQualifiers = new HashMap<String, String>();
            rulesContext.populateContextQualifiers(contextQualifiers);
            HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
            rulesContext.populateAgendaQualifiers(agendaQualifiers);
            agendaQualifiers.put("typeId", agendaTypeId);
            contextQualifiers.put("namespaceCode", namespace);
            SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, agendaQualifiers);
            Facts.Builder factsBuilder = Facts.Builder.create();
            rulesContext.addFacts(factsBuilder);
            ExecutionOptions xOptions = new ExecutionOptions();
            xOptions.setFlag(ExecutionFlag.LOG_EXECUTION, true);
            EngineResults results = KrmsApiServiceLocator.getEngine().execute(selectionCriteria, factsBuilder.build(), xOptions);
            List ruleDefinitions = KrmsApiServiceLocator.getRuleRepositoryService().getRules(ruleIds);
            HashMap<String, RuleDefinition> ruleMap = new HashMap<String, RuleDefinition>();
            for (RuleDefinition rule : ruleDefinitions) {
                ruleMap.put(rule.getName(), rule);
            }
            if (results.getResultsOfType("Rule Evaluated") != null && results.getResultsOfType("Rule Evaluated").size() > 0) {
                for (ResultEvent resultEvent : results.getResultsOfType("Rule Evaluated")) {
                    String ruleName = ((BasicRule)resultEvent.getSource()).getName();
                    if (!ruleMap.containsKey(ruleName)) continue;
                    ruleResults.put(((RuleDefinition)ruleMap.get(ruleName)).getId(), resultEvent.getResult());
                }
            }
        }
        return ruleResults;
    }

    public KcKrmsCacheManager getKcKrmsCacheManager() {
        return this.kcKrmsCacheManager;
    }

    public void setKcKrmsCacheManager(KcKrmsCacheManager kcKrmsCacheManager) {
        this.kcKrmsCacheManager = kcKrmsCacheManager;
    }
}

