/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetExpenseLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final String KFS_ON_PARM_NMSPC_CD = "KC-AWARD";
    private static final String KFS_ON_PARM_DTL_TYP_CD = "Document";
    private static final String KFS_ON_PARM_NM = "FIN_SYSTEM_INTEGRATION_ON";
    private static final String KFS_ON_OFF_VALUE = "OFF";
    private static final String KFS_FIELD_NAME = "financialObjectCode";

    public List<Row> getRows() {
        List oldRows = super.getRows();
        String kfsOnParameterValue = this.getParameterService().getParameterValueAsString(KFS_ON_PARM_NMSPC_CD, KFS_ON_PARM_DTL_TYP_CD, KFS_ON_PARM_NM);
        ArrayList<Row> rows = new ArrayList<Row>();
        if (!StringUtils.equals((String)kfsOnParameterValue, (String)KFS_ON_OFF_VALUE)) {
            rows.addAll(oldRows);
        } else {
            for (Row oldRow : oldRows) {
                Row row = new Row();
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field oldField : oldRow.getFields()) {
                    if (StringUtils.equals((String)oldField.getPropertyName(), (String)KFS_FIELD_NAME)) continue;
                    fields.add(oldField);
                }
                row.setFields(fields);
                rows.add(row);
            }
        }
        return rows;
    }

    public List<Column> getColumns() {
        List oldColumns = super.getColumns();
        String kfsOnParameterValue = this.getParameterService().getParameterValueAsString(KFS_ON_PARM_NMSPC_CD, KFS_ON_PARM_DTL_TYP_CD, KFS_ON_PARM_NM);
        ArrayList<Column> columns = new ArrayList<Column>();
        if (!StringUtils.equals((String)kfsOnParameterValue, (String)KFS_ON_OFF_VALUE)) {
            columns.addAll(oldColumns);
        } else {
            for (Column oldColumn : oldColumns) {
                if (StringUtils.equals((String)oldColumn.getPropertyName(), (String)KFS_FIELD_NAME)) continue;
                columns.add(oldColumn);
            }
        }
        return columns;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        String budgetCategoryTypeCode = fieldValues.get("budgetCategoryTypeCode");
        fieldValues.remove("budgetCategoryTypeCode");
        ArrayList<CostElement> searchResultsReturn = new ArrayList<CostElement>();
        String categoryTypeName = null;
        if (fieldValues.get("onOffCampusFlag").equalsIgnoreCase("Y")) {
            fieldValues.put("onOffCampusFlag", "N");
        } else if (fieldValues.get("onOffCampusFlag").equalsIgnoreCase("N")) {
            fieldValues.put("onOffCampusFlag", "F");
        }
        List searchResults = super.getSearchResults(fieldValues);
        for (CostElement costElement : searchResults) {
            costElement.refreshReferenceObject("budgetCategory");
            if (!StringUtils.isBlank((String)budgetCategoryTypeCode) && !StringUtils.equalsIgnoreCase((String)costElement.getBudgetCategory().getBudgetCategoryTypeCode(), (String)budgetCategoryTypeCode)) continue;
            searchResultsReturn.add(costElement);
            if (categoryTypeName != null) continue;
            categoryTypeName = costElement.getBudgetCategory().getBudgetCategoryType().getDescription();
        }
        if (StringUtils.isNotBlank((String)budgetCategoryTypeCode)) {
            KNSGlobalVariables.getMessageList().add("budget.expense.lookup.message1", new String[0]);
        }
        return searchResultsReturn;
    }
}

