/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPersonLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String PERSON_CAMPUS_CODE_FIELD = "campusCode";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = "org.kuali.rice.location.impl.campus.CampusBo";
    private KcPersonService kcPersonService;

    public List<Row> getRows() {
        List rows = super.getRows();
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(PERSON_CAMPUS_CODE_FIELD)) continue;
                field.setFieldConversions("code:" + field.getPropertyName());
                field.setLookupParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setInquiryParameters(field.getPropertyName() + ":" + CAMPUS_CODE_FIELD);
                field.setQuickFinderClassNameImpl(CAMPUS_LOOKUPABLE_CLASS_NAME);
                field.setFieldDirectInquiryEnabled(true);
                if (!multiCampusEnabled || !StringUtils.isBlank((String)field.getDefaultValue())) continue;
                String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
                field.setDefaultValue(campusCode);
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return rows;
    }

    public List<KcPerson> getSearchResults(Map<String, String> fieldValues) {
        this.kcPersonService.modifyFieldValues(fieldValues);
        this.businessObjectClass = PersonImpl.class;
        List personResults = super.getSearchResults(fieldValues);
        this.businessObjectClass = KcPerson.class;
        return this.kcPersonService.createKcPersonsFromPeople(personResults);
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

