/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.MultiCampusIdentityService;
import org.kuali.rice.kns.lookup.PessimisticLockLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class KraPessimisticLockLookupableHelperServiceImpl
extends PessimisticLockLookupableHelperServiceImpl {
    private static final long serialVersionUID = -4452653608498574503L;
    private static final String PRINCIPAL_NAME_FIELD = "ownedByUser.principalName";
    private static final String GEN_TIMESTAMP_FORMAT = "MM/dd/yyyy";
    private static final String GEN_TIMESTAMP_NAME = "generatedTimestamp";
    private static final String DATE_RANGE_DELIMETER = "..";
    private static final Log LOG = LogFactory.getLog(KraPessimisticLockLookupableHelperServiceImpl.class);
    private MultiCampusIdentityService multiCampusIdentityService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        if (fieldValues == null) {
            throw new NullPointerException("the fieldValues is null");
        }
        this.addSingleDayDateRange(fieldValues);
        return super.getSearchResults(fieldValues);
    }

    public void validateSearchParameters(Map fieldValues) {
        this.addMultiCampusPrincipalName(fieldValues);
        super.validateSearchParameters(fieldValues);
    }

    protected void addMultiCampusPrincipalName(Map<String, String> fieldValues) {
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (multiCampusEnabled && StringUtils.isNotBlank((String)fieldValues.get(PRINCIPAL_NAME_FIELD))) {
            String principalName = fieldValues.get(PRINCIPAL_NAME_FIELD);
            String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
            String multiCampusPrincipalName = this.getMultiCampusIdentityService().getMultiCampusPrincipalName(principalName, campusCode);
            fieldValues.put(PRINCIPAL_NAME_FIELD, multiCampusPrincipalName);
        }
    }

    protected void addSingleDayDateRange(Map<String, String> fieldValues) {
        block4: {
            assert (fieldValues != null) : "the fieldValues is null";
            String timeStamp = fieldValues.get(GEN_TIMESTAMP_NAME);
            if (timeStamp != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(GEN_TIMESTAMP_FORMAT);
                try {
                    Date d = sdf.parse(timeStamp);
                    String dateRange = this.buildDateRange(timeStamp, this.getNextDateString(d));
                    fieldValues.put(GEN_TIMESTAMP_NAME, dateRange);
                }
                catch (ParseException e) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info((Object)"expected generated time at the following format MM/dd/yyyy");
                }
            }
        }
    }

    protected String getNextDateString(Date d) {
        assert (d != null) : "the date is null";
        SimpleDateFormat sdf = new SimpleDateFormat(GEN_TIMESTAMP_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(5, 1);
        return sdf.format(cal.getTime());
    }

    protected String buildDateRange(String leftDate, String rightDate) {
        assert (leftDate != null) : "the leftDate is null";
        assert (rightDate != null) : "the rightDate is null";
        StringBuilder range = new StringBuilder();
        range.append(leftDate);
        range.append(DATE_RANGE_DELIMETER);
        range.append(rightDate);
        return range.toString();
    }

    public MultiCampusIdentityService getMultiCampusIdentityService() {
        if (this.multiCampusIdentityService == null) {
            this.multiCampusIdentityService = KraServiceLocator.getService(MultiCampusIdentityService.class);
        }
        return this.multiCampusIdentityService;
    }

    public void setMultiCampusIdentityService(MultiCampusIdentityService multiCampusIdentityService) {
        this.multiCampusIdentityService = multiCampusIdentityService;
    }
}

