/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.web.format.TimestampAMPMFormatter;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class S2sOpportunityLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private S2SService s2SService;
    private DateTimeService dateTimeService;
    private static final Log LOG = LogFactory.getLog(S2sOpportunityLookupableHelperServiceImpl.class);

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LookupUtils.removeHiddenCriteriaFields((Class)this.getBusinessObjectClass(), fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        KNSGlobalVariables.getMessageList().add("message.grantsgov.link", new String[0]);
        List<Object> s2sOpportunity = new ArrayList();
        String providerCode = fieldValues.get("providerCode");
        String cfdaNumber = fieldValues.get("cfdaNumber");
        String opportunityId = fieldValues.get("opportunityId");
        if (StringUtils.isBlank((String)providerCode)) {
            GlobalVariables.getMessageMap().putError("providerCode", "error.s2sopportunity.invalidProvider", new String[0]);
            return new ArrayList();
        }
        if (StringUtils.isNotBlank((String)cfdaNumber) || StringUtils.isNotBlank((String)opportunityId)) {
            try {
                s2sOpportunity = this.s2SService.searchOpportunity(providerCode, cfdaNumber, opportunityId, "");
            }
            catch (S2SException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                GlobalVariables.getMessageMap().putError("noField", e.getErrorKey(), new String[]{e.getMessage()});
                return new ArrayList();
            }
            if (s2sOpportunity != null && s2sOpportunity.size() != 0) {
                return s2sOpportunity;
            }
            if (StringUtils.isNotBlank((String)cfdaNumber) && StringUtils.isNotBlank((String)opportunityId)) {
                try {
                    s2sOpportunity = this.s2SService.searchOpportunity(providerCode, cfdaNumber, "", "");
                }
                catch (S2SException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    GlobalVariables.getMessageMap().putError("noField", e.getErrorKey(), new String[]{e.getMessage()});
                    return new ArrayList();
                }
                if (s2sOpportunity != null) {
                    return s2sOpportunity;
                }
                if (StringUtils.isNotBlank((String)cfdaNumber)) {
                    GlobalVariables.getMessageMap().putError("cfdaNumber", "error.s2sopportunity.cfdaNumberInvalid", new String[0]);
                }
                if (StringUtils.isNotBlank((String)opportunityId)) {
                    GlobalVariables.getMessageMap().putError("opportunityId", "error.s2sopportunity.opportunityIdInvalid", new String[0]);
                }
                return new ArrayList();
            }
            return new ArrayList();
        }
        GlobalVariables.getMessageMap().putError("noField", "error.s2sopportunity.cfdaNumber_opportunityId_null", new String[0]);
        return s2sOpportunity;
    }

    public S2SService getS2SService() {
        return this.s2SService;
    }

    public void setS2SService(S2SService service) {
        this.s2SService = service;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        boolean showReturnLink = lookupForm.getBackLocation().contains("proposalDevelopmentGrantsGov");
        Collection displayList = super.performLookup(lookupForm, resultTable, bounded);
        for (ResultRow row : resultTable) {
            List columns = row.getColumns();
            for (Column col : columns) {
                if (!StringUtils.equalsIgnoreCase((String)col.getColumnTitle(), (String)"Instruction Page") && !StringUtils.equalsIgnoreCase((String)col.getColumnTitle(), (String)"Schema URL")) continue;
                col.setPropertyURL(col.getPropertyValue());
            }
        }
        return displayList;
    }

    public HtmlData getReturnUrl(BusinessObject businessObject, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        boolean showReturnLink = lookupForm.getBackLocation().contains("proposalDevelopmentGrantsGov");
        if (showReturnLink) {
            return super.getReturnUrl(businessObject, lookupForm, returnKeys, businessObjectRestrictions);
        }
        return this.getCreateLink((S2sOpportunity)businessObject);
    }

    protected HtmlData.AnchorHtmlData getCreateLink(S2sOpportunity opp) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("Create Proposal");
        Properties parameters = new Properties();
        parameters.put("createProposalFromGrantsGov", "true");
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "ProposalDevelopmentDocument");
        parameters.put("newS2sOpportunity.cfdaNumber", opp.getCfdaNumber() != null ? opp.getCfdaNumber() : "");
        parameters.put("newS2sOpportunity.opportunityId", opp.getOpportunityId() != null ? opp.getOpportunityId() : "");
        parameters.put("newS2sOpportunity.opportunityTitle", opp.getOpportunityTitle() != null ? opp.getOpportunityTitle() : "");
        parameters.put("newS2sOpportunity.closingDate", opp.getClosingDate() != null ? this.getDateTimeService().toDateTimeString((Date)opp.getClosingDate()) : "");
        parameters.put("newS2sOpportunity.openingDate", opp.getOpeningDate() != null ? this.getDateTimeService().toDateTimeString((Date)opp.getOpeningDate()) : "");
        parameters.put("newS2sOpportunity.instructionUrl", opp.getInstructionUrl() != null ? opp.getInstructionUrl() : "");
        parameters.put("newS2sOpportunity.competetionId", opp.getCompetetionId() != null ? opp.getCompetetionId() : "");
        parameters.put("newS2sOpportunity.schemaUrl", opp.getSchemaUrl() != null ? opp.getSchemaUrl() : "");
        parameters.put("newS2sOpportunity.providerCode", opp.getProviderCode());
        String href = UrlFactory.parameterizeUrl((String)"../proposalDevelopmentProposal.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected Properties getParameters(BusinessObject bo, Map fieldConversions, String lookupImpl, List returnKeys) {
        Properties parameters = super.getParameters(bo, fieldConversions, lookupImpl, returnKeys);
        for (String fieldNm : this.getReturnKeys()) {
            Object fieldVal = ObjectUtils.getPropertyValue((Object)bo, (String)fieldNm);
            if (!(fieldVal instanceof Timestamp)) continue;
            TimestampAMPMFormatter timestampFormatter = new TimestampAMPMFormatter();
            fieldVal = timestampFormatter.format(fieldVal);
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = (String)fieldConversions.get(fieldNm);
            }
            parameters.setProperty(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KraServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

