/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;

public class SponsorLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final String HIERARCHY_NAME = "hierarchyName";
    private static final String SELECTED_HIERARCHY_NAME = "selectedHierarchyName";
    protected static final String ACTIVE_FIELD_NAME = "active";
    protected static final String ACTIVE_FIELD_DEFAULT_VALUE_YES = "Y";
    protected static final String ACTIVE_FIELD_DEFAULT_VALUE_NO = "N";

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List<Object> existSponsorCodeList;
        if (!fieldValues.containsKey(ACTIVE_FIELD_NAME)) {
            fieldValues.put(ACTIVE_FIELD_NAME, ACTIVE_FIELD_DEFAULT_VALUE_YES);
        }
        boolean forceActiveFlagRestriction = false;
        boolean activeFlagValue = true;
        if (StringUtils.equalsIgnoreCase((String)fieldValues.get(ACTIVE_FIELD_NAME), (String)ACTIVE_FIELD_DEFAULT_VALUE_YES)) {
            forceActiveFlagRestriction = true;
            activeFlagValue = true;
        } else if (StringUtils.equalsIgnoreCase((String)fieldValues.get(ACTIVE_FIELD_NAME), (String)ACTIVE_FIELD_DEFAULT_VALUE_NO)) {
            forceActiveFlagRestriction = true;
            activeFlagValue = false;
        } else {
            forceActiveFlagRestriction = false;
            activeFlagValue = true;
        }
        ArrayList<Sponsor> searchResultsReturn = new ArrayList<Sponsor>();
        KualiForm kualiForm = KNSGlobalVariables.getKualiForm();
        List searchResults = kualiForm == null || !(kualiForm instanceof MultipleValueLookupForm) ? super.getSearchResults(fieldValues) : super.getSearchResultsHelper(fieldValues, true);
        Object hierarchyName = GlobalVariables.getUserSession().retrieveObject(HIERARCHY_NAME);
        Object selectedHierarchyName = GlobalVariables.getUserSession().retrieveObject(SELECTED_HIERARCHY_NAME);
        String sponsorsCodes = "";
        boolean isNewHierarchy = false;
        String existSponsors = (String)GlobalVariables.getUserSession().retrieveObject("sponsorCodes");
        if (existSponsors != null) {
            String[] existSponsorCodeArray = existSponsors.split(";");
            existSponsorCodeList = Arrays.asList(existSponsorCodeArray);
        } else {
            existSponsorCodeList = new ArrayList();
        }
        if (selectedHierarchyName != null) {
            sponsorsCodes = KraServiceLocator.getService(SponsorService.class).loadToSponsorHierachyMt(selectedHierarchyName.toString());
            isNewHierarchy = true;
        } else if (existSponsors == null) {
            String hierarchyNameString = hierarchyName != null ? hierarchyName.toString() : "";
            sponsorsCodes = KraServiceLocator.getService(SponsorService.class).loadToSponsorHierachyMt(hierarchyNameString);
        } else {
            sponsorsCodes = existSponsors;
        }
        String[] sponsorArray = sponsorsCodes.split(";");
        List<String> sponsorList = Arrays.asList(sponsorArray);
        int i = 0;
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(Sponsor.class);
        for (Sponsor sponsor : searchResults) {
            boolean allow = true;
            if (forceActiveFlagRestriction && activeFlagValue != sponsor.isActive()) {
                allow = false;
            }
            if (allow) {
                if (isNewHierarchy) {
                    if (!existSponsorCodeList.contains(sponsor.getSponsorCode())) {
                        ++i;
                        searchResultsReturn.add(sponsor);
                    }
                } else if (!sponsorList.contains(sponsor.getSponsorCode())) {
                    ++i;
                    searchResultsReturn.add(sponsor);
                }
            }
            if (i < searchResultsLimit) continue;
            break;
        }
        return new CollectionIncomplete(searchResultsReturn, new Long(searchResults.size()));
    }
}

