/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.maintenance;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Ynq;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.service.YnqService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class OrganizationMaintenableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 7123853550462673935L;
    public static final String ORGANIZATION_ID_SEQUENCE_NAME = "SEQ_ORGANIZATION_ID";
    public static final String AUTO_GEN_ORGANIZATION_ID_PARM = "AUTO_GENERATE_ORGANIZATION_ID";
    public static final String SECTION_ID = "Edit Organization";
    public static final String ORGANIZATION_ID_NAME = "organizationId";
    private transient ParameterService parameterService;
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        if (this.getBusinessObject().getOrganizationYnqs() == null || this.getBusinessObject().getOrganizationYnqs().isEmpty()) {
            this.initOrganizationYnq();
        }
        if (this.isAutoGenerateCode()) {
            Organization organization = this.getBusinessObject();
            organization.setOrganizationId(this.getSequenceAccessorService().getNextAvailableSequenceNumber(ORGANIZATION_ID_SEQUENCE_NAME, Organization.class).toString());
        }
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        Organization organization = this.getBusinessObject();
        if (organization.getOrganizationYnqs() == null || organization.getOrganizationYnqs().isEmpty()) {
            this.initOrganizationYnq();
        }
        return super.getCoreSections(document, oldMaintainable);
    }

    private void initOrganizationYnq() {
        Organization organization = this.getBusinessObject();
        List<OrganizationYnq> organizationYnqs = organization.getOrganizationYnqs();
        if (!organizationYnqs.isEmpty()) {
            throw new AssertionError();
        }
        List<Ynq> ynqs = this.getOrganizationTypeYnqs();
        for (Ynq ynq : ynqs) {
            OrganizationYnq organizationYnq = new OrganizationYnq();
            organizationYnq.setYnq(ynq);
            organizationYnq.setQuestionId(ynq.getQuestionId());
            if (StringUtils.isNotBlank((String)organization.getOrganizationId())) {
                organizationYnq.setOrganizationId(organization.getOrganizationId());
            }
            organizationYnqs.add(organizationYnq);
        }
    }

    private List<Ynq> getOrganizationTypeYnqs() {
        return KraServiceLocator.getService(YnqService.class).getYnq("O");
    }

    public Map<String, String> populateBusinessObject(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        Map map = super.populateBusinessObject(fieldValues, maintenanceDocument, methodToCall);
        this.formatCongressionalDistrict(this.getBusinessObject());
        return map;
    }

    private void formatCongressionalDistrict(Organization organization) {
        int dashPosition;
        String district = organization.getCongressionalDistrict();
        if (district != null && (dashPosition = district.indexOf(45)) >= 0) {
            String stateCodePlusDash = district.substring(0, dashPosition + 1);
            String paddedDistrictNumber = StringUtils.leftPad((String)district.substring(dashPosition + 1), (int)3, (char)'0');
            organization.setCongressionalDistrict(stateCodePlusDash + paddedDistrictNumber);
        }
    }

    public Organization getBusinessObject() {
        return (Organization)super.getBusinessObject();
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (this.isAutoGenerateCode()) {
            this.disableOrganizationId(sections);
        }
        return sections;
    }

    protected void disableOrganizationId(List<Section> sections) {
        for (Section section : sections) {
            if (!StringUtils.equals((String)section.getSectionId(), (String)SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((String)field.getPropertyName(), (String)ORGANIZATION_ID_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.setGenerateDefaultValues(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    protected boolean isAutoGenerateCode() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", AUTO_GEN_ORGANIZATION_ID_PARM);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

