/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.maintenance;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.PersonTraining;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;

public class PersonTrainingMaintainableImpl
extends KraMaintainableImpl {
    private static final String COLUMN = ":";

    public void setGenerateDefaultValues(String docTypeName) {
        this.initTrainingNumber();
        super.setGenerateDefaultValues(docTypeName);
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Edit") && (document.getDocumentHeader().getWorkflowDocument().isSaved() || document.getDocumentHeader().getWorkflowDocument().isInitiated())) {
            this.initTrainingNumber();
        }
        return super.getCoreSections(document, oldMaintainable);
    }

    public PersonTraining getPersonTraining() {
        return (PersonTraining)this.getBusinessObject();
    }

    private void initTrainingNumber() {
        if (this.getPersonTraining().getPersonTrainingId() == null) {
            Integer trainingNumber = 1;
            if (StringUtils.isNotBlank((String)this.getPersonTraining().getPersonId())) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("personId", this.getPersonTraining().getPersonId());
                List personTrainings = (List)this.getBusinessObjectService().findMatching(PersonTraining.class, fieldValues);
                if (!personTrainings.isEmpty()) {
                    trainingNumber = personTrainings.size() + 1;
                }
            }
            this.getPersonTraining().setTrainingNumber(trainingNumber);
        }
    }

    @Override
    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        String keyName = "personId";
        for (Section section : sections) {
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!"personId".equals(field.getPropertyName())) continue;
                    if (document.isEdit()) {
                        field.setReadOnly(true);
                        continue;
                    }
                    field.setFieldConversions(keyName + COLUMN + field.getPropertyName());
                    field.setLookupParameters(field.getPropertyName() + COLUMN + keyName);
                    field.setInquiryParameters(field.getPropertyName() + COLUMN + keyName);
                    field.setQuickFinderClassNameImpl("org.kuali.kra.bo.KcPerson");
                    field.setFieldDirectInquiryEnabled(true);
                }
            }
        }
        return sections;
    }
}

