/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.maintenance;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 713068582185818373L;
    private static final String SEQUENCE_STATUS_ARCHIVED = "A";

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (this.businessObject != null && this.businessObject instanceof KraPersistableBusinessObjectBase && this.businessObject instanceof Question) {
            Question question = (Question)this.businessObject;
            question.setDocumentNumber(this.getDocumentNumber());
            if (StringUtils.isNotBlank((String)((Question)this.businessObject).getLookupClass())) {
                GlobalVariables.getUserSession().addObject("lookupClassName", (Object)question.getLookupClass());
            }
            if (question.getQuestionId() == null) {
                Long newQuestionId = KraServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber("SEQ_QUESTION_ID");
                question.setQuestionIdFromInteger(newQuestionId.intValue());
            }
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        Question question;
        if (KNSGlobalVariables.getKualiForm() != null && KNSGlobalVariables.getKualiForm() instanceof KualiMaintenanceForm && StringUtils.isNotBlank((String)(question = (Question)((MaintenanceDocumentBase)((KualiMaintenanceForm)KNSGlobalVariables.getKualiForm()).getDocument()).getDocumentBusinessObject()).getLookupClass()) && StringUtils.isBlank((String)((String)GlobalVariables.getUserSession().retrieveObject("lookupClassName"))) && ((List)GlobalVariables.getUserSession().retrieveObject("lookupReturnFields") == null || ((List)GlobalVariables.getUserSession().retrieveObject("lookupReturnFields")).size() == 0)) {
            GlobalVariables.getUserSession().addObject("lookupClassName", (Object)question.getLookupClass());
        }
        return new ArrayList<Section>();
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        this.clearUnusedFieldValues();
    }

    private void clearUnusedFieldValues() {
        Question question = (Question)this.businessObject;
        if (question.getQuestionType() != null) {
            switch (question.getQuestionTypeId()) {
                case 1: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setDisplayedAnswers(null);
                    question.setMaxAnswers(null);
                    question.setAnswerMaxLength(null);
                    break;
                }
                case 2: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setDisplayedAnswers(null);
                    question.setMaxAnswers(null);
                    question.setAnswerMaxLength(null);
                    break;
                }
                case 3: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    break;
                }
                case 4: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    question.setAnswerMaxLength(null);
                    break;
                }
                case 5: {
                    question.setLookupClass(null);
                    question.setLookupReturn(null);
                    break;
                }
                case 6: {
                    question.setDisplayedAnswers(null);
                    question.setAnswerMaxLength(null);
                }
            }
        }
    }

    public void saveBusinessObject() {
        Question newQuestion = (Question)this.businessObject;
        QuestionService questionService = KraServiceLocator.getService(QuestionService.class);
        Question oldQuestion = questionService.getQuestionById(newQuestion.getQuestionId());
        if (oldQuestion != null) {
            oldQuestion.setSequenceStatus(SEQUENCE_STATUS_ARCHIVED);
            this.getBusinessObjectService().save((PersistableBusinessObject)oldQuestion);
        }
        super.saveBusinessObject();
    }
}

