/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.medusa.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.medusa.MedusaNode;
import org.kuali.kra.medusa.service.MedusaService;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class MedusaServiceImpl
implements MedusaService {
    private static final int INST_PROPOSAL_STATUS_FUNDED = 2;
    private BusinessObjectService businessObjectService;
    private AwardAmountInfoService awardAmountInfoService;
    private VersionHistoryService versionHistoryService;
    private NegotiationService negotiationService;
    private SubAwardService subAwardService;
    private ParameterService parameterService;

    @Override
    public MedusaNode getMedusaNode(String moduleName, Long moduleId) {
        MedusaNode curNode = new MedusaNode();
        curNode.setType(moduleName);
        if (StringUtils.equalsIgnoreCase((String)"award", (String)moduleName)) {
            Award award = (Award)this.businessObjectService.findByPrimaryKey(Award.class, this.getFieldValues("awardId", moduleId));
            curNode.setBo((BusinessObject)award);
            curNode.setExtraInfo(this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos()));
        } else if (StringUtils.equalsIgnoreCase((String)"IP", (String)moduleName)) {
            InstitutionalProposal proposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", moduleId));
            proposal.setNsfCodeBo(this.getNsfCode(proposal.getNsfCode()));
            curNode.setBo((BusinessObject)proposal);
        } else if (StringUtils.equalsIgnoreCase((String)"DP", (String)moduleName)) {
            DevelopmentProposal devProp = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, this.getFieldValues("proposalNumber", moduleId));
            devProp.setNsfCodeBo(this.getNsfCode(devProp.getNsfCode()));
            curNode.setBo((BusinessObject)devProp);
        } else if (StringUtils.equalsIgnoreCase((String)"neg", (String)moduleName)) {
            Negotiation negotiation = this.getNegotiation(moduleId);
            curNode.setBo((BusinessObject)negotiation);
        } else if (StringUtils.equalsIgnoreCase((String)"subaward", (String)moduleName)) {
            SubAward subaward = this.getSubAward(moduleId);
            curNode.setBo((BusinessObject)subaward);
        } else if (StringUtils.equalsIgnoreCase((String)"irb", (String)moduleName)) {
            Protocol protocol = this.getProtocol(moduleId);
            curNode.setBo((BusinessObject)protocol);
        } else if (StringUtils.equalsIgnoreCase((String)"iacuc", (String)moduleName)) {
            IacucProtocol protocol = this.getIacuc(moduleId);
            curNode.setBo((BusinessObject)protocol);
        }
        return curNode;
    }

    protected NsfCode getNsfCode(String nsfCode) {
        Collection bos = this.businessObjectService.findMatching(NsfCode.class, this.getFieldValues("nsfCode", nsfCode));
        Iterator i$ = bos.iterator();
        if (i$.hasNext()) {
            NsfCode nsfBo = (NsfCode)((Object)i$.next());
            return nsfBo;
        }
        return null;
    }

    @Override
    public List<MedusaNode> getMedusaByProposal(String moduleName, Long moduleIdentifier) {
        String preferredModule = "IP";
        return this.getMedusaTree(moduleName, moduleIdentifier, preferredModule);
    }

    @Override
    public List<MedusaNode> getMedusaByAward(String moduleName, Long moduleIdentifier) {
        String preferredModule = "award";
        return this.getMedusaTree(moduleName, moduleIdentifier, preferredModule);
    }

    protected List<MedusaNode> getMedusaTree(String moduleName, Long moduleIdentifier, String preferredModule) {
        IacucProtocol protocol;
        List<MedusaNode> nodes = new ArrayList<MedusaNode>();
        HashMap<BusinessObject, List<BusinessObject>> graph = new HashMap<BusinessObject, List<BusinessObject>>();
        if (StringUtils.equals((String)moduleName, (String)"award")) {
            Award award = this.getAward(moduleIdentifier);
            this.addVertex(graph, (BusinessObject)award);
            this.buildGraph(graph, award);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "award"});
        } else if (StringUtils.equals((String)moduleName, (String)"IP")) {
            InstitutionalProposal proposal = this.getInstitutionalProposal(moduleIdentifier);
            this.addVertex(graph, (BusinessObject)proposal);
            this.buildGraph(graph, proposal);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "IP"});
        } else if (StringUtils.equals((String)moduleName, (String)"DP")) {
            DevelopmentProposal proposal = this.getDevelopmentProposal(moduleIdentifier.toString());
            this.addVertex(graph, (BusinessObject)proposal);
            this.buildGraph(graph, proposal);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "DP"});
        } else if (StringUtils.equals((String)moduleName, (String)"neg")) {
            Negotiation negotiation = this.getNegotiation(moduleIdentifier);
            if (negotiation != null) {
                this.addVertex(graph, (BusinessObject)negotiation);
                this.buildGraph(graph, negotiation);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "neg"});
            }
        } else if (StringUtils.equals((String)moduleName, (String)"subaward")) {
            SubAward subAward = this.getSubAward(moduleIdentifier);
            if (subAward != null) {
                this.addVertex(graph, (BusinessObject)subAward);
                this.buildGraph(graph, subAward);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "subaward"});
            }
        } else if (StringUtils.equals((String)moduleName, (String)"irb")) {
            Protocol protocol2 = this.getProtocol(moduleIdentifier);
            if (protocol2 != null) {
                this.addVertex(graph, (BusinessObject)protocol2);
                this.buildGraph(graph, protocol2);
                nodes = this.getParentNodes(graph, new String[]{preferredModule, "irb"});
            }
        } else if (StringUtils.equals((String)moduleName, (String)"iacuc") && (protocol = this.getIacuc(moduleIdentifier)) != null) {
            this.addVertex(graph, (BusinessObject)protocol);
            this.buildGraph(graph, protocol);
            nodes = this.getParentNodes(graph, new String[]{preferredModule, "iacuc"});
        }
        return nodes;
    }

    protected BusinessObject addVertex(HashMap<BusinessObject, List<BusinessObject>> graph, BusinessObject bo) {
        BusinessObject graphBo = this.findMatchingBo(graph.keySet(), bo);
        if (graphBo == null) {
            graph.put(bo, new ArrayList());
            return bo;
        }
        return graphBo;
    }

    protected void addEdge(HashMap<BusinessObject, List<BusinessObject>> graph, BusinessObject bo1, BusinessObject bo2) {
        BusinessObject graphBo1 = this.addVertex(graph, bo1);
        BusinessObject graphBo2 = this.addVertex(graph, bo2);
        if (this.findMatchingBo((Collection<BusinessObject>)graph.get(graphBo1), graphBo2) == null) {
            graph.get(graphBo1).add(graphBo2);
        }
        if (this.findMatchingBo((Collection<BusinessObject>)graph.get(graphBo2), graphBo1) == null) {
            graph.get(graphBo2).add(graphBo1);
        }
    }

    protected List<MedusaNode> getParentNodes(HashMap<BusinessObject, List<BusinessObject>> graph, String[] preferedOrder) {
        ArrayList<MedusaNode> parentNodes = new ArrayList<MedusaNode>();
        for (String prefType : preferedOrder) {
            for (BusinessObject bo : graph.keySet()) {
                MedusaNode node = this.getNode(bo);
                if (!StringUtils.equals((String)node.getType(), (String)prefType)) continue;
                parentNodes.add(node);
            }
            if (!parentNodes.isEmpty()) break;
        }
        for (MedusaNode node : parentNodes) {
            ArrayList<MedusaNode> seenNodes = new ArrayList<MedusaNode>(parentNodes);
            this.populateChildNodes(graph, node, seenNodes);
        }
        return parentNodes;
    }

    protected void populateChildNodes(HashMap<BusinessObject, List<BusinessObject>> graph, MedusaNode node, List<MedusaNode> parentNodes) {
        Collection links = graph.get(node.getBo());
        for (BusinessObject bo : links) {
            MedusaNode nextNode = this.getNode(bo);
            if (parentNodes != null && this.isBoInList(parentNodes, bo)) continue;
            node.getChildNodes().add(nextNode);
            parentNodes.add(node);
            this.populateChildNodes(graph, nextNode, parentNodes);
        }
    }

    protected boolean isBoInList(List<MedusaNode> nodes, BusinessObject bo) {
        for (MedusaNode node : nodes) {
            if (!this.areBusinessObjectsEqual(node.getBo(), bo)) continue;
            return true;
        }
        return false;
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, SubAward subAward) {
        Collection<Award> awards = this.getAwards(subAward);
        for (Award award : awards) {
            this.addToGraph(graph, (BusinessObject)award, (BusinessObject)subAward);
        }
        Collection<Negotiation> negotiations = this.getNegotiations((BusinessObject)subAward);
        for (Negotiation negotiation : negotiations) {
            this.addToGraph(graph, (BusinessObject)negotiation, (BusinessObject)subAward);
        }
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, Protocol protocol) {
        for (ProtocolFundingSourceBase fundingSource : protocol.getProtocolFundingSources()) {
            if (StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"6")) {
                this.addToGraph(graph, (BusinessObject)this.getAward(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
                continue;
            }
            if (StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"5")) {
                this.addToGraph(graph, (BusinessObject)this.getInstitutionalProposal(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
                continue;
            }
            if (!StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"4")) continue;
            this.addToGraph(graph, (BusinessObject)this.getDevelopmentProposal(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
        }
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, IacucProtocol protocol) {
        for (ProtocolFundingSourceBase fundingSource : protocol.getProtocolFundingSources()) {
            if (StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"6")) {
                this.addToGraph(graph, (BusinessObject)this.getAward(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
                continue;
            }
            if (StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"5")) {
                this.addToGraph(graph, (BusinessObject)this.getInstitutionalProposal(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
                continue;
            }
            if (!StringUtils.equals((String)fundingSource.getFundingSourceTypeCode(), (String)"4")) continue;
            this.addToGraph(graph, (BusinessObject)this.getDevelopmentProposal(fundingSource.getFundingSourceNumber()), (BusinessObject)protocol);
        }
    }

    protected void addSpecialReviewLinksToGraph(HashMap<BusinessObject, List<BusinessObject>> graph, List<? extends SpecialReview> specialReviews, BusinessObject existingBo) {
        Map<String, Boolean> specialReviewLinking = this.getSpecialReviewLinkingEnabled(existingBo);
        for (SpecialReview specialReview : specialReviews) {
            ProtocolBase protocol;
            if (StringUtils.equals((String)specialReview.getSpecialReviewTypeCode(), (String)"1") && specialReviewLinking.get("1").booleanValue() && !StringUtils.equals((String)specialReview.getApprovalTypeCode(), (String)"3")) {
                protocol = this.getProtocol(specialReview.getProtocolNumber());
                this.addToGraph(graph, (BusinessObject)protocol, existingBo);
                continue;
            }
            if (!StringUtils.equals((String)specialReview.getSpecialReviewTypeCode(), (String)"2") || !specialReviewLinking.get("2").booleanValue() || StringUtils.equals((String)specialReview.getApprovalTypeCode(), (String)"3")) continue;
            protocol = this.getIacuc(specialReview.getProtocolNumber());
            this.addToGraph(graph, (BusinessObject)protocol, existingBo);
        }
    }

    protected Map<String, Boolean> getSpecialReviewLinkingEnabled(BusinessObject existingBo) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String irbLinkingName = null;
        String iacucLinkingName = null;
        if (existingBo instanceof DevelopmentProposal) {
            irbLinkingName = "irb.protocol.development.proposal.linking.enabled";
            iacucLinkingName = "iacuc.protocol.proposal.development.linking.enabled";
        } else if (existingBo instanceof InstitutionalProposal) {
            irbLinkingName = "irb.protocol.institute.proposal.linking.enabled";
            iacucLinkingName = "iacuc.protocol.institute.proposal.linking.enabled";
        } else if (existingBo instanceof Award) {
            irbLinkingName = "irb.protocol.award.linking.enabled";
            iacucLinkingName = "iacuc.protocol.award.linking.enabled";
        }
        if (irbLinkingName != null) {
            result.put("1", this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", irbLinkingName));
        } else {
            result.put("1", Boolean.FALSE);
        }
        if (iacucLinkingName != null) {
            result.put("2", this.getParameterService().getParameterValueAsBoolean("KC-IACUC", "Document", iacucLinkingName));
        } else {
            result.put("2", Boolean.FALSE);
        }
        return result;
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, Award award) {
        Collection<InstitutionalProposal> proposals = this.getProposals(award);
        for (InstitutionalProposal proposal : proposals) {
            this.addToGraph(graph, (BusinessObject)proposal, (BusinessObject)award);
        }
        Collection<Negotiation> negotiations = this.getNegotiations((BusinessObject)award);
        for (Negotiation negotiation : negotiations) {
            this.addToGraph(graph, (BusinessObject)negotiation, (BusinessObject)award);
        }
        Collection<SubAward> subAwards = this.getSubAwards(award);
        for (SubAward subAward : subAwards) {
            this.addToGraph(graph, (BusinessObject)subAward, (BusinessObject)award);
        }
        this.addSpecialReviewLinksToGraph(graph, award.getSpecialReviews(), (BusinessObject)award);
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, InstitutionalProposal proposal) {
        Collection<Award> awards = this.getAwards(proposal);
        for (Award award : awards) {
            this.addToGraph(graph, (BusinessObject)award, (BusinessObject)proposal);
        }
        Collection<DevelopmentProposal> proposals = this.getDevelopmentProposals(proposal);
        for (DevelopmentProposal devProp : proposals) {
            this.addToGraph(graph, (BusinessObject)devProp, (BusinessObject)proposal);
        }
        Collection<Negotiation> negotiations = this.getNegotiations((BusinessObject)proposal);
        for (Negotiation negotiation : negotiations) {
            this.addToGraph(graph, (BusinessObject)negotiation, (BusinessObject)proposal);
        }
        this.addSpecialReviewLinksToGraph(graph, proposal.getSpecialReviews(), (BusinessObject)proposal);
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, DevelopmentProposal devProp) {
        Collection<InstitutionalProposal> proposals = this.getProposals(devProp);
        for (InstitutionalProposal proposal : proposals) {
            this.addToGraph(graph, (BusinessObject)proposal, (BusinessObject)devProp);
        }
        this.addSpecialReviewLinksToGraph(graph, devProp.getPropSpecialReviews(), (BusinessObject)devProp);
    }

    protected void buildGraph(HashMap<BusinessObject, List<BusinessObject>> graph, Negotiation negotiation) {
        BusinessObject bo = (BusinessObject)this.getNegotiationService().getAssociatedObject(negotiation);
        if (bo instanceof Award || bo instanceof InstitutionalProposal || bo instanceof SubAward) {
            this.addToGraph(graph, bo, (BusinessObject)negotiation);
        }
    }

    protected void addToGraph(HashMap<BusinessObject, List<BusinessObject>> graph, BusinessObject newBo, BusinessObject existingBo) {
        if (newBo == null || existingBo == null) {
            throw new RuntimeException("Inavlid or null Medusa link found");
        }
        if (this.findMatchingBo(graph.keySet(), newBo) == null) {
            this.addEdge(graph, existingBo, newBo);
            if (newBo instanceof Award) {
                this.buildGraph(graph, (Award)newBo);
            } else if (newBo instanceof InstitutionalProposal) {
                this.buildGraph(graph, (InstitutionalProposal)newBo);
            } else if (newBo instanceof DevelopmentProposal) {
                this.buildGraph(graph, (DevelopmentProposal)newBo);
            } else if (newBo instanceof Negotiation) {
                this.buildGraph(graph, (Negotiation)newBo);
            } else if (newBo instanceof SubAward) {
                this.buildGraph(graph, (SubAward)newBo);
            } else if (newBo instanceof Protocol) {
                this.buildGraph(graph, (Protocol)newBo);
            } else if (newBo instanceof IacucProtocol) {
                this.buildGraph(graph, (IacucProtocol)newBo);
            }
        } else {
            this.addEdge(graph, existingBo, newBo);
        }
    }

    protected BusinessObject findMatchingBo(Collection<BusinessObject> boSet, BusinessObject bo) {
        for (BusinessObject curBo : boSet) {
            if (!this.areBusinessObjectsEqual(bo, curBo)) continue;
            return curBo;
        }
        return null;
    }

    protected boolean areBusinessObjectsEqual(BusinessObject bo1, BusinessObject bo2) {
        return bo1 instanceof DevelopmentProposal && bo2 instanceof DevelopmentProposal ? ObjectUtils.equals((Object)((DevelopmentProposal)bo1).getProposalNumber(), (Object)((DevelopmentProposal)bo2).getProposalNumber()) : (bo1 instanceof InstitutionalProposal && bo2 instanceof InstitutionalProposal ? ObjectUtils.equals((Object)((InstitutionalProposal)bo1).getProposalId(), (Object)((InstitutionalProposal)bo2).getProposalId()) : (bo1 instanceof Award && bo2 instanceof Award ? ObjectUtils.equals((Object)((Award)bo1).getAwardId(), (Object)((Award)bo2).getAwardId()) : (bo1 instanceof Negotiation && bo2 instanceof Negotiation ? ObjectUtils.equals((Object)((Negotiation)bo1).getNegotiationId(), (Object)((Negotiation)bo2).getNegotiationId()) : (bo1 instanceof SubAward && bo2 instanceof SubAward ? ObjectUtils.equals((Object)((SubAward)bo1).getSubAwardId(), (Object)((SubAward)bo2).getSubAwardId()) : (bo1 instanceof Protocol && bo2 instanceof Protocol ? ObjectUtils.equals((Object)((Protocol)bo1).getProtocolId(), (Object)((Protocol)bo2).getProtocolId()) : bo1 instanceof IacucProtocol && bo2 instanceof IacucProtocol && ObjectUtils.equals((Object)((IacucProtocol)bo1).getProtocolId(), (Object)((IacucProtocol)bo2).getProtocolId()))))));
    }

    protected DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, this.getFieldValues("proposalNumber", proposalNumber));
    }

    protected InstitutionalProposal getInstitutionalProposal(Long proposalId) {
        InstitutionalProposal proposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", proposalId));
        if (proposal == null) {
            return null;
        }
        InstitutionalProposal currentProposal = this.getInstitutionalProposal(proposal.getProposalNumber());
        return currentProposal == null ? proposal : currentProposal;
    }

    protected InstitutionalProposal getInstitutionalProposal(String proposalNumber) {
        VersionStatus status;
        InstitutionalProposal currentProposal = null;
        VersionStatus[] arr$ = new VersionStatus[]{VersionStatus.ACTIVE, VersionStatus.PENDING, VersionStatus.ARCHIVED};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (currentProposal = this.getNewestProposalByStatus(proposalNumber, status = arr$[i$])) == null; ++i$) {
        }
        return currentProposal;
    }

    protected Award getAward(Long awardId) {
        Award award = (Award)this.businessObjectService.findByPrimaryKey(Award.class, this.getFieldValues("awardId", awardId));
        if (award == null) {
            return null;
        }
        Award currentAward = (Award)this.getActiveOrCurrentVersion(Award.class, award.getAwardNumber());
        return currentAward == null ? award : currentAward;
    }

    protected Award getAward(String awardNumber) {
        Award currentAward = (Award)this.getActiveOrCurrentVersion(Award.class, awardNumber);
        return currentAward;
    }

    protected Negotiation getNegotiation(Long negotiationId) {
        Negotiation negotiation = negotiationId == null ? null : (Negotiation)this.businessObjectService.findBySinglePrimaryKey(Negotiation.class, (Object)negotiationId);
        return negotiation;
    }

    protected SubAward getSubAward(Long subAwardId) {
        SubAward subAward = (SubAward)this.businessObjectService.findBySinglePrimaryKey(SubAward.class, (Object)subAwardId);
        if (subAward == null) {
            return null;
        }
        SubAward currentSubAward = (SubAward)this.getActiveOrCurrentVersion(SubAward.class, subAward.getSubAwardCode());
        if (currentSubAward != null) {
            KraServiceLocator.getService(SubAwardService.class).getAmountInfo(currentSubAward);
        }
        return currentSubAward == null ? subAward : currentSubAward;
    }

    protected Protocol getProtocol(Long protocolId) {
        Protocol protocol = (Protocol)this.businessObjectService.findBySinglePrimaryKey(Protocol.class, (Object)protocolId);
        return protocol;
    }

    protected Protocol getProtocol(String protocolNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("protocolNumber", protocolNumber);
        List versions = (List)this.businessObjectService.findMatching(Protocol.class, values);
        Protocol newest = null;
        for (Protocol version : versions) {
            if (newest != null && version.getSequenceNumber() <= newest.getSequenceNumber()) continue;
            newest = version;
        }
        return newest;
    }

    protected IacucProtocol getIacuc(Long protocolId) {
        IacucProtocol protocol = (IacucProtocol)this.businessObjectService.findBySinglePrimaryKey(IacucProtocol.class, (Object)protocolId);
        return protocol;
    }

    protected IacucProtocol getIacuc(String protocolNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("protocolNumber", protocolNumber);
        List versions = (List)this.businessObjectService.findMatching(IacucProtocol.class, values);
        IacucProtocol newest = null;
        for (IacucProtocol version : versions) {
            if (newest != null && version.getSequenceNumber() <= newest.getSequenceNumber()) continue;
            newest = version;
        }
        return newest;
    }

    protected SequenceOwner getActiveOrCurrentVersion(Class clazz, String sequenceName) {
        VersionHistory activeVersion = this.versionHistoryService.findActiveVersion(clazz, sequenceName);
        SequenceOwner<? extends SequenceOwner<?>> bestVersion = null;
        if (activeVersion != null) {
            bestVersion = activeVersion.getSequenceOwner();
        } else {
            List<VersionHistory> history = this.versionHistoryService.loadVersionHistory(clazz, sequenceName);
            if (history != null && !history.isEmpty()) {
                VersionHistory best = history.get(0);
                for (VersionHistory curVersion : history) {
                    if (curVersion.getVersionNumber() <= best.getVersionNumber() || curVersion.getStatus() == VersionStatus.CANCELED) continue;
                    best = curVersion;
                }
                bestVersion = best.getSequenceOwner();
            }
        }
        return bestVersion;
    }

    protected MedusaNode getNode(BusinessObject bo) {
        if (bo instanceof Award) {
            return this.getNode((Award)bo);
        }
        if (bo instanceof InstitutionalProposal) {
            return this.getNode((InstitutionalProposal)bo);
        }
        if (bo instanceof DevelopmentProposal) {
            return this.getNode((DevelopmentProposal)bo);
        }
        if (bo instanceof Negotiation) {
            return this.getNode((Negotiation)bo);
        }
        if (bo instanceof SubAward) {
            return this.getNode((SubAward)bo);
        }
        if (bo instanceof Protocol) {
            return this.getNode((Protocol)bo);
        }
        if (bo instanceof IacucProtocol) {
            return this.getNode((IacucProtocol)bo);
        }
        return null;
    }

    protected MedusaNode getNode(Award award) {
        AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)award);
        node.setType("award");
        node.setExtraInfo(awardAmountInfo);
        return node;
    }

    protected MedusaNode getNode(InstitutionalProposal proposal) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)proposal);
        node.setType("IP");
        return node;
    }

    protected MedusaNode getNode(DevelopmentProposal proposal) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)proposal);
        node.setType("DP");
        return node;
    }

    protected MedusaNode getNode(Negotiation negotiation) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)negotiation);
        node.setType("neg");
        return node;
    }

    protected MedusaNode getNode(SubAward subAward) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)subAward);
        node.setType("subaward");
        return node;
    }

    protected MedusaNode getNode(Protocol protocol) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)protocol);
        node.setType("irb");
        return node;
    }

    protected MedusaNode getNode(IacucProtocol protocol) {
        MedusaNode node = new MedusaNode();
        node.setBo((BusinessObject)protocol);
        node.setType("iacuc");
        return node;
    }

    protected Collection<DevelopmentProposal> getDevelopmentProposals(InstitutionalProposal instProposal) {
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        Collection proposalVersions = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", instProposal.getProposalNumber()));
        for (InstitutionalProposal ip : proposalVersions) {
            Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, this.getFieldValues("instProposalId", ip.getProposalId()));
            for (ProposalAdminDetails proposalAdminDetail : proposalAdminDetails) {
                proposalAdminDetail.refreshReferenceObject("developmentProposal");
                devProposals.add(proposalAdminDetail.getDevelopmentProposal());
            }
        }
        return devProposals;
    }

    protected Collection<Award> getAwards(SubAward subAward) {
        ArrayList<Award> awards = new ArrayList<Award>();
        SubAward newestSubAaward = this.getSubAward(subAward.getSubAwardCode());
        List<SubAwardFundingSource> subAwardFundingSources = newestSubAaward.getSubAwardFundingSourceList();
        for (SubAwardFundingSource subAwardFundingSource : subAwardFundingSources) {
            awards.add(this.getAward(subAwardFundingSource.getAwardId()));
        }
        return awards;
    }

    protected SubAward getSubAward(String subAwardCode) {
        SubAward subAward = (SubAward)this.getActiveOrCurrentVersion(SubAward.class, subAwardCode);
        return subAward;
    }

    protected Collection<SubAward> getSubAwards(Award award) {
        List<SubAward> subAwards = this.getSubAwardService().getLinkedSubAwards(award);
        return subAwards;
    }

    protected Collection<Award> getAwards(InstitutionalProposal ip) {
        ArrayList<Award> awards = new ArrayList<Award>();
        Collection institutionalProposalVersions = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", ip.getProposalNumber()));
        for (InstitutionalProposal curIp : institutionalProposalVersions) {
            List<AwardFundingProposal> awardFundingProposals = curIp.getAwardFundingProposals();
            for (AwardFundingProposal awardFunding : awardFundingProposals) {
                if (!awardFunding.isActive() || curIp.isCancelled()) continue;
                awards.add(this.getAward(awardFunding.getAwardId()));
            }
        }
        InstitutionalProposal activeProposal = this.getNewestProposalByStatus(ip.getProposalNumber(), VersionStatus.ACTIVE);
        if (activeProposal != null && StringUtils.isNotBlank((String)activeProposal.getCurrentAwardNumber()) && activeProposal.getStatusCode() != 2) {
            Collection proposalCurrentAwards = this.businessObjectService.findMatching(Award.class, this.getFieldValues("awardNumber", activeProposal.getCurrentAwardNumber()));
            for (Award curAward : proposalCurrentAwards) {
                awards.add(this.getAward(curAward.getAwardId()));
            }
        }
        return awards;
    }

    protected InstitutionalProposal getNewestProposalByStatus(String proposalNumber, VersionStatus status) {
        Collection versions = this.getBusinessObjectService().findMatching(InstitutionalProposal.class, this.getFieldValues("proposalNumber", proposalNumber));
        InstitutionalProposal newestProposal = null;
        for (InstitutionalProposal curProposal : versions) {
            if (newestProposal == null && curProposal.isActiveVersion()) {
                newestProposal = curProposal;
                continue;
            }
            if (!curProposal.isActiveVersion() || curProposal.getSequenceNumber() <= newestProposal.getSequenceNumber()) continue;
            newestProposal = curProposal;
        }
        return newestProposal;
    }

    protected Collection<InstitutionalProposal> getProposals(Award award) {
        ArrayList<InstitutionalProposal> ips = new ArrayList<InstitutionalProposal>();
        Collection awardVersions = this.businessObjectService.findMatching(Award.class, this.getFieldValues("awardNumber", award.getAwardNumber()));
        for (Award curAward : awardVersions) {
            List<AwardFundingProposal> awardFundingProposals = curAward.getFundingProposals();
            for (AwardFundingProposal awardFunding : awardFundingProposals) {
                InstitutionalProposal curProposal = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, this.getFieldValues("proposalId", awardFunding.getProposalId()));
                boolean proposalNotCancelled = !curProposal.isCancelled();
                if (!proposalNotCancelled || !awardFunding.isActive()) continue;
                ips.add(this.getInstitutionalProposal(awardFunding.getProposalId()));
            }
        }
        Collection curAwardIps = this.businessObjectService.findMatching(InstitutionalProposal.class, this.getFieldValues("currentAwardNumber", award.getAwardNumber()));
        for (InstitutionalProposal proposal : curAwardIps) {
            if (proposal.getStatusCode() == 2 || !proposal.isActiveVersion()) continue;
            ips.add(this.getInstitutionalProposal(proposal.getProposalId()));
        }
        return ips;
    }

    protected Collection<InstitutionalProposal> getProposals(DevelopmentProposal devProposal) {
        Collection proposalAdminDetails = this.businessObjectService.findMatching(ProposalAdminDetails.class, this.getFieldValues("devProposalNumber", devProposal.getProposalNumber()));
        ArrayList<InstitutionalProposal> instProposals = new ArrayList<InstitutionalProposal>();
        for (ProposalAdminDetails proposalAdminDetail : proposalAdminDetails) {
            instProposals.add(this.getInstitutionalProposal(proposalAdminDetail.getInstProposalId()));
        }
        return instProposals;
    }

    protected Collection<Negotiation> getNegotiations(BusinessObject bo) {
        return this.getNegotiationService().getAssociatedNegotiations(bo);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected Map<String, Object> getFieldValues(String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return fieldValues;
    }

    protected AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected NegotiationService getNegotiationService() {
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    protected SubAwardService getSubAwardService() {
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

