/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteePrintingService;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.CommonMeetingService;
import org.kuali.kra.common.committee.meeting.MeetingActionsActionBase;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.correspondence.AbstractProtocolActionsCorrespondence;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.grantexemption.GrantExemptionCorrespondence;
import org.kuali.kra.irb.actions.withdraw.WithdrawCorrespondence;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.meeting.MeetingService;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.util.GlobalVariables;

public class MeetingActionsAction
extends MeetingActionsActionBase {
    private static final String AGENDA_TYPE = "9";
    private static final String MEETING_MINUTE_TYPE = "10";
    private static final List GENERIC_TYPE_CORRESPONDENCE;
    private static final Map<String, String> CORR_TYPE_TO_ACTION_TYPE_MAP;

    @Override
    protected CommitteePrintingService getCommitteePrintingService() {
        return KraServiceLocator.getService(CommitteePrintingService.class);
    }

    @Override
    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MeetingHelper meetingHelper = (MeetingHelper)((MeetingForm)form).getMeetingHelper();
        meetingHelper.setRegeneratedCorrespondences(new ArrayList<ProtocolCorrespondence>());
        for (ProtocolCorrespondence protocolCorrespondence : meetingHelper.getCorrespondences()) {
            if (!protocolCorrespondence.isRegenerateFlag()) continue;
            Protocol protocol = (Protocol)protocolCorrespondence.getProtocol();
            AttachmentDataSource dataSource = this.generateCorrespondenceDocumentAndAttach(protocol, protocolCorrespondence.getProtoCorrespTypeCode());
            MeetingActionsActionBase.PrintableAttachment source = new MeetingActionsActionBase.PrintableAttachment();
            if (dataSource != null) {
                protocolCorrespondence.setCorrespondence(dataSource.getContent());
                protocolCorrespondence.setFinalFlag(false);
                protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
                protocolCorrespondence.setCreateTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            meetingHelper.getRegeneratedCorrespondences().add(protocolCorrespondence);
        }
        this.getBusinessObjectService().save(meetingHelper.getRegeneratedCorrespondences());
        return mapping.findForward("correspondence");
    }

    protected AttachmentDataSource generateCorrespondenceDocumentAndAttach(Protocol protocol, String correspondenceType) throws PrintingException {
        AbstractProtocolActionsCorrespondence correspondence = null;
        if (StringUtils.equals((String)"16", (String)correspondenceType)) {
            correspondence = new WithdrawCorrespondence();
        } else if (GENERIC_TYPE_CORRESPONDENCE.contains(correspondenceType)) {
            correspondence = new ProtocolGenericCorrespondence(CORR_TYPE_TO_ACTION_TYPE_MAP.get(correspondenceType));
        } else if (StringUtils.equals((String)"17", (String)correspondenceType)) {
            correspondence = new GrantExemptionCorrespondence();
        }
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    protected ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KraServiceLocator.getService(ProtocolActionCorrespondenceGenerationService.class);
    }

    @Override
    protected ScheduleAgendaBase getNewScheduleAgendaInstanceHook() {
        return new ScheduleAgenda();
    }

    @Override
    protected String getProtocolCorrespondenceAgendaTypeCodeHook() {
        return AGENDA_TYPE;
    }

    @Override
    protected CommScheduleMinuteDocBase getNewCommScheduleMinuteDocInstanceHook() {
        return new CommScheduleMinuteDoc();
    }

    @Override
    protected String getProtocolCorrespondenceMinutesTypeCodeHook() {
        return MEETING_MINUTE_TYPE;
    }

    @Override
    protected Class<? extends CommitteeScheduleBase> getCommitteeScheduleBOClass() {
        return CommitteeSchedule.class;
    }

    @Override
    protected String getActionIdHook() {
        return "protocolProtocolActions";
    }

    @Override
    protected CommonMeetingService getMeetingService() {
        return KraServiceLocator.getService(MeetingService.class);
    }

    @Override
    protected ReviewCommentsService<?> getReviewerCommentsService() {
        return KraServiceLocator.getService(org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService.class);
    }

    static {
        ArrayList<String> correspondenceTypes = new ArrayList<String>();
        correspondenceTypes.add("28");
        correspondenceTypes.add("1");
        correspondenceTypes.add("26");
        correspondenceTypes.add("5");
        correspondenceTypes.add("3");
        correspondenceTypes.add("6");
        correspondenceTypes.add("4");
        correspondenceTypes.add("7");
        correspondenceTypes.add("8");
        GENERIC_TYPE_CORRESPONDENCE = correspondenceTypes;
        CORR_TYPE_TO_ACTION_TYPE_MAP = new HashMap<String, String>();
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("28", "119");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("1", "204");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("26", "300");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("5", "205");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("3", "201");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("6", "203");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("4", "202");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("7", "302");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("8", "301");
    }
}

