/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationAgreementType;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.customdata.NegotiationCustomData;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class Negotiation
extends KraPersistableBusinessObjectBase
implements Permissionable {
    private static final long MILLISECS_PER_DAY = 86400000L;
    private static final long serialVersionUID = 2529772854773433195L;
    private Long negotiationId;
    private String documentNumber;
    private Long negotiationStatusId;
    private Long negotiationAgreementTypeId;
    private Long negotiationAssociationTypeId;
    private String negotiatorPersonId;
    private String negotiatorName;
    private Date negotiationStartDate;
    private Date negotiationEndDate;
    private Date anticipatedAwardDate;
    private String documentFolder;
    private String allAttachments;
    private String negotiatorUserName;
    private NegotiationUnassociatedDetail unAssociatedDetail;
    private List<NegotiationCustomData> negotiationCustomDataList;
    private Negotiable associatedDocument;
    private NegotiationDocument negotiationDocument;
    private String associatedDocumentId;
    private NegotiationStatus negotiationStatus;
    private NegotiationAgreementType negotiationAgreementType;
    private NegotiationAssociationType negotiationAssociationType;
    private List<NegotiationActivity> activities = new ArrayList<NegotiationActivity>();
    private int printindex;
    private boolean printAll = true;
    private Long oldNegotiationAssociationTypeId;
    private List<NegotiationNotification> negotiationNotifications;

    public int getPrintindex() {
        return this.printindex;
    }

    public void setPrintindex(int printindex) {
        this.printindex = printindex;
    }

    public Negotiation() {
        this.negotiationCustomDataList = new ArrayList<NegotiationCustomData>();
        this.negotiationNotifications = new ArrayList<NegotiationNotification>();
    }

    public Integer getNegotiationAge() {
        if (this.getNegotiationStartDate() == null) {
            return null;
        }
        long start = this.getNegotiationStartDate().getTime();
        long end = 0L;
        end = this.getNegotiationEndDate() == null ? Calendar.getInstance().getTimeInMillis() : this.getNegotiationEndDate().getTime();
        return new Long((end - start) / 86400000L).intValue();
    }

    public String getAllAttachments() {
        return this.allAttachments;
    }

    public void setAllAttachments(String allAttachments) {
        this.allAttachments = allAttachments;
    }

    public Long getNegotiationId() {
        return this.negotiationId;
    }

    public void setNegotiationId(Long negotiationId) {
        this.negotiationId = negotiationId;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getNegotiationStatusId() {
        return this.negotiationStatusId;
    }

    public void setNegotiationStatusId(Long negotiationStatusId) {
        this.negotiationStatusId = negotiationStatusId;
    }

    public Long getNegotiationAgreementTypeId() {
        return this.negotiationAgreementTypeId;
    }

    public void setNegotiationAgreementTypeId(Long negotiationAgreementTypeId) {
        this.negotiationAgreementTypeId = negotiationAgreementTypeId;
    }

    public Long getNegotiationAssociationTypeId() {
        return this.negotiationAssociationTypeId;
    }

    public void setNegotiationAssociationTypeId(Long negotiationAssociationTypeId) {
        this.negotiationAssociationTypeId = negotiationAssociationTypeId;
    }

    public String getNegotiatorPersonId() {
        return this.negotiatorPersonId;
    }

    public void setNegotiatorPersonId(String negotiatorPersonId) {
        this.negotiatorPersonId = negotiatorPersonId;
        if (this.getNegotiator() != null) {
            this.setNegotiatorName(this.getNegotiator().getFullName());
        }
    }

    public KcPerson getNegotiator() {
        if (this.getNegotiatorPersonId() == null) {
            return null;
        }
        try {
            return this.getKcPersonService().getKcPersonByPersonId(this.getNegotiatorPersonId());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getNegotiatorUserName() {
        KcPerson negotiator = this.getNegotiator();
        if (negotiator == null) {
            return this.negotiatorUserName;
        }
        return negotiator.getUserName();
    }

    public void setNegotiatorUserName(String negotiatorUserName) {
        this.negotiatorUserName = negotiatorUserName;
        KcPerson negotiator = null;
        try {
            negotiator = this.getKcPersonService().getKcPersonByUserName(negotiatorUserName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (negotiator != null) {
            this.setNegotiatorPersonId(negotiator.getPersonId());
        } else {
            this.setNegotiatorPersonId(null);
        }
    }

    public Date getNegotiationStartDate() {
        if (this.negotiationStartDate == null || this.negotiationStartDate.equals("")) {
            Calendar now = Calendar.getInstance();
            this.setNegotiationStartDate(new Date(now.get(1) - 1900, now.get(2), now.get(5)));
        }
        return this.negotiationStartDate;
    }

    public void setNegotiationStartDate(Date negotiationStartDate) {
        this.negotiationStartDate = negotiationStartDate;
    }

    public Date getNegotiationEndDate() {
        return this.negotiationEndDate;
    }

    public void setNegotiationEndDate(Date negotiationEndDate) {
        this.negotiationEndDate = negotiationEndDate;
    }

    public Date getAnticipatedAwardDate() {
        return this.anticipatedAwardDate;
    }

    public void setAnticipatedAwardDate(Date anticipatedAwardDate) {
        this.anticipatedAwardDate = anticipatedAwardDate;
    }

    public String getDocumentFolder() {
        return this.documentFolder;
    }

    public void setDocumentFolder(String documentFolder) {
        this.documentFolder = documentFolder;
    }

    public String getAssociatedDocumentId() {
        return this.associatedDocumentId;
    }

    public void setAssociatedDocumentId(String associatedDocumentId) {
        this.associatedDocumentId = associatedDocumentId;
    }

    public NegotiationStatus getNegotiationStatus() {
        return this.negotiationStatus;
    }

    public void setNegotiationStatus(NegotiationStatus negotiationStatus) {
        this.negotiationStatus = negotiationStatus;
    }

    public NegotiationAgreementType getNegotiationAgreementType() {
        return this.negotiationAgreementType;
    }

    public void setNegotiationAgreementType(NegotiationAgreementType negotiationAgreementType) {
        this.negotiationAgreementType = negotiationAgreementType;
    }

    public NegotiationAssociationType getNegotiationAssociationType() {
        return this.negotiationAssociationType;
    }

    public void setNegotiationAssociationType(NegotiationAssociationType negotiationAssociationType) {
        this.negotiationAssociationType = negotiationAssociationType;
    }

    public NegotiationUnassociatedDetail getUnAssociatedDetail() {
        if (this.unAssociatedDetail == null) {
            this.unAssociatedDetail = this.getNegotiationService().findAndLoadNegotiationUnassociatedDetail(this);
        }
        return this.unAssociatedDetail;
    }

    public void setUnAssociatedDetail(NegotiationUnassociatedDetail unAssociatedDetail) {
        this.unAssociatedDetail = unAssociatedDetail;
    }

    public List<NegotiationActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<NegotiationActivity> activities) {
        this.activities = activities;
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.negotiationId != null ? this.negotiationId.toString() : null;
    }

    @Override
    public String getDocumentKey() {
        return "negotiation";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("Negotiation COI");
        roleNames.add("Negotiation KP");
        roleNames.add("Negotiation Administrator");
        roleNames.add("Negotiator");
        roleNames.add("Negotiation PI");
        return roleNames;
    }

    @Override
    public String getNamespace() {
        return "KC-NEGOTIATION";
    }

    @Override
    public String getLeadUnitNumber() {
        Negotiable bo = this.getAssociatedDocument();
        if (bo != null) {
            ((BusinessObject)bo).refresh();
            return bo.getLeadUnitNumber();
        }
        return "";
    }

    public Negotiable getAssociatedNegotiable() {
        return this.getNegotiationService().getAssociatedObject(this);
    }

    private NegotiationService getNegotiationService() {
        return KraServiceLocator.getService(NegotiationService.class);
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-NEGOTIATION";
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        qualifiedRoleAttributes.put("documentTypeName", this.getDocumentKey());
    }

    public List<NegotiationCustomData> getNegotiationCustomDataList() {
        return this.negotiationCustomDataList;
    }

    public void setNegotiationCustomDataList(List<NegotiationCustomData> negotiationCustomDataList) {
        this.negotiationCustomDataList = negotiationCustomDataList;
    }

    public NegotiationDocument getDocument() {
        return this.negotiationDocument;
    }

    public NegotiationDocument getNegotiationDocument() {
        return this.negotiationDocument;
    }

    public void setNegotiationDocument(NegotiationDocument negotiationDocument) {
        this.negotiationDocument = negotiationDocument;
    }

    public Negotiable getAssociatedDocument() {
        if (this.associatedDocument == null || !StringUtils.equals((String)this.associatedDocument.getAssociatedDocumentId(), (String)this.getAssociatedDocumentId())) {
            this.associatedDocument = this.getNegotiationService().getAssociatedObject(this);
        }
        return this.associatedDocument;
    }

    public void setAssociatedDocument(Negotiable associatedDocument) {
        this.associatedDocument = associatedDocument;
    }

    public String getNegotiatorName() {
        return this.negotiatorName;
    }

    public void setNegotiatorName(String negotiatorName) {
        this.negotiatorName = negotiatorName;
    }

    public boolean isPrintAll() {
        return this.printAll;
    }

    public void setPrintAll(boolean printAll) {
        this.printAll = printAll;
    }

    public Long getOldNegotiationAssociationTypeId() {
        return this.oldNegotiationAssociationTypeId;
    }

    public void setOldNegotiationAssociationTypeId(Long oldNegotiationAssociationTypeId) {
        this.oldNegotiationAssociationTypeId = oldNegotiationAssociationTypeId;
    }

    public List<NegotiationNotification> getNegotiationNotifications() {
        return this.negotiationNotifications;
    }

    public void setNegotiationNotifications(List<NegotiationNotification> negotiationNotifications) {
        this.negotiationNotifications = negotiationNotifications;
    }

    public void addNotification(NegotiationNotification negotiationNotification) {
        this.getNegotiationNotifications().add(negotiationNotification);
    }
}

