/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.bo.NegotiationActivityType;
import org.kuali.kra.negotiations.bo.NegotiationLocation;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivity
extends KraPersistableBusinessObjectBase {
    private static final long serialVersionUID = 1927288853033781994L;
    public static final long MILLISECS_PER_DAY = 86400000L;
    private Long activityId;
    private Long negotiationId;
    private Negotiation negotiation;
    private Long locationId;
    private NegotiationLocation location;
    private Long activityTypeId;
    private NegotiationActivityType activityType;
    private java.sql.Date startDate;
    private java.sql.Date endDate;
    private java.sql.Date createDate;
    private java.sql.Date followupDate;
    private String lastModifiedUsername;
    private java.sql.Date lastModifiedDate;
    private String description;
    private Boolean restricted = Boolean.TRUE;
    private List<NegotiationActivityAttachment> attachments = new ArrayList<NegotiationActivityAttachment>();
    private transient NegotiationActivityAttachment newAttachment = new NegotiationActivityAttachment();
    private transient boolean updated;

    public String getNumberOfDays() {
        return NegotiationActivity.getNumberOfDays(this.getStartDate(), this.getEndDate());
    }

    public static String getNumberOfDays(java.sql.Date startDate, java.sql.Date endDate) {
        if (startDate == null) {
            return "";
        }
        long start = startDate.getTime();
        long end = 0L;
        end = endDate == null ? Calendar.getInstance().getTimeInMillis() : endDate.getTime();
        return (end - start) / 86400000L + 1L + "";
    }

    public void updateActivity() {
        if (this.updated) {
            this.refreshReferenceObject("location");
            this.refreshReferenceObject("activityType");
            this.setLastModifiedDate(new java.sql.Date(new Date().getTime()));
            this.setLastModifiedUsername(GlobalVariables.getUserSession().getPrincipalName());
            this.updated = false;
        }
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getNegotiationId() {
        return this.negotiationId;
    }

    public void setNegotiationId(Long negotiationId) {
        this.negotiationId = negotiationId;
    }

    public Negotiation getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(Negotiation negotiation) {
        this.negotiation = negotiation;
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        if (!ObjectUtils.equals((Object)this.locationId, (Object)locationId)) {
            this.updated = true;
        }
        this.locationId = locationId;
    }

    public NegotiationLocation getLocation() {
        return this.location;
    }

    public void setLocation(NegotiationLocation location) {
        if (!ObjectUtils.equals((Object)this.location, (Object)location)) {
            this.updated = true;
        }
        this.location = location;
    }

    public Long getActivityTypeId() {
        return this.activityTypeId;
    }

    public void setActivityTypeId(Long activityTypeId) {
        if (!ObjectUtils.equals((Object)this.activityTypeId, (Object)activityTypeId)) {
            this.updated = true;
        }
        this.activityTypeId = activityTypeId;
    }

    public NegotiationActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(NegotiationActivityType activityType) {
        this.activityType = activityType;
    }

    public java.sql.Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(java.sql.Date startDate) {
        if (!ObjectUtils.equals((Object)this.startDate, (Object)startDate)) {
            this.updated = true;
        }
        this.startDate = startDate;
    }

    public java.sql.Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(java.sql.Date endDate) {
        if (!ObjectUtils.equals((Object)this.endDate, (Object)endDate)) {
            this.updated = true;
        }
        this.endDate = endDate;
    }

    public java.sql.Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(java.sql.Date createDate) {
        this.createDate = createDate;
    }

    public java.sql.Date getFollowupDate() {
        return this.followupDate;
    }

    public void setFollowupDate(java.sql.Date followupDate) {
        if (!ObjectUtils.equals((Object)this.followupDate, (Object)followupDate)) {
            this.updated = true;
        }
        this.followupDate = followupDate;
    }

    public String getLastModifiedUsername() {
        return this.lastModifiedUsername;
    }

    public void setLastModifiedUsername(String lastModifiedUsername) {
        this.lastModifiedUsername = lastModifiedUsername;
    }

    public KcPerson getLastModifiedUser() {
        if (this.getLastModifiedUsername() == null) {
            return null;
        }
        return this.getKcPersonService().getKcPersonByUserName(this.getLastModifiedUsername());
    }

    public String getLastModifiedUserFullName() {
        KcPerson user = this.getLastModifiedUser();
        return user == null ? "" : user.getFullName();
    }

    public java.sql.Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(java.sql.Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!ObjectUtils.equals((Object)this.description, (Object)description)) {
            this.updated = true;
        }
        this.description = description;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        if (!ObjectUtils.equals((Object)this.restricted, (Object)restricted)) {
            this.updated = true;
        }
        this.restricted = restricted;
    }

    public List<NegotiationActivityAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<NegotiationActivityAttachment> attachments) {
        this.attachments = attachments;
    }

    public void add(NegotiationActivityAttachment attachment) {
        this.updated = true;
        this.attachments.add(attachment);
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public NegotiationActivityAttachment getNewAttachment() {
        return this.newAttachment;
    }

    public void setNewAttachment(NegotiationActivityAttachment newAttachment) {
        this.newAttachment = newAttachment;
    }
}

