/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.service.RolodexService;

public class NegotiationUnassociatedDetail
extends KraPersistableBusinessObjectBase
implements Negotiable {
    private static final long serialVersionUID = 989159429578390915L;
    private Long negotiationUnassociatedDetailId;
    private Long negotiationId;
    private String title;
    private String piPersonId;
    private String piRolodexId;
    private String piName;
    private String leadUnitNumber;
    private String sponsorCode;
    private String primeSponsorCode;
    private String sponsorAwardNumber;
    private String contactAdminPersonId;
    private String subAwardOrganizationId;
    private transient String negotiableProposalTypeCode;
    private Negotiation negotiation;
    private Unit leadUnit;
    private Sponsor sponsor;
    private Sponsor primeSponsor;
    private Organization subAwardOrganization;
    private String piEmployeeUserName;
    private String contactAdminUserName;

    @Override
    protected void prePersist() {
        super.prePersist();
        this.setPiName();
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        this.setPiName();
    }

    protected void setPiName() {
        if (this.getPIEmployee() != null) {
            this.setPiName(this.getPIEmployee().getFullName());
        } else if (this.getPINonEmployee() != null) {
            this.setPiName(this.getPINonEmployee().getFullName());
        }
    }

    public Long getNegotiationUnassociatedDetailId() {
        return this.negotiationUnassociatedDetailId;
    }

    public void setNegotiationUnassociatedDetailId(Long negotiationUnassociatedDetailId) {
        this.negotiationUnassociatedDetailId = negotiationUnassociatedDetailId;
    }

    public Long getNegotiationId() {
        return this.negotiationId;
    }

    public void setNegotiationId(Long negotiationId) {
        this.negotiationId = negotiationId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPiPersonId() {
        return this.piPersonId;
    }

    public void setPiPersonId(String piPersonId) {
        this.piPersonId = piPersonId;
    }

    public String getPiRolodexId() {
        return this.piRolodexId;
    }

    public void setPiRolodexId(String piRolodexId) {
        this.piRolodexId = piRolodexId;
    }

    @Override
    public String getLeadUnitNumber() {
        return this.leadUnitNumber;
    }

    public void setLeadUnitNumber(String leadUnitNumber) {
        this.leadUnitNumber = leadUnitNumber;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    @Override
    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    @Override
    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getContactAdminPersonId() {
        return this.contactAdminPersonId;
    }

    public void setContactAdminPersonId(String contactAdminPersonId) {
        this.contactAdminPersonId = contactAdminPersonId;
    }

    public String getSubAwardOrganizationId() {
        return this.subAwardOrganizationId;
    }

    public void setSubAwardOrganizationId(String subAwardOrganizationId) {
        this.subAwardOrganizationId = subAwardOrganizationId;
    }

    public Negotiation getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(Negotiation negotiation) {
        this.negotiation = negotiation;
    }

    public Unit getLeadUnit() {
        return this.leadUnit;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
    }

    public Sponsor getSponsor() {
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public Sponsor getPrimeSponsor() {
        return this.primeSponsor;
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
    }

    public Organization getSubAwardOrganization() {
        return this.subAwardOrganization;
    }

    public void setSubAwardOrganization(Organization subAwardOrganization) {
        this.subAwardOrganization = subAwardOrganization;
    }

    public KcPerson getPIEmployee() {
        if (this.getPiPersonId() == null) {
            return null;
        }
        return this.getKcPersonService().getKcPersonByPersonId(this.getPiPersonId());
    }

    public Rolodex getPINonEmployee() {
        if (this.getPiRolodexId() == null) {
            return null;
        }
        try {
            return this.getRolodexService().getRolodex(Integer.parseInt(this.getPiRolodexId()));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected RolodexService getRolodexService() {
        return KraServiceLocator.getService(RolodexService.class);
    }

    public KcPerson getContactAdmin() {
        if (this.getContactAdminPersonId() == null) {
            return null;
        }
        return this.getKcPersonService().getKcPersonByPersonId(this.getContactAdminPersonId());
    }

    @Override
    public String getLeadUnitName() {
        String name = this.getLeadUnit() == null ? "" : this.getLeadUnit().getUnitName();
        return name;
    }

    @Override
    public String getPiName() {
        return this.piName;
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    @Override
    public String getPiEmployeeName() {
        String name = this.getPIEmployee() == null ? "" : this.getPIEmployee().getFullName();
        return name;
    }

    @Override
    public String getPiNonEmployeeName() {
        String name = this.getPINonEmployee() == null ? "" : this.getPINonEmployee().getFullName();
        return name;
    }

    @Override
    public String getAdminPersonName() {
        String name = this.getContactAdmin() == null ? "" : this.getContactAdmin().getFullName();
        return name;
    }

    @Override
    public String getSponsorName() {
        String name = this.getSponsor() == null ? "" : this.getSponsor().getSponsorName();
        return name;
    }

    @Override
    public String getPrimeSponsorName() {
        String name = this.getPrimeSponsor() == null ? "" : this.getPrimeSponsor().getSponsorName();
        return name;
    }

    @Override
    public String getSubAwardOrganizationName() {
        String name = this.getSubAwardOrganization() == null ? "" : this.getSubAwardOrganization().getOrganizationName();
        return name;
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> kcPeople = new ArrayList<NegotiationPersonDTO>();
        if (this.getPIEmployee() != null) {
            kcPeople.add(new NegotiationPersonDTO(this.getPIEmployee(), "PI"));
        }
        return kcPeople;
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return this.negotiableProposalTypeCode;
    }

    public void setNegotiableProposalTypeCode(String negotiableProposalTypeCode) {
        this.negotiableProposalTypeCode = negotiableProposalTypeCode;
    }

    @Override
    public String getAssociatedDocumentId() {
        if (this.getNegotiationUnassociatedDetailId() != null) {
            return this.getNegotiationUnassociatedDetailId().toString();
        }
        return "";
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return null;
    }

    public String getPiEmployeeUserName() {
        KcPerson pi = this.getPIEmployee();
        if (pi == null) {
            return this.piEmployeeUserName;
        }
        return pi.getUserName();
    }

    public void setPiEmployeeUserName(String piEmployeeUserName) {
        this.piEmployeeUserName = piEmployeeUserName;
        KcPerson pi = null;
        try {
            pi = this.getKcPersonService().getKcPersonByUserName(piEmployeeUserName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (pi != null) {
            this.setPiPersonId(pi.getPersonId());
        } else {
            this.setPiPersonId(null);
        }
    }

    public String getContactAdminUserName() {
        KcPerson admin = this.getContactAdmin();
        if (admin == null) {
            return this.contactAdminUserName;
        }
        return admin.getUserName();
    }

    public void setContactAdminUserName(String adminUserName) {
        this.contactAdminUserName = adminUserName;
        KcPerson admin = null;
        try {
            admin = this.getKcPersonService().getKcPersonByUserName(adminUserName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (admin != null) {
            this.setContactAdminPersonId(admin.getPersonId());
        } else {
            this.setContactAdminPersonId(null);
        }
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return "";
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return "";
    }
}

