/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.ExtendedPersistableBusinessObjectValuesFinder;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationAssociationTypeValuesFinder
extends ExtendedPersistableBusinessObjectValuesFinder {
    private BusinessObjectService businessObjectService;
    private NegotiationService negotiationService;

    @Override
    public List<KeyValue> getKeyValues() {
        ArrayList<ConcreteKeyValue> labels = new ArrayList<ConcreteKeyValue>();
        Collection associations = this.getBusinessObjectService().findAll(NegotiationAssociationType.class);
        for (NegotiationAssociationType type : associations) {
            if (!type.isActive()) continue;
            labels.add(new ConcreteKeyValue(type.getId().toString(), type.getDescription()));
        }
        Collections.sort(labels);
        labels.add(0, new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        ArrayList<KeyValue> returnLabels = new ArrayList<KeyValue>();
        returnLabels.addAll(labels);
        return returnLabels;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected NegotiationService getNegotiationService() {
        if (this.negotiationService == null) {
            this.negotiationService = KraServiceLocator.getService(NegotiationService.class);
        }
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }
}

