/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.lookup.NegotiationDao;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.dao.DataIntegrityViolationException;
import org.springmodules.orm.ojb.OjbOperationException;

public class NegotiationDaoOjb
extends LookupDaoOjb
implements NegotiationDao {
    private static final String ASSOC_PREFIX = "associatedNegotiable";
    private static final String NEGOTIATION_TYPE_ATTR = "negotiationAssociationTypeId";
    private static final String ASSOCIATED_DOC_ID_ATTR = "associatedDocumentId";
    private static final String INVALID_COLUMN_NAME = "NaN";
    private static Map<String, String> awardTransform = new HashMap<String, String>();
    private static Map<String, String> proposalTransform;
    private static Map<String, String> proposalLogTransform;
    private static Map<String, String> unassociatedTransform;
    private static Map<String, String> subAwardTransform;
    private static Integer maxSearchResults;
    private NegotiationService negotiationService;

    @Override
    public Collection<Negotiation> getNegotiationResults(Map<String, String> fieldValues) {
        HashMap<String, String> associationDetails = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iter = fieldValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!StringUtils.startsWith((String)entry.getKey(), (String)ASSOC_PREFIX)) continue;
            iter.remove();
            if (StringUtils.isEmpty((String)entry.getValue())) continue;
            associationDetails.put(entry.getKey().replaceFirst("associatedNegotiable.", ""), entry.getValue());
        }
        Collection<Negotiation> result = new ArrayList<Negotiation>();
        if (!associationDetails.isEmpty()) {
            this.addListToList(result, this.getNegotiationsLinkedToAward(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToProposal(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToProposalLog(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsUnassociated(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToSubAward(fieldValues, associationDetails));
        } else {
            result = this.findCollectionBySearchHelper(Negotiation.class, fieldValues, false, false, null);
        }
        if (result != null && !result.isEmpty() && StringUtils.isNotBlank((String)fieldValues.get("negotiationAge"))) {
            try {
                result = this.filterByNegotiationAge(fieldValues.get("negotiationAge"), result);
            }
            catch (NumberFormatException e) {
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Invalid Numeric Input: " + fieldValues.get("negotiationAge")});
                result = new ArrayList();
            }
        }
        return result;
    }

    private void addListToList(Collection<Negotiation> fullResultList, Collection<Negotiation> listToAdd) {
        if (fullResultList != null && listToAdd != null) {
            Integer max = this.getNegotiatonSearchResultsLimit();
            if (max == null) {
                max = 500;
            }
            if (fullResultList.size() < max) {
                int fullResultListPlusListToAddSize = fullResultList.size() + listToAdd.size();
                if (fullResultListPlusListToAddSize <= max) {
                    fullResultList.addAll(listToAdd);
                } else {
                    int numberOfNewEntriesToAdd = max - fullResultList.size();
                    int counter = 1;
                    for (Negotiation neg : listToAdd) {
                        if (counter < numberOfNewEntriesToAdd) {
                            fullResultList.add(neg);
                        }
                        ++counter;
                    }
                }
            }
        }
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly, Object additionalCriteria) {
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        if (usePrimaryKeyValuesOnly) {
            return this.executeSearch(businessObjectClass, this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, formProps), unbounded);
        }
        Criteria crit = this.getCollectionCriteriaFromMap(businessObject, formProps);
        if (additionalCriteria != null && additionalCriteria instanceof Criteria) {
            crit.addAndCriteria((Criteria)additionalCriteria);
        }
        return this.executeSearch(businessObjectClass, crit, unbounded);
    }

    private BusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to LookupDaoOjb findCollectionBySearchHelper... method was null");
        }
        BusinessObject businessObject = null;
        try {
            businessObject = (BusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    private Collection executeSearch(Class businessObjectClass, Criteria criteria, boolean unbounded) {
        Collection searchResults = new ArrayList();
        Long matchingResultsCount = null;
        try {
            Integer searchResultsLimit = this.getNegotiatonSearchResultsLimit();
            if (!unbounded && searchResultsLimit != null) {
                matchingResultsCount = new Long(this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria)));
                this.getDbPlatform().applyLimit(searchResultsLimit, criteria);
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = new Long(0L);
            }
            searchResults = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria));
            ArrayList bos = new ArrayList();
            bos.addAll(searchResults);
            searchResults = bos;
        }
        catch (OjbOperationException e) {
            throw new RuntimeException("NegotiationDaoOjb encountered exception during executeSearch", e);
        }
        catch (DataIntegrityViolationException e) {
            throw new RuntimeException("NegotiationDaoOjb encountered exception during executeSearch", e);
        }
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    private Integer getNegotiatonSearchResultsLimit() {
        if (maxSearchResults == null) {
            BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)KNSServiceLocator.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry("Negotiation");
            maxSearchResults = businessObjectEntry.getLookupDefinition().getResultSetLimit();
        }
        return maxSearchResults;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToAward(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, awardTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        values.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new Award(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(Award.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"awardNumber"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(NEGOTIATION_TYPE_ATTR, (Object)this.getNegotiationService().getNegotiationAssociationType("AWD").getId());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToProposal(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, proposalTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        values.put("proposalSequenceStatus", VersionStatus.ACTIVE.name());
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new InstitutionalProposal(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(InstitutionalProposal.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"proposalNumber"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(NEGOTIATION_TYPE_ATTR, (Object)this.getNegotiationService().getNegotiationAssociationType("IP").getId());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToProposalLog(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, proposalLogTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ProposalLog(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ProposalLog.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"proposalNumber"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(NEGOTIATION_TYPE_ATTR, (Object)this.getNegotiationService().getNegotiationAssociationType("PL").getId());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToSubAward(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, subAwardTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new SubAward(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(SubAward.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"subAwardId"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(NEGOTIATION_TYPE_ATTR, (Object)this.getNegotiationService().getNegotiationAssociationType("SWD").getId());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsUnassociated(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, unassociatedTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new NegotiationUnassociatedDetail(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(NegotiationUnassociatedDetail.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"negotiationUnassociatedDetailId"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(NEGOTIATION_TYPE_ATTR, (Object)this.getNegotiationService().getNegotiationAssociationType("NO").getId());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Map<String, String> transformMap(Map<String, String> values, Map<String, String> transformKey) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            if (transformKey.get(entry.getKey()) != null) {
                result.put(transformKey.get(entry.getKey()), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        if (result.containsKey(INVALID_COLUMN_NAME)) {
            return null;
        }
        return result;
    }

    protected Collection<Negotiation> filterByNegotiationAge(String value, Collection<Negotiation> negotiations) {
        int lowValue = 0;
        int highValue = 0;
        boolean greaterThan = false;
        boolean lessThan = false;
        boolean between = false;
        if (value.contains(">")) {
            greaterThan = true;
            lowValue = Integer.parseInt(value.replace(">", ""));
        } else if (value.contains("<")) {
            lessThan = true;
            highValue = Integer.parseInt(value.replace("<", ""));
        } else if (value.contains("..")) {
            between = true;
            String[] values = value.split("\\.\\.");
            lowValue = Integer.parseInt(values[0]);
            highValue = Integer.parseInt(values[1]);
        } else {
            lowValue = Integer.parseInt(value);
        }
        Iterator<Negotiation> iter = negotiations.iterator();
        while (iter.hasNext()) {
            Negotiation negotiation = iter.next();
            if (greaterThan) {
                if (negotiation.getNegotiationAge() > lowValue) continue;
                iter.remove();
                continue;
            }
            if (lessThan) {
                if (negotiation.getNegotiationAge() < highValue) continue;
                iter.remove();
                continue;
            }
            if (between) {
                if (negotiation.getNegotiationAge() >= lowValue && negotiation.getNegotiationAge() <= highValue) continue;
                iter.remove();
                continue;
            }
            if (negotiation.getNegotiationAge() == lowValue) continue;
            iter.remove();
        }
        return negotiations;
    }

    public NegotiationService getNegotiationService() {
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    static {
        awardTransform.put("sponsorName", "sponsor.sponsorName");
        awardTransform.put("piName", "projectPersons.fullName");
        awardTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        awardTransform.put("leadUnitNumber", "unitNumber");
        awardTransform.put("leadUnitName", "leadUnit.unitName");
        awardTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        proposalTransform = new HashMap<String, String>();
        proposalTransform.put("sponsorName", "sponsor.sponsorName");
        proposalTransform.put("piName", "projectPersons.fullName");
        proposalTransform.put("leadUnitNumber", "unitNumber");
        proposalTransform.put("leadUnitName", "leadUnit.unitName");
        proposalTransform.put("negotiableProposalTypeCode", "proposalTypeCode");
        proposalTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        proposalLogTransform = new HashMap<String, String>();
        proposalLogTransform.put("sponsorName", "sponsor.sponsorName");
        proposalLogTransform.put("leadUnitNumber", "leadUnit");
        proposalLogTransform.put("leadUnitName", "unit.unitName");
        proposalLogTransform.put("negotiableProposalTypeCode", "proposalTypeCode");
        proposalLogTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        unassociatedTransform = new HashMap<String, String>();
        unassociatedTransform.put("sponsorName", "sponsor.sponsorName");
        unassociatedTransform.put("piName", "piName");
        unassociatedTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        unassociatedTransform.put("leadUnitName", "leadUnit.unitName");
        unassociatedTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        subAwardTransform = new HashMap<String, String>();
        subAwardTransform.put("sponsorName", INVALID_COLUMN_NAME);
        subAwardTransform.put("sponsorCode", INVALID_COLUMN_NAME);
        subAwardTransform.put("piName", INVALID_COLUMN_NAME);
        subAwardTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        subAwardTransform.put("leadUnitNumber", "unitNumber");
        subAwardTransform.put("leadUnitName", "leadUnit.unitName");
        subAwardTransform.put("subAwardRequisitionerId", "requisitionerId");
    }
}

