/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.lookup.NegotiationDao;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.UrlFactory;

public class NegotiationLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = -5559605739121335896L;
    private static final String USER_ID = "userId";
    private NegotiationDao negotiationDao;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        if (this.getParameters().containsKey(USER_ID)) {
            fieldValues.put("associatedNegotiable.piId", ((String[])this.getParameters().get(USER_ID))[0]);
            fieldValues.put("negotiatorPersonId", ((String[])this.getParameters().get(USER_ID))[0]);
        }
        ArrayList<Negotiation> searchResults = new ArrayList<Negotiation>();
        searchResults.addAll(this.getNegotiationDao().getNegotiationResults(fieldValues));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        htmlDataList.add((HtmlData)this.getOpenLink((Document)((Negotiation)businessObject).getDocument()));
        htmlDataList.add((HtmlData)this.getMedusaLink((Document)((Negotiation)businessObject).getDocument(), false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Document document) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("docId", document.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    @Override
    protected String getDocumentTypeName() {
        return "NegotiationDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "negotiationId";
    }

    @Override
    protected String getHtmlAction() {
        return "negotiationNegotiation.do";
    }

    public NegotiationDao getNegotiationDao() {
        return this.negotiationDao;
    }

    public void setNegotiationDao(NegotiationDao negotiationDao) {
        this.negotiationDao = negotiationDao;
    }

    @Override
    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        String leadUnitName = "associatedNegotiable.leadUnitName";
        String leadUnitNumber = "associatedNegotiable.leadUnitNumber";
        String sponsorName = "associatedNegotiable.sponsorName";
        String piName = "associatedNegotiable.piName";
        Collection lookupStuff = super.performLookup(lookupForm, resultTable, bounded);
        for (ResultRow row : resultTable) {
            for (Column column : row.getColumns()) {
                if (StringUtils.equalsIgnoreCase((String)column.getPropertyName(), (String)"associatedNegotiable.leadUnitName") || StringUtils.equalsIgnoreCase((String)column.getPropertyName(), (String)"associatedNegotiable.sponsorName") || StringUtils.equalsIgnoreCase((String)column.getPropertyName(), (String)"associatedNegotiable.piName")) {
                    column.setPropertyURL("");
                    for (HtmlData.AnchorHtmlData data : column.getColumnAnchors()) {
                        if (data == null) continue;
                        data.setHref("");
                    }
                }
                if (!StringUtils.equalsIgnoreCase((String)column.getPropertyName(), (String)"associatedNegotiable.leadUnitNumber")) continue;
                String unitNumber = column.getPropertyValue();
                String newUrl = "inquiry.do?businessObjectClassName=org.kuali.kra.bo.Unit&unitNumber=" + unitNumber + "&methodToCall=start";
                column.setPropertyURL(newUrl);
                for (HtmlData.AnchorHtmlData data : column.getColumnAnchors()) {
                    if (data == null) continue;
                    data.setHref(newUrl);
                }
            }
        }
        return lookupStuff;
    }

    protected void setRows() {
        super.setRows();
        List lookupFieldAttributeList = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldAttributeList = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (StringUtils.equalsIgnoreCase((String)field.getPropertyName(), (String)"associatedNegotiable.sponsorCode")) {
                    field.setQuickFinderClassNameImpl("org.kuali.kra.bo.Sponsor");
                    field.setFieldConversions("sponsorCode:associatedNegotiable.sponsorCode");
                    field.setLookupParameters("");
                    field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl((boolean)false));
                    field.setImageSrc(null);
                    field.setInquiryParameters("associatedNegotiable.sponsorCode:sponsorCode");
                    field.setFieldDirectInquiryEnabled(true);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((String)field.getPropertyName(), (String)"associatedNegotiable.leadUnitNumber")) continue;
                field.setQuickFinderClassNameImpl("org.kuali.kra.bo.Unit");
                field.setFieldConversions("unitNumber:associatedNegotiable.leadUnitNumber");
                field.setLookupParameters("");
                field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl((boolean)false));
                field.setImageSrc(null);
                field.setInquiryParameters("associatedNegotiable.leadUnitNumber:unitNumber");
                field.setFieldDirectInquiryEnabled(true);
            }
        }
    }
}

