/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.notifications;

import java.util.List;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotificationRenderer;
import org.kuali.kra.negotiations.notifications.NegotiationNotificationRoleQualifierService;
import org.kuali.kra.util.EmailAttachment;

public class NegotiationCloseNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 70308097840555645L;
    private static final String NEGOTIATION_NOTIFICATION_MODULE_CODE = "5";
    private static final String NEGOTIATION_CLOSE_NOTIFICATION_ACTION_CODE = "100";
    private NegotiationDocument negotiationDocument;
    private List<EmailAttachment> emailAttachments;

    public NegotiationCloseNotificationContext(NegotiationDocument negotiationDocument) {
        super(KraServiceLocator.getService(NegotiationNotificationRenderer.class));
        ((NegotiationNotificationRenderer)this.getRenderer()).setNegotiation(negotiationDocument.getNegotiation());
        this.negotiationDocument = negotiationDocument;
        this.setNotificationService(KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService(KraServiceLocator.getService(NegotiationNotificationRoleQualifierService.class));
        ((NegotiationNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setNegotiation(negotiationDocument.getNegotiation());
    }

    @Override
    public String getModuleCode() {
        return NEGOTIATION_NOTIFICATION_MODULE_CODE;
    }

    @Override
    public String getActionTypeCode() {
        return NEGOTIATION_CLOSE_NOTIFICATION_ACTION_CODE;
    }

    @Override
    public String getDocumentNumber() {
        return this.negotiationDocument.getDocumentNumber();
    }

    @Override
    public String getContextName() {
        return "Close Notification";
    }

    public NegotiationDocument getNegotiationDocument() {
        return this.negotiationDocument;
    }

    public void setNegotiationDocument(NegotiationDocument negotiationDocument) {
        this.negotiationDocument = negotiationDocument;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }
}

