/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.printing.service.impl;

import java.util.Map;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.printing.NegotiationActivityPrintType;
import org.kuali.kra.negotiations.printing.print.NegotiationActivityprint;
import org.kuali.kra.negotiations.printing.service.NegotiationPrintingService;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;

public class NegotiationPrintingServiceImpl
implements NegotiationPrintingService {
    private PrintingService printingService;
    private NegotiationActivityprint negotiationActivityPrint;
    private String reportFileNamePrefix = "";

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public NegotiationActivityprint getNegotiationActivityPrint() {
        return this.negotiationActivityPrint;
    }

    public void setNegotiationActivityPrint(NegotiationActivityprint negotiationActivityPrint) {
        this.negotiationActivityPrint = negotiationActivityPrint;
    }

    @Override
    public AttachmentDataSource printNegotiationActivityReport(KraPersistableBusinessObjectBase negotiationDocument, NegotiationActivityPrintType negotiationReportType, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        NegotiationActivityprint printable = null;
        printable = this.getNegotiationActivityPrint();
        Negotiation negotiation = (Negotiation)negotiationDocument;
        this.reportFileNamePrefix = negotiation.getNegotiationId().toString();
        printable.setPrintableBusinessObject(negotiationDocument);
        printable.setReportParameters(reportParameters);
        source = this.getPrintingService().print(printable);
        source.setFileName(this.getReportName(this.reportFileNamePrefix, negotiationReportType.getNegotiationActivityPrintType()));
        source.setContentType("application/pdf");
        return source;
    }

    protected String getReportName(String reportFileNamePrefix, String reportName) {
        StringBuilder reportFullName = new StringBuilder(reportFileNamePrefix).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }
}

