/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationCloseNotificationContext;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.printing.NegotiationActivityPrintType;
import org.kuali.kra.negotiations.web.struts.action.NegotiationAction;
import org.kuali.kra.negotiations.web.struts.form.NegotiationForm;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationNegotiationAction
extends NegotiationAction {
    private static final Log LOG = LogFactory.getLog(NegotiationNegotiationAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.loadCodeObjects(negotiationForm.getNegotiationDocument().getNegotiation());
        negotiationForm.getMedusaBean().setModuleName("neg");
        negotiationForm.getMedusaBean().setModuleIdentifier(negotiationForm.getNegotiationDocument().getNegotiation().getNegotiationId());
        negotiationForm.getMedusaBean().generateParentNodes();
        negotiationForm.getNegotiationActivityHelper().sortActivities();
        negotiationForm.getNegotiationActivityHelper().generateAllAttachments();
        return actionForward;
    }

    public ActionForward negotiation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("Negotiation");
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        if (negotiationForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, negotiationForm);
        }
        negotiationForm.getTabStates().put("DocumentOverview", "false");
        return mapping.findForward("basic");
    }

    protected void loadDocumentInForm(HttpServletRequest request, NegotiationForm negotiationForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        NegotiationDocument retrievedDocument = (NegotiationDocument)this.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        negotiationForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getCustomDataHelper().prepareCustomData();
        this.loadCodeObjects(negotiationForm.getNegotiationDocument().getNegotiation());
        this.prepareNegotiation(negotiationForm);
        return actionForward;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        boolean sendCloseNotification = false;
        this.loadCodeObjects(negotiationForm.getNegotiationDocument().getNegotiation());
        Negotiation negotiation = negotiationForm.getNegotiationDocument().getNegotiation();
        Negotiation oldNegotiation = (Negotiation)this.getBusinessObjectService().findBySinglePrimaryKey(Negotiation.class, (Object)negotiation.getNegotiationId());
        if (negotiation.getNegotiationStatus() != null && this.getNegotiationService().getInProgressStatusCodes().contains(negotiation.getNegotiationStatus().getCode())) {
            negotiation.setNegotiationEndDate(null);
        } else if (oldNegotiation != null && oldNegotiation.getNegotiationStatus() != null && this.getNegotiationService().getInProgressStatusCodes().contains(oldNegotiation.getNegotiationStatus().getCode()) && negotiation.getNegotiationStatus() != null && this.getNegotiationService().getCompletedStatusCodes().contains(negotiation.getNegotiationStatus().getCode())) {
            if (negotiation.getNegotiationEndDate() != null && negotiationForm.getNegotiationActivityHelper().hasPendingActivities()) {
                StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "changePendingActivitiesKey", "negotiation.message.closePendingActivities", new String[0]);
                question.setCaller(((KualiForm)question.getForm()).getMethodToCall());
                if (!question.hasQuestionInstAttributeName() || !StringUtils.equals((String)question.getRequest().getParameter("questionIndex"), (String)question.getQuestionId())) return this.performQuestionWithoutInput(question, "");
                String buttonClicked = question.getRequest().getParameter("buttonClicked");
                if ("0".equals(buttonClicked)) {
                    negotiationForm.getNegotiationActivityHelper().closeAllPendingActivities();
                } else {
                    negotiation.setNegotiationStatus(oldNegotiation.getNegotiationStatus());
                    negotiation.setNegotiationStatusId(oldNegotiation.getNegotiationStatusId());
                    return mapping.findForward("basic");
                }
            }
            if (StringUtils.equals((String)negotiation.getNegotiationStatus().getCode(), (String)this.getNegotiationService().getCompleteStatusCode())) {
                sendCloseNotification = true;
            }
        }
        ActionForward actionForward = super.save(mapping, form, request, response);
        NegotiationCloseNotificationContext context = new NegotiationCloseNotificationContext(negotiationForm.getNegotiationDocument());
        if (sendCloseNotification && GlobalVariables.getMessageMap().getErrorCount() == 0) {
            if (negotiationForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                negotiationForm.getNotificationHelper().initializeDefaultValues(context);
                return mapping.findForward("notificationEditor");
            }
            this.getNotificationService().sendNotificationAndPersist(context, new NegotiationNotification(), negotiation);
        }
        if (negotiation.getUnAssociatedDetail() != null) {
            if (negotiation.getUnAssociatedDetail().getNegotiationId() == null) {
                negotiation.getUnAssociatedDetail().setNegotiationId(negotiation.getNegotiationId());
            }
            NegotiationUnassociatedDetail detail = negotiation.getUnAssociatedDetail();
            this.getBusinessObjectService().save((PersistableBusinessObject)detail);
            negotiation.setAssociatedDocumentId(negotiation.getUnAssociatedDetail().getNegotiationUnassociatedDetailId().toString());
            this.getBusinessObjectService().save((PersistableBusinessObject)negotiation);
            detail.refresh();
        }
        if (!negotiationForm.getNegotiationUnassociatedDetailsToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(negotiationForm.getNegotiationUnassociatedDetailsToDelete());
        }
        negotiation.refresh();
        return actionForward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        Negotiation negotiation = negotiationForm.getNegotiationDocument().getNegotiation();
        Negotiation oldNegotiation = null;
        if (negotiation.getNegotiationId() != null) {
            oldNegotiation = (Negotiation)this.getBusinessObjectService().findBySinglePrimaryKey(Negotiation.class, (Object)negotiation.getNegotiationId());
        }
        if (oldNegotiation == null || !StringUtils.equals((String)negotiation.getAssociatedDocumentId(), (String)oldNegotiation.getAssociatedDocumentId())) {
            Collection otherNegotiations;
            if (negotiation.getNegotiationAssociationType() != null) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("associatedDocumentId", negotiation.getAssociatedDocumentId());
                values.put("negotiationAssociationTypeId", negotiation.getNegotiationAssociationType().getId());
                otherNegotiations = this.getBusinessObjectService().findMatching(Negotiation.class, values);
            } else {
                otherNegotiations = new ArrayList();
            }
            if (!otherNegotiations.isEmpty()) {
                StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "duplicateLinkedNegotiations", "negotiation.message.duplicateNegotiationLinked", negotiation.getNegotiationAssociationType().getDescription());
                question.setCaller(((KualiForm)question.getForm()).getMethodToCall());
                if (question.hasQuestionInstAttributeName() && StringUtils.equals((String)question.getRequest().getParameter("questionIndex"), (String)question.getQuestionId())) {
                    String buttonClicked = question.getRequest().getParameter("buttonClicked");
                    if ("1".equals(buttonClicked)) {
                        if (oldNegotiation != null) {
                            negotiation.setAssociatedDocumentId(oldNegotiation.getAssociatedDocumentId());
                        } else {
                            negotiation.setAssociatedDocumentId(null);
                        }
                        return mapping.findForward("basic");
                    }
                } else {
                    return this.performQuestionWithoutInput(question, "");
                }
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        this.loadCodeObjects(negotiationForm.getNegotiationDocument().getNegotiation());
        return super.close(mapping, (ActionForm)negotiationForm, request, response);
    }

    private void loadCodeObjects(Negotiation negotiation) {
        HashMap primaryKeys = new HashMap();
        negotiation.refreshReferenceObject("negotiationAgreementType");
        negotiation.refreshReferenceObject("negotiationAssociationType");
        negotiation.refreshReferenceObject("negotiationStatus");
        if (negotiation.getUnAssociatedDetail() != null) {
            negotiation.getUnAssociatedDetail().refreshReferenceObject("sponsor");
            negotiation.getUnAssociatedDetail().refreshReferenceObject("primeSponsor");
            negotiation.getUnAssociatedDetail().refreshReferenceObject("subAwardOrganization");
        }
        for (NegotiationActivity activity : negotiation.getActivities()) {
            if (!activity.isUpdated()) continue;
            activity.updateActivity();
        }
    }

    public ActionForward changeAssociation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        Negotiation negotiation = negotiationForm.getNegotiationDocument().getNegotiation();
        Long associationTypeId = negotiation.getNegotiationAssociationTypeId();
        if (associationTypeId != null) {
            if (negotiation.getNegotiationAssociationType() != null) {
                String newAssociation;
                negotiation.setOldNegotiationAssociationTypeId(negotiation.getNegotiationAssociationType().getId());
                String oldAssociation = negotiation.getNegotiationAssociationType().getDescription();
                NegotiationAssociationType asscType = (NegotiationAssociationType)this.getBusinessObjectService().findBySinglePrimaryKey(NegotiationAssociationType.class, (Object)associationTypeId);
                String string = newAssociation = asscType != null ? asscType.getDescription() : "nothing";
                if (StringUtils.equals((String)negotiation.getNegotiationAssociationType().getCode(), (String)"NO")) {
                    newAssociation = newAssociation + ".  You will lose any Negotiation attributes that have been entered";
                }
                request.setAttribute("methodToCallAttribute", (Object)"methodToCall.changeAssociationRedirector");
                ActionForward confirmAction = this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "changeAssociationKey", "negotiation.message.changeAssociationType", oldAssociation, newAssociation), "confirmedChangeAssociation", "resetChangeAssociationType");
                return confirmAction;
            }
            return this.confirmedChangeAssociation(mapping, (ActionForm)negotiationForm, request, response);
        }
        negotiation.setAssociatedDocumentId("");
        return mapping.findForward("basic");
    }

    public ActionForward changeAssociationRedirector(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String buttonClicked = request.getParameter("buttonClicked").toString();
        if (StringUtils.equals((String)buttonClicked, (String)"0")) {
            return this.confirmedChangeAssociation(mapping, form, request, response);
        }
        return this.resetChangeAssociationType(mapping, form, request, response);
    }

    public ActionForward confirmedChangeAssociation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        NegotiationForm negotiationForm = (NegotiationForm)form;
        Long newAssociationTypeId = negotiationForm.getNegotiationDocument().getNegotiation().getNegotiationAssociationTypeId();
        if (newAssociationTypeId == null) {
            return mapping.findForward("lostPlaceMessagePage");
        }
        NegotiationAssociationType asscType = (NegotiationAssociationType)this.getBusinessObjectService().findBySinglePrimaryKey(NegotiationAssociationType.class, (Object)newAssociationTypeId);
        negotiationForm.getNegotiationDocument().getNegotiation().setNegotiationAssociationType(asscType);
        negotiationForm.getNegotiationDocument().getNegotiation().setAssociatedDocumentId("");
        if (asscType != null && StringUtils.equalsIgnoreCase((String)asscType.getCode(), (String)"NO")) {
            negotiationForm.getNegotiationDocument().getNegotiation().setUnAssociatedDetail(new NegotiationUnassociatedDetail());
        } else if (negotiationForm.getNegotiationDocument().getNegotiation().getUnAssociatedDetail() != null) {
            negotiationForm.getNegotiationUnassociatedDetailsToDelete().add(negotiationForm.getNegotiationDocument().getNegotiation().getUnAssociatedDetail());
            negotiationForm.getNegotiationDocument().getNegotiation().setUnAssociatedDetail(null);
        }
        negotiationForm.populate(request);
        return actionForward;
    }

    public ActionForward resetChangeAssociationType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForward = mapping.findForward("basic");
        NegotiationForm negotiationForm = (NegotiationForm)form;
        Negotiation negotiation = negotiationForm.getNegotiationDocument().getNegotiation();
        negotiation.setNegotiationAssociationTypeId(negotiation.getOldNegotiationAssociationTypeId());
        return actionForward;
    }

    public ActionForward addActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().addActivity();
        return mapping.findForward("basic");
    }

    public ActionForward restrictActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().setRestrictedActivity(Boolean.TRUE, this.getActivityIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward unrestrictActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().setRestrictedActivity(Boolean.FALSE, this.getActivityIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward addAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().addAttachment(this.getActivityIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().deleteAttachment(this.getActivityIndex(request), this.getAttachmentIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward restrictAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().setRestrictedAttachment(Boolean.TRUE, this.getActivityIndex(request), this.getAttachmentIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward unrestrictAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().setRestrictedAttachment(Boolean.FALSE, this.getActivityIndex(request), this.getAttachmentIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        NegotiationActivityAttachment attachment = negotiationForm.getNegotiationActivityHelper().getActivity(this.getActivityIndex(request)).getAttachments().get(this.getAttachmentIndex(request));
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), NegotiationNegotiationAction.getValidHeaderString(file.getName()), NegotiationNegotiationAction.getValidHeaderString(file.getType()), response);
        return null;
    }

    public ActionForward viewAttachmentFromAllAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        NegotiationActivityAttachment attachment = negotiationForm.getNegotiationActivityHelper().getAllAttachments().get(this.getAttachmentIndex(request));
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), NegotiationNegotiationAction.getValidHeaderString(file.getName()), NegotiationNegotiationAction.getValidHeaderString(file.getType()), response);
        return null;
    }

    protected Integer getActivityIndex(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            return Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)".activityIndex", (String)"."));
        }
        return null;
    }

    protected Integer getAttachmentIndex(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            return Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)".attachmentIndex", (String)"."));
        }
        return null;
    }

    public ActionForward refreshView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward printNegotiationActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        NegotiationForm negotiationForm = (NegotiationForm)form;
        NegotiationDocument negotiationDocument = negotiationForm.getNegotiationDocument();
        Negotiation negotiation = negotiationDocument.getNegotiation();
        negotiation.setPrintindex(0);
        negotiation.setPrintAll(StringUtils.equals((String)negotiationForm.getFilterActivities(), (String)negotiationForm.getFilterAllActivities()));
        AttachmentDataSource dataStream = this.getNegotiationPrintingService().printNegotiationActivityReport(negotiation, NegotiationActivityPrintType.NEGOTIATION_ACTIVITY_REPORT, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int printindex = this.getActivityIndex(request);
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        NegotiationForm negotiationForm = (NegotiationForm)form;
        NegotiationDocument negotiationDocument = negotiationForm.getNegotiationDocument();
        Negotiation negotiation = negotiationDocument.getNegotiation();
        negotiation.setPrintindex(printindex + 1);
        AttachmentDataSource dataStream = this.getNegotiationPrintingService().printNegotiationActivityReport(negotiation, NegotiationActivityPrintType.NEGOTIATION_ACTIVITY_REPORT, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward deleteActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "deleteActivityKey", "negotiation.message.deleteActivity", new String[0]), "confirmDeleteActivity", null);
    }

    public ActionForward confirmDeleteActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NegotiationForm negotiationForm = (NegotiationForm)form;
        negotiationForm.getNegotiationActivityHelper().deleteActivity(this.getActivityIndex(request));
        return mapping.findForward("basic");
    }

    public ActionForward returnToPortal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("portal");
    }
}

