/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.PersonMassChangeService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class PersonMassChangeDocument
extends ResearchDocumentBase
implements Serializable {
    public static final String DOCUMENT_TYPE_CODE = "PMC";
    private static final long serialVersionUID = 4841496352465715699L;
    private static final Log LOG = LogFactory.getLog(ProtocolDocument.class);
    private List<PersonMassChange> personMassChangeList = new ArrayList<PersonMassChange>();
    private transient PersonMassChangeService personMassChangeService;

    public PersonMassChangeDocument() {
        PersonMassChange newPersonMassChange = new PersonMassChange();
        newPersonMassChange.setPersonMassChangeDocument(this);
        this.personMassChangeList.add(newPersonMassChange);
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public List<PersonMassChange> getPersonMassChangeList() {
        return this.personMassChangeList;
    }

    public void setPersonMassChangeList(List<PersonMassChange> personMassChangeList) {
        this.personMassChangeList = personMassChangeList;
    }

    public PersonMassChange getPersonMassChange() {
        return this.personMassChangeList.isEmpty() ? null : this.personMassChangeList.get(0);
    }

    public void setPersonMassChange(PersonMassChange personMassChange) {
        this.personMassChangeList.set(0, personMassChange);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.isFinal(statusChangeEvent)) {
            try {
                String routeHeaderId = this.getDocumentHeader().getWorkflowDocument().getDocumentId();
                DocumentRouteHeaderValue document = KraServiceLocator.getService(RouteHeaderService.class).getRouteHeader(routeHeaderId);
                String principalId = ((ActionTakenValue)document.getActionsTaken().get(document.getActionsTaken().size() - 1)).getPrincipalId();
                String asyncPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
                String asyncPrincipalName = GlobalVariables.getUserSession().getPrincipalName();
                if (!principalId.equals(asyncPrincipalId)) {
                    KcPerson person = KraServiceLocator.getService(KcPersonService.class).getKcPersonByPersonId(principalId);
                    GlobalVariables.setUserSession((UserSession)new UserSession(person.getUserName()));
                    this.getPersonMassChangeService().performPersonMassChange(this.getPersonMassChange());
                    GlobalVariables.setUserSession((UserSession)new UserSession(asyncPrincipalName));
                }
            }
            catch (Exception we) {
                LOG.error((Object)"Could not access route header id to perform Person Mass Change");
            }
        }
    }

    private boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)"F", (String)statusChangeEvent.getNewRouteStatus());
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && this.getDocumentHeader().getWorkflowDocument().isFinal()) {
            isComplete = true;
        }
        return isComplete;
    }

    public PersonMassChangeService getPersonMassChangeService() {
        if (this.personMassChangeService == null) {
            this.personMassChangeService = KraServiceLocator.getService(PersonMassChangeService.class);
        }
        return this.personMassChangeService;
    }

    public void setPersonMassChangeService(PersonMassChangeService personMassChangeService) {
        this.personMassChangeService = personMassChangeService;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }
}

