/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.IacucProtocolPersonMassChangeService;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.PersonEditableService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class IacucProtocolPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements IacucProtocolPersonMassChangeService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String PROTOCOL = "protocol";
    private static final String IACUC_WARNINGS = "iacucWarnings";
    private PersonEditableService personEditableService;
    private ProtocolPersonTrainingService protocolPersonTrainingService;

    @Override
    public List<IacucProtocol> getIacucProtocolChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<IacucProtocol> protocolChangeCandidates = new ArrayList<IacucProtocol>();
        ArrayList<IacucProtocol> protocols = new ArrayList<IacucProtocol>();
        if (personMassChange.getIacucProtocolPersonMassChange().requiresChange()) {
            protocols.addAll(this.getProtocols(personMassChange));
        }
        for (IacucProtocol protocol : protocols) {
            if (!this.isProtocolChangeCandidate(personMassChange, protocol)) continue;
            protocolChangeCandidates.add(protocol);
        }
        for (IacucProtocol protocolChangeCandidate : protocolChangeCandidates) {
            if (protocolChangeCandidate.getProtocolDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(protocolChangeCandidate);
        }
        return protocolChangeCandidates;
    }

    private List<IacucProtocol> getProtocols(PersonMassChange personMassChange) {
        ArrayList<IacucProtocol> protocols = new ArrayList<IacucProtocol>();
        Collection allProtocols = this.getBusinessObjectService().findAll(IacucProtocol.class);
        if (personMassChange.isChangeAllSequences()) {
            protocols.addAll(allProtocols);
        } else {
            protocols.addAll(this.getLatestProtocols(allProtocols));
        }
        return protocols;
    }

    private List<IacucProtocol> getLatestProtocols(Collection<IacucProtocol> protocols) {
        ArrayList<IacucProtocol> latestProtocols = new ArrayList<IacucProtocol>();
        for (String uniqueProtocolNumber : this.getUniqueProtocolNumbers(protocols)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(PROTOCOL_NUMBER, uniqueProtocolNumber);
            Collection uniqueProtocols = this.getBusinessObjectService().findMatchingOrderBy(IacucProtocol.class, fieldValues, SEQUENCE_NUMBER, false);
            if (uniqueProtocols.isEmpty()) continue;
            latestProtocols.add((IacucProtocol)CollectionUtils.get((Object)uniqueProtocols, (int)0));
        }
        return latestProtocols;
    }

    private Set<String> getUniqueProtocolNumbers(Collection<IacucProtocol> protocols) {
        HashSet<String> uniqueProtocolIds = new HashSet<String>();
        for (IacucProtocol protocol : protocols) {
            uniqueProtocolIds.add(protocol.getProtocolNumber());
        }
        return uniqueProtocolIds;
    }

    private boolean isProtocolChangeCandidate(PersonMassChange personMassChange, IacucProtocol protocol) {
        boolean isProtocolChangeCandidate = false;
        boolean hasErrors = false;
        List<ProtocolPersonBase> persons = protocol.getProtocolPersons();
        List<ProtocolOnlineReviewBase> onlineReviews = protocol.getProtocolOnlineReviews();
        String[] investigatorRoles = new String[]{"PI", "COI"};
        String[] keyStudyPersonRoles = new String[]{"SP"};
        String[] correspondentsRoles = new String[]{"CRC"};
        if (personMassChange.getIacucProtocolPersonMassChange().isInvestigator()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, investigatorRoles);
        }
        if (personMassChange.getIacucProtocolPersonMassChange().isKeyStudyPerson()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, keyStudyPersonRoles);
        }
        if (personMassChange.getIacucProtocolPersonMassChange().isCorrespondents()) {
            isProtocolChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, correspondentsRoles);
        }
        if (isProtocolChangeCandidate) {
            hasErrors |= !this.isReplacerValidPersonChangeCandidate(personMassChange, persons);
        }
        if (personMassChange.getIacucProtocolPersonMassChange().isReviewer()) {
            isProtocolChangeCandidate |= this.isReviewerChangeCandidate(personMassChange, onlineReviews);
        }
        return isProtocolChangeCandidate && !hasErrors;
    }

    private boolean isReviewerChangeCandidate(PersonMassChange personMassChange, List<ProtocolOnlineReviewBase> onlineReviews) {
        boolean isReviewerChangeCandidate = false;
        for (ProtocolOnlineReviewBase onlineReview : onlineReviews) {
            ProtocolReviewer reviewer = onlineReview.getProtocolReviewer();
            if (!this.isPersonIdMassChange(personMassChange, reviewer.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, reviewer.getRolodexId())) continue;
            isReviewerChangeCandidate = true;
            break;
        }
        return isReviewerChangeCandidate;
    }

    @Override
    public void performPersonMassChange(PersonMassChange personMassChange, List<IacucProtocol> protocolChangeCandidates) {
        for (IacucProtocol protocolChangeCandidate : protocolChangeCandidates) {
            if (!protocolChangeCandidate.getProtocolDocument().getPessimisticLocks().isEmpty()) continue;
            this.performInvestigatorPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performKeyStudyPersonPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performCorrespondentsPersonMassChange(personMassChange, protocolChangeCandidate);
            this.performReviewerPersonMassChange(personMassChange, protocolChangeCandidate);
        }
    }

    private void performInvestigatorPersonMassChange(PersonMassChange personMassChange, IacucProtocol protocol) {
        if (personMassChange.getIacucProtocolPersonMassChange().isInvestigator()) {
            String[] personRoles = new String[]{"PI", "COI"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performKeyStudyPersonPersonMassChange(PersonMassChange personMassChange, IacucProtocol protocol) {
        if (personMassChange.getIacucProtocolPersonMassChange().isKeyStudyPerson()) {
            String[] personRoles = new String[]{"SP"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performCorrespondentsPersonMassChange(PersonMassChange personMassChange, IacucProtocol protocol) {
        if (personMassChange.getIacucProtocolPersonMassChange().isCorrespondents()) {
            String[] personRoles = new String[]{"CRC"};
            this.performPersonPersonMassChange(personMassChange, protocol, personRoles);
        }
    }

    private void performPersonPersonMassChange(PersonMassChange personMassChange, IacucProtocol protocol, String ... personRoles) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            if (!this.isPersonInRole(person, personRoles) || !this.isPersonIdMassChange(personMassChange, person.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, person.getRolodexId())) continue;
            if (personMassChange.getReplacerPersonId() != null) {
                KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                person.setPersonId(personMassChange.getReplacerPersonId());
                person.setRolodexId(null);
                person.setPersonName(kcPerson.getFullName());
                this.getPersonEditableService().populateContactFieldsFromPersonId(person);
                this.getProtocolPersonTrainingService().setTrainedFlag(person);
                for (ProtocolUnitBase unit : person.getProtocolUnits()) {
                    unit.setPersonId(personMassChange.getReplacerPersonId());
                }
            } else if (personMassChange.getReplacerRolodexId() != null) {
                Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId());
                person.setPersonId(null);
                person.setRolodexId(rolodex.getRolodexId());
                person.setPersonName(rolodex.getFullName());
                this.getPersonEditableService().populateContactFieldsFromRolodexId(person);
                this.getProtocolPersonTrainingService().setTrainedFlag(person);
                for (ProtocolUnitBase unit : person.getProtocolUnits()) {
                    unit.setPersonId(null);
                }
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)person);
        }
    }

    private void performReviewerPersonMassChange(PersonMassChange personMassChange, IacucProtocol protocol) {
        if (personMassChange.getIacucProtocolPersonMassChange().isReviewer()) {
            for (ProtocolOnlineReviewBase onlineReview : protocol.getProtocolOnlineReviews()) {
                ProtocolReviewer reviewer = onlineReview.getProtocolReviewer();
                if (!this.isPersonIdMassChange(personMassChange, reviewer.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, reviewer.getRolodexId())) continue;
                if (personMassChange.getReplacerPersonId() != null) {
                    KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(personMassChange.getReplacerPersonId());
                    reviewer.setPersonId(kcPerson.getPersonId());
                    reviewer.setRolodexId(null);
                    reviewer.setNonEmployeeFlag(false);
                } else if (personMassChange.getReplacerRolodexId() != null) {
                    Rolodex rolodex = this.getRolodexService().getRolodex(personMassChange.getReplacerRolodexId());
                    reviewer.setRolodexId(rolodex.getRolodexId());
                    reviewer.setPersonId(null);
                    reviewer.setNonEmployeeFlag(true);
                }
                this.getBusinessObjectService().save((PersistableBusinessObject)reviewer);
            }
        }
    }

    private void reportSoftError(IacucProtocol protocol) {
        String protocolNumber = protocol.getProtocolNumber();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", PROTOCOL, protocolNumber);
    }

    public PersonEditableService getPersonEditableService() {
        return this.personEditableService;
    }

    public void setPersonEditableService(PersonEditableService personEditableService) {
        this.personEditableService = personEditableService;
    }

    public ProtocolPersonTrainingService getProtocolPersonTrainingService() {
        return this.protocolPersonTrainingService;
    }

    public void setProtocolPersonTrainingService(ProtocolPersonTrainingService protocolPersonTrainingService) {
        this.protocolPersonTrainingService = protocolPersonTrainingService;
    }

    @Override
    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((IacucProtocol)parent).getProtocolNumber();
    }

    @Override
    protected String getDocumentName() {
        return PROTOCOL;
    }

    @Override
    protected String getWarningKey() {
        return IACUC_WARNINGS;
    }
}

