/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.web.struts.form;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;

public class PersonMassChangeHelperBase
implements Serializable {
    private static final long serialVersionUID = -2693177271931144987L;
    private transient KcPersonService kcPersonService;
    private transient RolodexService rolodexService;

    public void prepareReplaceeView(PersonMassChange personMassChange, String replaceePersonId, Integer replaceeRolodexId) {
        if (StringUtils.isNotBlank((String)replaceePersonId)) {
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(replaceePersonId);
            personMassChange.setReplaceePersonId(person.getPersonId());
            personMassChange.setReplaceeFullName(person.getFullName());
            personMassChange.setReplaceeRolodexId(null);
        } else if (replaceeRolodexId != null) {
            personMassChange.setReplaceePersonId(null);
            Rolodex rolodex = this.getRolodexService().getRolodex(replaceeRolodexId);
            personMassChange.setReplaceeRolodexId(rolodex.getRolodexId());
            personMassChange.setReplaceeFullName(rolodex.getFullName());
        }
    }

    public void prepareReplacerView(PersonMassChange personMassChange, String replacerPersonId, Integer replacerRolodexId) {
        if (StringUtils.isNotBlank((String)replacerPersonId)) {
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(replacerPersonId);
            personMassChange.setReplacerPersonId(person.getPersonId());
            personMassChange.setReplacerFullName(person.getFullName());
            personMassChange.setReplacerRolodexId(null);
        } else if (replacerRolodexId != null) {
            personMassChange.setReplacerPersonId(null);
            Rolodex rolodex = this.getRolodexService().getRolodex(replacerRolodexId);
            personMassChange.setReplacerRolodexId(rolodex.getRolodexId());
            personMassChange.setReplacerFullName(rolodex.getFullName());
        }
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RolodexService getRolodexService() {
        if (this.rolodexService == null) {
            this.rolodexService = KraServiceLocator.getService(RolodexService.class);
        }
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}

