/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.printing.service.impl;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Overlay;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.util.ImageParameters;
import org.kuali.kra.bo.PersonSignature;
import org.kuali.kra.dao.PersonSignatureDao;
import org.kuali.kra.printing.PersonSignatureLocationHelper;
import org.kuali.kra.printing.PersonSignaturePrintHelper;
import org.kuali.kra.printing.service.PersonSignatureService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class PersonSignatureServiceImpl
implements PersonSignatureService {
    private static final String CORRESPONDENCE_SIGNATURE_TYPE = "CORRESPONDENCE_SIGNATURE_TYPE";
    private static final String CORRESPONDENCE_SIGNATURE_TAG = "CORRESPONDENCE_SIGNATURE_TAG";
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private RoleService roleService;
    private PersonSignatureDao personSignatureDao;
    private static final float ADDITIONAL_SPACE_BETWEEN_TAG_AND_IMAGE = 10.0f;
    private static final Log LOG = LogFactory.getLog(PersonSignatureServiceImpl.class);
    private String leadUnitNumber;
    private String administratorType;
    private String moduleNameSpace;

    @Override
    public byte[] applySignature(String leadUnitNumber, String administratorType, String moduleNameSpace, byte[] pdfBytes) throws Exception {
        this.leadUnitNumber = leadUnitNumber;
        this.administratorType = administratorType;
        this.moduleNameSpace = moduleNameSpace;
        byte[] pdfFileData = pdfBytes;
        ByteArrayOutputStream byteArrayOutputStream = this.getOriginalPdfDocumentAsOutputsStream(pdfBytes);
        if (ObjectUtils.isNotNull((Object)(byteArrayOutputStream = this.identifyModeAndApplySignature(byteArrayOutputStream)))) {
            pdfFileData = byteArrayOutputStream.toByteArray();
        }
        return pdfFileData;
    }

    protected ByteArrayOutputStream getFlattenedPdfForm(byte[] pdfBytes) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(pdfBytes);
        PDDocument pdDoc = PDDocument.load((InputStream)is);
        PDDocumentCatalog pdCatalog = pdDoc.getDocumentCatalog();
        PDAcroForm acroForm = pdCatalog.getAcroForm();
        COSDictionary acroFormDict = acroForm.getDictionary();
        COSArray fields = (COSArray)acroFormDict.getDictionaryObject("Fields");
        fields.clear();
        pdDoc.save((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    protected ByteArrayOutputStream identifyModeAndApplySignature(ByteArrayOutputStream originalByteArrayOutputStream) throws Exception {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        String signatureTypeParam = this.getSignatureTypeParameter();
        SignatureTypes signatureType = SignatureTypes.NO_SIGNATURE_REQURIED;
        if (ObjectUtils.isNotNull((Object)signatureTypeParam)) {
            signatureType = SignatureTypes.getSignatureMode(signatureTypeParam);
        }
        if (signatureType != null) {
            switch (signatureType) {
                case DEFAULT_SIGNATURE: {
                    outputStream = this.printDefaultSignature(outputStream);
                    break;
                }
                case SIGNED_IN_USER_SIGNATURE: {
                    String personId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
                    outputStream = this.printLoggedInUserSignature(personId, outputStream);
                    break;
                }
            }
        } else {
            LOG.warn((Object)"Invalid signature type defined in parameter");
        }
        return outputStream;
    }

    protected ByteArrayOutputStream printDefaultSignature(ByteArrayOutputStream originalByteArrayOutputStream) throws Exception {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        PersonSignature adminSignature = this.getAdminSignature();
        if (ObjectUtils.isNotNull((Object)((Object)adminSignature)) && ObjectUtils.isNotNull((Object)adminSignature.getAttachmentContent())) {
            outputStream = this.applyAutographInDocument(adminSignature, outputStream);
        }
        return outputStream;
    }

    protected ByteArrayOutputStream printLoggedInUserSignature(String personId, ByteArrayOutputStream originalByteArrayOutputStream) throws Exception {
        PersonSignature userSignature = this.getLoggedinPersonSignature(personId);
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        if (ObjectUtils.isNull((Object)((Object)userSignature))) {
            userSignature = this.getAdminSignature();
        }
        if (ObjectUtils.isNotNull((Object)((Object)userSignature)) && ObjectUtils.isNotNull((Object)userSignature.getAttachmentContent())) {
            outputStream = this.applyAutographInDocument(userSignature, outputStream);
        }
        return outputStream;
    }

    protected ByteArrayOutputStream applyAutographInDocument(PersonSignature personSignature, ByteArrayOutputStream originalByteArrayOutputStream) {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        try {
            if (personSignature.getAttachmentContent() != null) {
                outputStream = this.scanAndApplyAutographInEachPage(personSignature.getAttachmentContent(), outputStream);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception while applying signature : Method applyAutographInDocument : " + ex.getMessage()));
            ex.printStackTrace();
        }
        return outputStream;
    }

    protected ByteArrayOutputStream scanAndApplyAutographInEachPage(byte[] imageData, ByteArrayOutputStream originalByteArrayOutputStream) throws Exception {
        ByteArrayOutputStream outputStream = originalByteArrayOutputStream;
        byte[] pdfFileData = originalByteArrayOutputStream.toByteArray();
        PDDocument originalDocument = this.getPdfDocument(pdfFileData);
        PDDocument signatureDocument = new PDDocument();
        List originalDocumentPages = originalDocument.getDocumentCatalog().getAllPages();
        for (PDPage page : originalDocumentPages) {
            ArrayList<String> signatureTags = new ArrayList<String>(this.getSignatureTagParameter());
            PersonSignatureLocationHelper printer = new PersonSignatureLocationHelper(signatureTags);
            PDStream contents = page.getContents();
            if (contents != null) {
                printer.processStream(page, page.findResources(), page.getContents().getStream());
            }
            PDPage signaturePage = new PDPage();
            if (printer.isSignatureTagExists()) {
                PDJpeg signatureImage = new PDJpeg(signatureDocument, this.getBufferedImage(imageData));
                PDPageContentStream stream = new PDPageContentStream(signatureDocument, signaturePage, true, true);
                for (PersonSignaturePrintHelper signatureHelper : printer.getPersonSignatureLocations()) {
                    float coordinateX = signatureHelper.getCoordinateX();
                    float coordinateY = signatureHelper.getCoordinateY() - (float)signatureImage.getHeight() - 10.0f;
                    stream.drawImage((PDXObjectImage)signatureImage, coordinateX, coordinateY);
                    stream.close();
                }
            } else {
                signaturePage = page;
            }
            signatureDocument.addPage(signaturePage);
        }
        Overlay overlay = new Overlay();
        overlay.overlay(signatureDocument, originalDocument);
        originalDocument.save((OutputStream)outputStream);
        originalDocument.close();
        signatureDocument.close();
        return outputStream;
    }

    private PDDocument getPdfDocument(byte[] pdfFileData) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(pdfFileData);
        PDDocument originalDocument = PDDocument.load((InputStream)is);
        return originalDocument;
    }

    private ByteArrayOutputStream getOriginalPdfDocumentAsOutputsStream(byte[] pdfFileData) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(pdfFileData);
        PDDocument originalDocument = PDDocument.load((InputStream)is);
        originalDocument.save((OutputStream)outputStream);
        originalDocument.close();
        return outputStream;
    }

    protected BufferedImage getBufferedImage(ImageParameters params, byte[] imageData) {
        byte[] transparentColors = new byte[]{-1, -1};
        byte[] colors = new byte[]{0, -1};
        IndexColorModel colorModel = new IndexColorModel(1, 2, colors, colors, colors, transparentColors);
        BufferedImage image = new BufferedImage(params.getWidth(), params.getHeight(), 12, colorModel);
        DataBufferByte buffer = new DataBufferByte(imageData, 1);
        WritableRaster raster = Raster.createPackedRaster(buffer, params.getWidth(), params.getHeight(), params.getBitsPerComponent(), new Point(0, 0));
        image.setData(raster);
        return image;
    }

    protected BufferedImage getBufferedImage(byte[] imageData) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        BufferedImage image = ImageIO.read(in);
        return image;
    }

    protected PersonSignature getAdminSignature() {
        List<RoleMembership> moduleAdministrators = this.getAdministrators();
        HashSet<String> personIdsForSignature = new HashSet<String>();
        for (RoleMembership roleMembership : moduleAdministrators) {
            personIdsForSignature.add(roleMembership.getMemberId());
        }
        List<PersonSignature> personSignatures = this.getPersonSignatureDao().getPersonSignatureForPersonIds(personIdsForSignature);
        PersonSignature adminSignature = null;
        for (PersonSignature personSignature : personSignatures) {
            if (!personSignature.isDefaultAdminSignature()) continue;
            adminSignature = personSignature;
            break;
        }
        return adminSignature;
    }

    protected PersonSignature getLoggedinPersonSignature(String personId) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("personId", personId);
        fieldValues.put("signatureActive", Boolean.TRUE);
        PersonSignature personSignature = (PersonSignature)this.getBusinessObjectService().findByPrimaryKey(PersonSignature.class, fieldValues);
        return personSignature;
    }

    protected List<RoleMembership> getAdministrators() {
        ArrayList<String> roleIds = new ArrayList<String>();
        String roleId = this.getRoleService().getRoleIdByNamespaceCodeAndName("KC-UNT", this.getAdministratorType());
        roleIds.add(roleId);
        HashMap<String, String> attrSet = new HashMap<String, String>();
        attrSet.put("unitNumber", this.getLeadUnitNumber());
        return this.getRoleService().getRoleMembers(roleIds, attrSet);
    }

    protected String getSignatureTypeParameter() {
        return this.getParameterService().getParameterValueAsString(this.getModuleNameSpace(), "Document", CORRESPONDENCE_SIGNATURE_TYPE);
    }

    protected Collection<String> getSignatureTagParameter() {
        return this.getParameterService().getParameterValuesAsString(this.getModuleNameSpace(), "Document", CORRESPONDENCE_SIGNATURE_TAG);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public PersonSignatureDao getPersonSignatureDao() {
        return this.personSignatureDao;
    }

    public void setPersonSignatureDao(PersonSignatureDao personSignatureDao) {
        this.personSignatureDao = personSignatureDao;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected String getLeadUnitNumber() {
        return this.leadUnitNumber;
    }

    protected String getAdministratorType() {
        return this.administratorType;
    }

    public String getModuleNameSpace() {
        return this.moduleNameSpace;
    }

    public static enum SignatureTypes {
        DEFAULT_SIGNATURE("D"),
        SIGNED_IN_USER_SIGNATURE("S"),
        NO_SIGNATURE_REQURIED("N");

        private String signatureType;

        private SignatureTypes(String signatureType) {
            this.signatureType = signatureType;
        }

        public String getSignatureType() {
            return this.signatureType;
        }

        public static SignatureTypes getSignatureMode(String signatureType) {
            for (SignatureTypes sType : SignatureTypes.values()) {
                if (!sType.signatureType.equals(signatureType)) continue;
                return sType;
            }
            return null;
        }
    }
}

