/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.NoticeOfOpportunity;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.coi.Disclosurable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KcKrmsContextBo;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.proposaldevelopment.bo.CongressionalDistrict;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.proposaldevelopment.bo.LookupableDevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.PropScienceKeyword;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalChangedData;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalState;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.bo.YnqGroupName;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetChangedData;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyStatusConstants;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonBiographyService;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.YnqService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class DevelopmentProposal
extends KraPersistableBusinessObjectBase
implements BudgetParent,
Sponsorable,
Disclosurable,
KcKrmsContextBo {
    private static final long serialVersionUID = -9211313487776934111L;
    private static final String ATTACHMENTS_COMPLETE = "Complete";
    private static final String ATTACHMENTS_INCOMPLETE = "Inomplete";
    private static final String ATTACHMENTS_NONE = "None";
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    private String proposalNumber;
    private String proposalTypeCode;
    private ProposalType proposalType;
    private String continuedFrom;
    private String sponsorCode;
    private String activityTypeCode;
    private String ownedByUnitNumber;
    private Date requestedStartDateInitial;
    private Date requestedEndDateInitial;
    private String title;
    private String currentAwardNumber;
    private Date deadlineDate;
    private String deadlineTime;
    private String noticeOfOpportunityCode;
    private NoticeOfOpportunity noticeOfOpportunity;
    private String deadlineType;
    private Integer anticipatedAwardTypeCode;
    private AwardType anticipatedAwardType;
    private String cfdaNumber;
    private String programAnnouncementNumber;
    private String primeSponsorCode;
    private String sponsorProposalNumber;
    private String nsfCode;
    private NsfCode nsfCodeBo;
    private Boolean subcontracts;
    private String agencyDivisionCode;
    private String agencyProgramCode;
    private String programAnnouncementTitle;
    private String mailBy;
    private String mailType;
    private String mailAccountNumber;
    private String mailDescription;
    private Integer mailingAddressId;
    private String numberOfCopies;
    private String proposalStateTypeCode;
    private ProposalState proposalState;
    private List<ProposalSite> proposalSites;
    private Rolodex rolodex;
    private List<ProposalSpecialReview> propSpecialReviews;
    private List<PropScienceKeyword> propScienceKeywords;
    private List<ProposalPerson> proposalPersons;
    private List<S2sOppForms> s2sOppForms;
    private S2sOpportunity s2sOpportunity;
    private List<S2sAppSubmission> s2sAppSubmission;
    private String newScienceKeywordCode;
    private String newDescription;
    private Sponsor sponsor;
    private Integer nextProposalPersonNumber;
    private String budgetStatus;
    private String budgetStatusDescription;
    private List<Narrative> narratives;
    private List<ProposalAbstract> proposalAbstracts;
    private List<Narrative> instituteAttachments;
    private List<ProposalPersonBiography> propPersonBios;
    private List<ProposalPerson> investigators;
    private Collection<InvestigatorCreditType> investigatorCreditTypes;
    private Unit ownedByUnit;
    private transient NarrativeService narrativeService;
    private transient ProposalPersonBiographyService proposalPersonBiographyService;
    private ActivityType activityType;
    private List<ProposalYnq> proposalYnqs;
    private List<YnqGroupName> ynqGroupNames;
    private String creationStatusCode;
    private Map<String, String> nihDescription;
    private boolean sponsorNihMultiplePi;
    private boolean sponsorNihOsc;
    private List<ProposalChangedData> proposalChangedDataList;
    private List<BudgetChangedData> budgetChangedDataList;
    private Map<String, List<ProposalChangedData>> proposalChangeHistory;
    private Map<String, List<BudgetChangedData>> budgetChangeHistory;
    private Boolean submitFlag = Boolean.FALSE;
    private Boolean grantsGovSelectFlag = Boolean.FALSE;
    private ProposalDevelopmentDocument proposalDocument;
    private String hierarchyStatus;
    private String hierarchyStatusName;
    private String hierarchyOriginatingChildProposalNumber;
    private String hierarchyParentProposalNumber;
    private Integer hierarchyLastSyncHashCode;
    private String hierarchyBudgetType;
    private String lastSyncedBudgetDocumentNumber;
    private transient ParameterService parameterService;
    private transient ProposalHierarchyService proposalHierarchyService;
    private transient KeyPersonnelService keyPersonnelService;
    private Sponsor primeSponsor;
    private String proposalNumberForGG;
    private String opportunityIdForGG;

    public String getProposalNumberForGG() {
        if (this.s2sOpportunity != null) {
            this.proposalNumberForGG = this.s2sOpportunity.getProposalNumber();
        }
        return this.proposalNumberForGG;
    }

    public String getOpportunityIdForGG() {
        if (this.s2sOpportunity != null) {
            this.opportunityIdForGG = this.s2sOpportunity.getOpportunityId();
        }
        return this.opportunityIdForGG;
    }

    public void setProposalNumberForGG(String proposalNumberForGG) {
        this.proposalNumberForGG = proposalNumberForGG;
    }

    public void setOpportunityIdForGG(String opportunityIdForGG) {
        this.opportunityIdForGG = opportunityIdForGG;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KraServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        if (this.keyPersonnelService == null) {
            this.keyPersonnelService = KraServiceLocator.getService(KeyPersonnelService.class);
        }
        return this.keyPersonnelService;
    }

    @Override
    public String getHierarchyStatus() {
        return this.hierarchyStatus;
    }

    public void setHierarchyStatus(String hierarchyStatus) {
        this.hierarchyStatus = hierarchyStatus;
    }

    public String getHierarchyParentProposalNumber() {
        return this.hierarchyParentProposalNumber;
    }

    public void setHierarchyParentProposalNumber(String hierarchyParentProposalNumber) {
        this.hierarchyParentProposalNumber = hierarchyParentProposalNumber;
    }

    public String getHierarchyOriginatingChildProposalNumber() {
        return this.hierarchyOriginatingChildProposalNumber;
    }

    public void setHierarchyOriginatingChildProposalNumber(String hierarchyOriginatingChildProposalNumber) {
        this.hierarchyOriginatingChildProposalNumber = hierarchyOriginatingChildProposalNumber;
    }

    public void setHierarchyLastSyncHashCode(Integer hierarchyLastSyncHashCode) {
        this.hierarchyLastSyncHashCode = hierarchyLastSyncHashCode;
    }

    public Integer getHierarchyLastSyncHashCode() {
        return this.hierarchyLastSyncHashCode;
    }

    public boolean isParent() {
        return HierarchyStatusConstants.Parent.code().equals(this.hierarchyStatus);
    }

    public boolean isChild() {
        return HierarchyStatusConstants.Child.code().equals(this.hierarchyStatus);
    }

    public boolean isInHierarchy() {
        return !HierarchyStatusConstants.None.code().equals(this.hierarchyStatus);
    }

    public String getHierarchyStatusName() {
        this.hierarchyStatusName = HierarchyStatusConstants.None.description();
        for (HierarchyStatusConstants status : HierarchyStatusConstants.values()) {
            if (!status.code().equals(this.getHierarchyStatus())) continue;
            this.hierarchyStatusName = status.description();
        }
        return this.hierarchyStatusName;
    }

    public void setHierarchyStatusName(String hierarchyStatusName) {
        this.hierarchyStatusName = hierarchyStatusName;
    }

    public void setHierarchyBudgetType(String hierarchyBudgetType) {
        this.hierarchyBudgetType = hierarchyBudgetType;
    }

    public String getHierarchyBudgetType() {
        return this.hierarchyBudgetType;
    }

    public DevelopmentProposal() {
        this.setProposalStateTypeCode("1");
        this.propScienceKeywords = new AutoPopulatingList(PropScienceKeyword.class);
        this.newDescription = this.getDefaultNewDescription();
        this.propSpecialReviews = new AutoPopulatingList(ProposalSpecialReview.class);
        this.proposalPersons = new ArrayList<ProposalPerson>();
        this.nextProposalPersonNumber = 1;
        this.narratives = new ArrayList<Narrative>();
        this.proposalAbstracts = new ArrayList<ProposalAbstract>();
        this.instituteAttachments = new ArrayList<Narrative>();
        this.propPersonBios = new ArrayList<ProposalPersonBiography>();
        this.proposalYnqs = new ArrayList<ProposalYnq>();
        this.ynqGroupNames = new ArrayList<YnqGroupName>();
        this.investigators = new ArrayList<ProposalPerson>();
        this.s2sOppForms = new ArrayList<S2sOppForms>();
        this.s2sAppSubmission = new ArrayList<S2sAppSubmission>();
        this.proposalChangedDataList = new AutoPopulatingList(ProposalChangedData.class);
        this.proposalChangeHistory = new TreeMap<String, List<ProposalChangedData>>();
        this.budgetChangedDataList = new AutoPopulatingList(BudgetChangedData.class);
        this.budgetChangeHistory = new TreeMap<String, List<BudgetChangedData>>();
        this.hierarchyStatus = HierarchyStatusConstants.None.code();
        this.hierarchyStatusName = HierarchyStatusConstants.None.description();
        this.initProposalSites();
    }

    private void initProposalSites() {
        this.proposalSites = new ArrayList<ProposalSite>();
        this.setApplicantOrganization(new ProposalSite());
        this.setPerformingOrganization(new ProposalSite());
    }

    public void initializeOwnedByUnitNumber() {
        ProposalDevelopmentService proposalDevelopmentService = KraServiceLocator.getService(ProposalDevelopmentService.class);
        List<Unit> userUnits = proposalDevelopmentService.getDefaultModifyProposalUnitsForUser(GlobalVariables.getUserSession().getPrincipalId());
        if (userUnits.size() == 1) {
            this.setOwnedByUnitNumber(userUnits.get(0).getUnitNumber());
            proposalDevelopmentService.initializeUnitOrganizationLocation(this.getProposalDocument());
        }
    }

    public List<ProposalPerson> getProposalPersons() {
        this.evaluateMoveOptions();
        return this.proposalPersons;
    }

    private void evaluateMoveOptions() {
        for (int i = 0; i < this.proposalPersons.size(); ++i) {
            ProposalPerson person = this.proposalPersons.get(i);
            person.setMoveUpAllowed(i > 0 && !this.getKeyPersonnelService().isPrincipalInvestigator(person) && !this.getKeyPersonnelService().isPrincipalInvestigator(this.proposalPersons.get(i - 1)) && (!this.isSponsorNihMultiplePi() || !this.proposalPersons.get(i - 1).isMultiplePi()));
            person.setMoveDownAllowed(i < this.proposalPersons.size() - 1 && !this.getKeyPersonnelService().isPrincipalInvestigator(person));
            if (!this.isSponsorNihMultiplePi() || !this.getKeyPersonnelService().isCoInvestigator(person) || !person.isMultiplePi()) continue;
            person.setMoveUpAllowed(i > 0 && person.isMultiplePi() == this.proposalPersons.get(i - 1).isMultiplePi());
            person.setMoveDownAllowed(person.isMoveDownAllowed() && person.isMultiplePi() == this.proposalPersons.get(i + 1).isMultiplePi());
        }
    }

    public void setInvestigators(List<ProposalPerson> investigators) {
        this.investigators = investigators;
    }

    public List<ProposalPerson> getInvestigators() {
        return this.investigators;
    }

    public void setProposalPersons(List<ProposalPerson> argProposalPersons) {
        this.proposalPersons = argProposalPersons;
    }

    @Override
    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public String getOwnedByUnitNumber() {
        return this.ownedByUnitNumber;
    }

    public void setOwnedByUnitNumber(String ownedByUnit) {
        this.ownedByUnitNumber = ownedByUnit;
    }

    public String getOwnedByUnitNumberRestricted() {
        return this.ownedByUnitNumber;
    }

    public void setOwnedByUnitNumberRestricted(String ownedByUnit) {
        this.ownedByUnitNumber = ownedByUnit;
    }

    public String getProposalTypeCode() {
        return this.proposalTypeCode;
    }

    public void setProposalTypeCode(String proposalTypeCode) {
        this.proposalTypeCode = proposalTypeCode;
    }

    public String getContinuedFrom() {
        return this.continuedFrom;
    }

    public void setContinuedFrom(String continuedFrom) {
        this.continuedFrom = continuedFrom;
    }

    @Override
    public Date getRequestedEndDateInitial() {
        return this.requestedEndDateInitial;
    }

    public void setRequestedEndDateInitial(Date requestedEndDateInitial) {
        this.requestedEndDateInitial = requestedEndDateInitial;
    }

    @Override
    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public void setRequestedStartDateInitial(Date requestedStartDateInitial) {
        this.requestedStartDateInitial = requestedStartDateInitial;
    }

    @Override
    public String getSponsorCode() {
        return this.sponsorCode;
    }

    @Override
    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getAgencyDivisionCode() {
        return this.agencyDivisionCode;
    }

    public void setAgencyDivisionCode(String agencyDivisionCode) {
        this.agencyDivisionCode = agencyDivisionCode;
    }

    public String getAgencyProgramCode() {
        return this.agencyProgramCode;
    }

    public void setAgencyProgramCode(String agencyProgramCode) {
        this.agencyProgramCode = agencyProgramCode;
    }

    public String getCfdaNumber() {
        return this.cfdaNumber;
    }

    public void setCfdaNumber(String cfdaNumber) {
        this.cfdaNumber = cfdaNumber;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(String deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineType() {
        return this.deadlineType;
    }

    public void setAnticipatedAwardTypeCode(Integer anticipatedAwardTypeCode) {
        this.anticipatedAwardTypeCode = anticipatedAwardTypeCode;
    }

    public void setAnticipatedAwardType(AwardType anticipatedAwardType) {
        this.anticipatedAwardType = anticipatedAwardType;
    }

    public Integer getAnticipatedAwardTypeCode() {
        return this.anticipatedAwardTypeCode;
    }

    public AwardType getAnticipatedAwardType() {
        return this.anticipatedAwardType;
    }

    public void setDeadlineType(String deadlineType) {
        this.deadlineType = deadlineType;
    }

    public String getNoticeOfOpportunityCode() {
        return this.noticeOfOpportunityCode;
    }

    public void setNoticeOfOpportunityCode(String noticeOfOpportunityCode) {
        this.noticeOfOpportunityCode = noticeOfOpportunityCode;
    }

    public String getNsfCode() {
        return this.nsfCode;
    }

    public void setNsfCode(String nsfCode) {
        this.nsfCode = nsfCode;
    }

    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getProgramAnnouncementNumber() {
        return this.programAnnouncementNumber;
    }

    public void setProgramAnnouncementNumber(String programAnnouncementNumber) {
        this.programAnnouncementNumber = programAnnouncementNumber;
    }

    public String getProgramAnnouncementTitle() {
        return this.programAnnouncementTitle;
    }

    public void setProgramAnnouncementTitle(String programAnnouncementTitle) {
        this.programAnnouncementTitle = programAnnouncementTitle;
    }

    public String getSponsorProposalNumber() {
        return this.sponsorProposalNumber;
    }

    public void setSponsorProposalNumber(String sponsorProposalNumber) {
        this.sponsorProposalNumber = sponsorProposalNumber;
    }

    public Boolean getSubcontracts() {
        return this.subcontracts;
    }

    public void setSubcontracts(Boolean subcontracts) {
        this.subcontracts = subcontracts;
    }

    public String getMailBy() {
        return this.mailBy;
    }

    public void setMailBy(String mailBy) {
        this.mailBy = mailBy;
    }

    public String getMailType() {
        return this.mailType;
    }

    public void setMailType(String mailType) {
        this.mailType = mailType;
    }

    public String getMailAccountNumber() {
        return this.mailAccountNumber;
    }

    public void setMailAccountNumber(String mailAccountNumber) {
        this.mailAccountNumber = mailAccountNumber;
    }

    public String getMailDescription() {
        return this.mailDescription;
    }

    public void setMailDescription(String mailDescription) {
        this.mailDescription = mailDescription;
    }

    public Integer getMailingAddressId() {
        return this.mailingAddressId;
    }

    public void setMailingAddressId(Integer mailingAddressId) {
        this.mailingAddressId = mailingAddressId;
        this.refreshRolodex();
    }

    public String getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(String numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }

    public void setApplicantOrganizationId(String applicantOrganizationId) {
        ProposalSite applicantOrganization = this.getApplicantOrganization();
        applicantOrganization.setOrganizationId(applicantOrganizationId);
        this.setApplicantOrganization(applicantOrganization);
    }

    public void setPerformingOrganizationId(String performingOrganizationId) {
        ProposalSite performingOrganization = this.getPerformingOrganization();
        performingOrganization.setOrganizationId(performingOrganizationId);
        this.setPerformingOrganization(performingOrganization);
    }

    public void setApplicantOrganization(ProposalSite applicantOrganization) {
        this.setProposalSiteForType(applicantOrganization, 1);
    }

    public void setApplicantOrgFromOrganization(Organization organization) {
        if (organization == null) {
            this.setApplicantOrganization(null);
        } else {
            ProposalSite applicantSite = new ProposalSite();
            applicantSite.setOrganization(organization);
            this.setApplicantOrganization(applicantSite);
        }
    }

    public ProposalSite getApplicantOrganization() {
        ProposalSite applicant = this.getProposalSiteForType(1);
        if (applicant != null) {
            applicant.setRolodex(applicant.getOrganization() == null ? null : applicant.getOrganization().getRolodex());
        }
        return applicant;
    }

    public void setPerformingOrganization(ProposalSite performingOrganization) {
        this.setProposalSiteForType(performingOrganization, 2);
    }

    public void setPerformingOrgFromOrganization(Organization organization) {
        if (organization == null) {
            this.setPerformingOrganization(null);
        } else {
            ProposalSite performingSite = new ProposalSite();
            performingSite.setOrganization(organization);
            this.setPerformingOrganization(performingSite);
        }
    }

    public ProposalSite getPerformingOrganization() {
        ProposalSite performingOrganization = this.getProposalSiteForType(2);
        performingOrganization.refreshReferenceObject("rolodex");
        if (performingOrganization.getRolodex() == null && performingOrganization.getOrganization() != null) {
            performingOrganization.setRolodex(performingOrganization.getOrganization().getRolodex());
        }
        return performingOrganization;
    }

    public void addProposalSite(ProposalSite proposalSite) {
        this.proposalSites.add(proposalSite);
    }

    private void setProposalSiteForType(ProposalSite proposalSite, int locationType) {
        this.deleteAllProposalSitesOfType(locationType);
        proposalSite.setLocationTypeCode(locationType);
        this.addProposalSite(proposalSite);
    }

    private void setProposalSitesForType(List<ProposalSite> proposalSites, int locationType) {
        this.deleteAllProposalSitesOfType(locationType);
        for (ProposalSite proposalSite : proposalSites) {
            proposalSite.setLocationTypeCode(locationType);
        }
        proposalSites.addAll(proposalSites);
    }

    private void deleteAllProposalSitesOfType(int locationType) {
        for (int i = this.proposalSites.size() - 1; i >= 0; --i) {
            ProposalSite proposalSite = this.proposalSites.get(i);
            if (proposalSite.getLocationTypeCode() != locationType) continue;
            this.proposalSites.remove(i);
        }
    }

    private ProposalSite getProposalSiteForType(int locationType) {
        List<ProposalSite> matchingSites = this.getProposalSitesForType(locationType);
        if (matchingSites.isEmpty()) {
            return null;
        }
        return matchingSites.get(0);
    }

    private List<ProposalSite> getProposalSitesForType(int locationType) {
        ArrayList<ProposalSite> matchingSites = new ArrayList<ProposalSite>();
        for (ProposalSite proposalSite : this.proposalSites) {
            if (proposalSite.getLocationTypeCode() != locationType) continue;
            matchingSites.add(proposalSite);
        }
        return matchingSites;
    }

    public void setPerformanceSites(List<ProposalSite> performanceSites) {
        this.setProposalSitesForType(performanceSites, 4);
    }

    public List<ProposalSite> getPerformanceSites() {
        return this.getProposalSitesForType(4);
    }

    public void addPerformanceSite(ProposalSite performanceSite) {
        performanceSite.setLocationTypeCode(4);
        this.addProposalSite(performanceSite);
    }

    public void removePerformanceSite(int index) {
        this.removeProposalSiteOfType(4, index);
    }

    public void clearPerformanceSiteAddress(int index) {
        ProposalSite performanceSite = this.getPerformanceSites().get(index);
        performanceSite.setOrganization(new Organization());
        performanceSite.setOrganizationId("");
        performanceSite.setRolodex(new Rolodex());
        performanceSite.setRolodexId(null);
    }

    public void setOtherOrganizations(List<ProposalSite> otherOrganizations) {
        this.setProposalSitesForType(otherOrganizations, 3);
    }

    public List<ProposalSite> getOtherOrganizations() {
        return this.getProposalSitesForType(3);
    }

    public void addOtherOrganization(ProposalSite otherOrganization) {
        otherOrganization.setLocationTypeCode(3);
        this.addProposalSite(otherOrganization);
    }

    public void removeOtherOrganization(int index) {
        this.removeProposalSiteOfType(3, index);
    }

    private void removeProposalSiteOfType(int locationType, int index) {
        for (ProposalSite proposalSite : this.getProposalSitesForType(locationType)) {
            if (proposalSite.getLocationTypeCode() != locationType || --index >= 0) continue;
            this.proposalSites.remove((Object)proposalSite);
            break;
        }
    }

    public void setProposalSites(List<ProposalSite> proposalSites) {
        this.proposalSites = proposalSites;
    }

    public List<ProposalSite> getProposalSites() {
        return this.proposalSites;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public void setPropScienceKeywords(List<PropScienceKeyword> propScienceKeywords) {
        this.propScienceKeywords = propScienceKeywords;
    }

    public List<PropScienceKeyword> getPropScienceKeywords() {
        return this.propScienceKeywords;
    }

    public void addPropScienceKeyword(PropScienceKeyword propScienceKeyword) {
        this.getPropScienceKeywords().add(propScienceKeyword);
    }

    public String getNewScienceKeywordCode() {
        return this.newScienceKeywordCode;
    }

    public void setNewScienceKeywordCode(String newScienceKeywordCode) {
        this.newScienceKeywordCode = newScienceKeywordCode;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public String getDefaultNewDescription() {
        return "(select)";
    }

    public List<ProposalSpecialReview> getPropSpecialReviews() {
        return this.propSpecialReviews;
    }

    public void setPropSpecialReviews(List<ProposalSpecialReview> propSpecialReviews) {
        this.propSpecialReviews = propSpecialReviews;
    }

    protected void refreshRolodex() {
        NonOrganizationalRolodex rolodex = this.mailingAddressId != null ? (NonOrganizationalRolodex)this.getBusinessObjectService().findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, this.mailingAddressId)) : null;
        this.setRolodex(rolodex);
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ArrayList<ProposalPersonUnit> units = new ArrayList<ProposalPersonUnit>();
        ArrayList<ProposalPersonDegree> degrees = new ArrayList<ProposalPersonDegree>();
        for (ProposalPerson person : this.getProposalPersons()) {
            units.addAll(person.getUnits());
            degrees.addAll(person.getProposalPersonDegrees());
        }
        managedLists.add(units);
        managedLists.add(degrees);
        managedLists.add(this.getProposalSites());
        ArrayList<CongressionalDistrict> congressionalDistricts = new ArrayList<CongressionalDistrict>();
        for (ProposalSite proposalSite : this.getProposalSites()) {
            congressionalDistricts.addAll(proposalSite.getCongressionalDistricts());
        }
        managedLists.add(congressionalDistricts);
        ArrayList specialReviewExemptions = new ArrayList();
        for (ProposalSpecialReview specialReview : this.getPropSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(this.getPropSpecialReviews());
        managedLists.add(this.getProposalPersons());
        managedLists.add(this.getPropScienceKeywords());
        managedLists.add(this.getProposalAbstracts());
        managedLists.add(this.getPropPersonBios());
        managedLists.add(this.getS2sAppSubmission());
        ArrayList<S2sOpportunity> opportunities = new ArrayList<S2sOpportunity>();
        S2sOpportunity opportunity = this.getS2sOpportunity();
        if (opportunity != null) {
            opportunities.add(opportunity);
            this.s2sOppForms = opportunity.getS2sOppForms();
        }
        if (this.s2sOppForms != null && this.s2sOppForms.size() > 0) {
            managedLists.add(this.s2sOppForms);
        } else {
            managedLists.add(new ArrayList());
        }
        managedLists.add(opportunities);
        return managedLists;
    }

    public Sponsor getSponsor() {
        if (!StringUtils.isEmpty((String)this.sponsorCode)) {
            this.refreshReferenceObject("sponsor");
        }
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public String getSponsorName() {
        if (this.getSponsor() != null) {
            return this.getSponsor().getSponsorName();
        }
        return null;
    }

    public String getOwnedByUnitName() {
        Unit unit = this.getOwnedByUnit();
        return unit != null ? unit.getUnitName() : null;
    }

    public ProposalPerson getPrincipalInvestigator() {
        ProposalPerson principalInvestigator = null;
        for (ProposalPerson person : this.proposalPersons) {
            if (!StringUtils.equals((String)person.getProposalPersonRoleId(), (String)"PI")) continue;
            principalInvestigator = person;
            break;
        }
        return principalInvestigator;
    }

    public String getPrincipalInvestigatorName() {
        ProposalPerson pi = this.getPrincipalInvestigator();
        return pi != null ? pi.getFullName() : null;
    }

    public void setNextProposalPersonNumber(Integer n) {
        this.nextProposalPersonNumber = n;
    }

    public Integer getNextProposalPersonNumber() {
        return this.nextProposalPersonNumber;
    }

    public void addProposalPerson(ProposalPerson p) {
        p.setProposalPersonNumber(this.getProposalDocument().getDocumentNextValue("proposalDevelopment.proposalPerson.proposalPersonNumber"));
        if (p.getProposalPersonExtendedAttributes() != null && p.getProposalPersonExtendedAttributes().getProposalPersonNumber() == null) {
            p.getProposalPersonExtendedAttributes().setProposalPersonNumber(p.getProposalPersonNumber());
        }
        p.setDevelopmentProposal(this);
        this.getProposalPersons().add(p);
    }

    public ProposalPerson getProposalPerson(int index) {
        while (this.getProposalPersons().size() <= index) {
            this.getProposalPersons().add(new ProposalPerson());
        }
        return this.getProposalPersons().get(index);
    }

    public List<Narrative> getNarratives() {
        return this.narratives;
    }

    public void setNarratives(List<Narrative> narratives) {
        this.narratives = narratives;
    }

    public List<ProposalAbstract> getProposalAbstracts() {
        return this.proposalAbstracts;
    }

    public void setProposalAbstracts(List<ProposalAbstract> proposalAbstracts) {
        this.proposalAbstracts = proposalAbstracts;
    }

    public List<Narrative> getInstituteAttachments() {
        return this.instituteAttachments;
    }

    public void setInstituteAttachments(List<Narrative> instituteAttachments) {
        this.instituteAttachments = instituteAttachments;
    }

    public List<ProposalPersonBiography> getPropPersonBios() {
        return this.propPersonBios;
    }

    public void setPropPersonBios(List<ProposalPersonBiography> propPersonBios) {
        this.propPersonBios = propPersonBios;
    }

    public Unit getOwnedByUnit() {
        return this.ownedByUnit;
    }

    public void setOwnedByUnit(Unit ownedByUnit) {
        this.ownedByUnit = ownedByUnit;
    }

    public void addProposalPersonBiography(ProposalPersonBiography proposalPersonBiography) {
        this.getProposalPersonBiographyService().addProposalPersonBiography(this.getProposalDocument(), proposalPersonBiography);
    }

    public void removePersonnelAttachmentForDeletedPerson(ProposalPerson proposalPerson) throws Exception {
        this.getProposalPersonBiographyService().removePersonnelAttachmentForDeletedPerson(this.getProposalDocument(), proposalPerson);
    }

    public void deleteProposalPersonBiography(int lineToDelete) {
        this.getProposalPersonBiographyService().deleteProposalPersonBiography(this.getProposalDocument(), lineToDelete);
    }

    public void addNarrative(Narrative narrative) {
        this.getNarrativeService().addNarrative(this.getProposalDocument(), narrative);
    }

    public void deleteProposalAttachment(int lineToDelete) {
        this.getNarrativeService().deleteProposalAttachment(this.getProposalDocument(), lineToDelete);
    }

    public void addInstituteAttachment(Narrative narrative) {
        this.getNarrativeService().addInstituteAttachment(this.getProposalDocument(), narrative);
    }

    public void deleteInstitutionalAttachment(int lineToDelete) {
        this.getNarrativeService().deleteInstitutionalAttachment(this.getProposalDocument(), lineToDelete);
    }

    public void populatePersonNameForNarrativeUserRights(int lineNumber) {
        if (!this.getNarratives().isEmpty()) {
            Narrative narrative = this.getNarratives().get(lineNumber);
            this.getNarrativeService().populatePersonNameForNarrativeUserRights(this.getProposalDocument(), narrative);
        }
    }

    public void populatePersonNameForInstituteAttachmentUserRights(int lineNumber) {
        if (!this.getInstituteAttachments().isEmpty()) {
            Narrative narrative = this.getInstituteAttachments().get(lineNumber);
            this.getNarrativeService().populatePersonNameForNarrativeUserRights(this.getProposalDocument(), narrative);
        }
    }

    public void replaceAttachment(int selectedLine) {
        Narrative narrative = this.getNarratives().get(selectedLine);
        this.getNarrativeService().replaceAttachment(narrative);
    }

    public void replaceInstituteAttachment(int selectedLine) {
        Narrative narrative = this.getInstituteAttachments().get(selectedLine);
        this.getNarrativeService().replaceAttachment(narrative);
    }

    public void populateNarrativeRightsForLoggedinUser() {
        this.getNarrativeService().populateNarrativeRightsForLoggedinUser(this.getProposalDocument());
    }

    public NarrativeService getNarrativeService() {
        if (this.narrativeService == null) {
            this.narrativeService = KraServiceLocator.getService(NarrativeService.class);
        }
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public ProposalPersonBiographyService getProposalPersonBiographyService() {
        if (this.proposalPersonBiographyService == null) {
            this.proposalPersonBiographyService = KraServiceLocator.getService(ProposalPersonBiographyService.class);
        }
        return this.proposalPersonBiographyService;
    }

    public void setProposalPersonBiographyService(ProposalPersonBiographyService proposalPersonBiographyService) {
        this.proposalPersonBiographyService = proposalPersonBiographyService;
    }

    public void setInvestigatorCreditTypes(Collection<InvestigatorCreditType> creditTypes) {
        this.investigatorCreditTypes = creditTypes;
    }

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        return this.investigatorCreditTypes;
    }

    public List<ProposalYnq> getProposalYnqs() {
        Collections.sort(this.proposalYnqs);
        return this.proposalYnqs;
    }

    public void setProposalYnqs(List<ProposalYnq> proposalYnqs) {
        this.proposalYnqs = proposalYnqs;
    }

    public List<YnqGroupName> getYnqGroupNames() {
        if (this.ynqGroupNames.isEmpty()) {
            this.getYnqService().populateProposalQuestions(this.proposalYnqs, this.ynqGroupNames, this.getProposalDocument());
        }
        Collections.sort(this.ynqGroupNames);
        return this.ynqGroupNames;
    }

    public void setYnqGroupNames(List<YnqGroupName> ynqGroupNames) {
        this.ynqGroupNames = ynqGroupNames;
    }

    public ProposalSpecialReview getPropSpecialReview(int index) {
        while (this.getPropSpecialReviews().size() <= index) {
            this.getPropSpecialReviews().add(new ProposalSpecialReview());
        }
        return this.getPropSpecialReviews().get(index);
    }

    public PropScienceKeyword getPropScienceKeyword(int index) {
        while (this.getPropScienceKeywords().size() <= index) {
            this.getPropScienceKeywords().add(new PropScienceKeyword());
        }
        return this.getPropScienceKeywords().get(index);
    }

    public Narrative getNarrative(int index) {
        while (this.getNarratives().size() <= index) {
            this.getNarratives().add(new Narrative());
        }
        return this.getNarratives().get(index);
    }

    public Narrative getInstituteAttachment(int index) {
        while (this.getInstituteAttachments().size() <= index) {
            this.getInstituteAttachments().add(new Narrative());
        }
        return this.getInstituteAttachments().get(index);
    }

    public ProposalAbstract getProposalAbstract(int index) {
        while (this.getProposalAbstracts().size() <= index) {
            this.getProposalAbstracts().add(new ProposalAbstract());
        }
        return this.getProposalAbstracts().get(index);
    }

    public ProposalPersonBiography getPropPersonBio(int index) {
        while (this.getPropPersonBios().size() <= index) {
            this.getPropPersonBios().add(new ProposalPersonBiography());
        }
        return this.getPropPersonBios().get(index);
    }

    public ProposalPerson getInvestigator(int index) {
        while (this.getInvestigators().size() <= index) {
            this.getInvestigators().add(new ProposalPerson());
        }
        return this.getInvestigators().get(index);
    }

    public ProposalYnq getProposalYnq(int index) {
        while (this.getProposalYnqs().size() <= index) {
            this.getProposalYnqs().add(new ProposalYnq());
        }
        return this.getProposalYnqs().get(index);
    }

    public YnqGroupName getYnqGroupName(int index) {
        while (this.getYnqGroupNames().size() <= index) {
            this.getYnqGroupNames().add(new YnqGroupName());
        }
        return this.getYnqGroupNames().get(index);
    }

    public YnqService getYnqService() {
        return KraServiceLocator.getService(YnqService.class);
    }

    @Override
    public String getBudgetStatus() {
        return this.budgetStatus;
    }

    @Override
    public void setBudgetStatus(String budgetStatus) {
        this.budgetStatus = budgetStatus;
    }

    public void setBudgetStatusDescription(String budgetStatusDescription) {
        this.budgetStatusDescription = budgetStatusDescription;
    }

    public String getBudgetStatusDescription() {
        if (StringUtils.isEmpty((String)this.budgetStatusDescription)) {
            KraServiceLocator.getService(ProposalStatusService.class).loadBudgetStatus(this);
        }
        return this.budgetStatusDescription;
    }

    public List<S2sOppForms> getS2sOppForms() {
        return this.s2sOppForms;
    }

    public List<S2sOppForms> getSelectedS2sOppForms() {
        ArrayList<S2sOppForms> aList = new ArrayList<S2sOppForms>();
        for (S2sOppForms oppForm : this.s2sOppForms) {
            if (!Boolean.TRUE.equals(oppForm.getSelectToPrint())) continue;
            aList.add(oppForm);
        }
        return aList;
    }

    public void setS2sOppForms(List<S2sOppForms> oppForms) {
        this.s2sOppForms = oppForms;
    }

    public void setS2sOpportunity(S2sOpportunity s2sOpportunity) {
        this.s2sOpportunity = s2sOpportunity;
    }

    public S2sOpportunity getS2sOpportunity() {
        return this.s2sOpportunity;
    }

    @Override
    public ProposalPerson getProposalEmployee(String personId) {
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson;
        }
        return null;
    }

    @Override
    public ProposalPerson getProposalNonEmployee(Integer rolodexId) {
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson;
        }
        return null;
    }

    @Override
    public ContactRole getProposalEmployeeRole(String personId) {
        ProposalPerson principalInvestigator = this.getPrincipalInvestigator();
        if (principalInvestigator != null && personId.equals(principalInvestigator.getPersonId())) {
            return principalInvestigator.getRole();
        }
        for (ProposalPerson proposalPerson : this.getInvestigators()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson.getRole();
        }
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!personId.equals(proposalPerson.getPersonId())) continue;
            return proposalPerson.getRole();
        }
        return null;
    }

    @Override
    public ContactRole getProposalNonEmployeeRole(Integer rolodexId) {
        ProposalPerson principalInvestigator = this.getPrincipalInvestigator();
        if (principalInvestigator != null && rolodexId.equals(principalInvestigator.getRolodexId())) {
            return principalInvestigator.getRole();
        }
        for (ProposalPerson proposalPerson : this.getInvestigators()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson.getRole();
        }
        for (ProposalPerson proposalPerson : this.getProposalPersons()) {
            if (!rolodexId.equals(proposalPerson.getRolodexId())) continue;
            return proposalPerson.getRole();
        }
        return null;
    }

    public String getCreationStatusCode() {
        return this.creationStatusCode;
    }

    public void setCreationStatusCode(String creationStatusCode) {
        this.creationStatusCode = creationStatusCode;
    }

    @Override
    public final ActivityType getActivityType() {
        return this.activityType;
    }

    public final void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public boolean isProposalComplete() {
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        return this.getBudgetStatus() != null && budgetStatusCompleteCode != null && this.getBudgetStatus().equals(budgetStatusCompleteCode);
    }

    public boolean isParentProposalComplete() {
        boolean retval = false;
        if (this.isChild()) {
            try {
                DevelopmentProposal parent = this.getProposalHierarchyService().lookupParent(this);
                KraServiceLocator.getService(ProposalStatusService.class).loadBudgetStatus(parent);
                retval = parent.isProposalComplete();
            }
            catch (ProposalHierarchyException x) {
                throw new IllegalStateException(x);
            }
        }
        return retval;
    }

    public Map<String, String> getNihDescription() {
        return this.nihDescription;
    }

    public void setNihDescription(Map<String, String> nihDescription) {
        this.nihDescription = nihDescription;
    }

    @Override
    public boolean isSponsorNihMultiplePi() {
        return this.sponsorNihMultiplePi;
    }

    public void setSponsorNihMultiplePi(boolean sponsorNihMultiplePi) {
        this.sponsorNihMultiplePi = sponsorNihMultiplePi;
    }

    public boolean isSponsorNihOsc() {
        return this.sponsorNihOsc;
    }

    public void setSponsorNihOsc(boolean sponsorNihOsc) {
        this.sponsorNihOsc = sponsorNihOsc;
    }

    public List<S2sAppSubmission> getS2sAppSubmission() {
        return this.s2sAppSubmission;
    }

    public void setS2sAppSubmission(List<S2sAppSubmission> appSubmission) {
        this.s2sAppSubmission = appSubmission;
    }

    public List<ProposalChangedData> getProposalChangedDataList() {
        return this.proposalChangedDataList;
    }

    public void setProposalChangedDataList(List<ProposalChangedData> proposalChangedDataList) {
        this.proposalChangedDataList = proposalChangedDataList;
    }

    public Map<String, List<ProposalChangedData>> getProposalChangeHistory() {
        return this.proposalChangeHistory;
    }

    public void setProposalChangeHistory(Map<String, List<ProposalChangedData>> proposalChangeHistory) {
        this.proposalChangeHistory = proposalChangeHistory;
    }

    public void setSubmitFlag(Boolean submitFlag) {
        this.submitFlag = submitFlag;
    }

    public Boolean getSubmitFlag() {
        return this.submitFlag;
    }

    public Boolean getGrantsGovSelectFlag() {
        return this.grantsGovSelectFlag;
    }

    public void setGrantsGovSelectFlag(Boolean grantsGovSelectFlag) {
        this.grantsGovSelectFlag = grantsGovSelectFlag;
    }

    public String getProposalStateTypeCode() {
        return this.proposalStateTypeCode;
    }

    public void setProposalStateTypeCode(String proposalStateTypeCode) {
        this.proposalStateTypeCode = proposalStateTypeCode;
        if (proposalStateTypeCode == null) {
            this.proposalState = null;
        } else {
            try {
                this.refreshReferenceObject("proposalState");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public ProposalState getProposalState() {
        return this.proposalState;
    }

    public ProposalDevelopmentDocument getProposalDocument() {
        if (this.proposalDocument == null) {
            this.proposalDocument = new ProposalDevelopmentDocument();
        }
        return this.proposalDocument;
    }

    public void setProposalDocument(ProposalDevelopmentDocument proposalDocument) {
        this.proposalDocument = proposalDocument;
    }

    public void updateProposalChangeHistory() {
        this.proposalChangeHistory = new TreeMap<String, List<ProposalChangedData>>();
        if (CollectionUtils.isNotEmpty(this.getProposalChangedDataList())) {
            for (ProposalChangedData proposalChangedData : this.getProposalChangedDataList()) {
                if (this.getProposalChangeHistory().get(proposalChangedData.getEditableColumn().getColumnLabel()) == null) {
                    this.getProposalChangeHistory().put(proposalChangedData.getEditableColumn().getColumnLabel(), new ArrayList());
                }
                this.getProposalChangeHistory().get(proposalChangedData.getEditableColumn().getColumnLabel()).add(proposalChangedData);
            }
        }
    }

    public void updateS2sOpportunity() {
        if (this.s2sOpportunity != null && this.s2sOpportunity.getOpportunityId() == null) {
            this.s2sOpportunity = null;
        }
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public ProposalType getProposalType() {
        return this.proposalType;
    }

    @Override
    public List<PersonRolodex> getPersonRolodexList() {
        ArrayList<PersonRolodex> filtered = new ArrayList<PersonRolodex>();
        for (ProposalPerson person : this.getProposalPersons()) {
            if (!filtered.contains(person)) {
                filtered.add(person);
                continue;
            }
            if (!person.isInvestigator()) continue;
            filtered.remove(person);
            filtered.add(person);
        }
        return filtered;
    }

    @Override
    public Unit getUnit() {
        return this.getOwnedByUnit();
    }

    @Override
    public String getUnitNumber() {
        return this.getOwnedByUnitNumber();
    }

    public void updateProposalNumbers() {
        String proposalNumber = this.getProposalNumber();
        for (ProposalSite site : this.getProposalSites()) {
            site.setProposalNumber(proposalNumber);
        }
        if (this.s2sOpportunity != null) {
            this.s2sOpportunity.setProposalNumber(proposalNumber);
            this.proposalNumberForGG = proposalNumber;
        }
    }

    @Override
    public String getDefaultBudgetStatusParameter() {
        return "budgetStatusIncompleteCode";
    }

    @Override
    public boolean isParentInHierarchyComplete() {
        return this.isParentProposalComplete();
    }

    public NoticeOfOpportunity getNoticeOfOpportunity() {
        return this.noticeOfOpportunity;
    }

    public void setNoticeOfOpportunity(NoticeOfOpportunity noticeOfOpportunity) {
        this.noticeOfOpportunity = noticeOfOpportunity;
    }

    public NsfCode getNsfCodeBo() {
        return this.nsfCodeBo;
    }

    public void setNsfCodeBo(NsfCode nsfCodeBo) {
        this.nsfCodeBo = nsfCodeBo;
    }

    public String getAttachmentsStatus() {
        String statusString = ATTACHMENTS_COMPLETE;
        if (!this.getNarratives().isEmpty()) {
            for (Narrative aNarrative : this.getNarratives()) {
                if (!aNarrative.getNarrativeStatus().getDescription().equals(ATTACHMENTS_INCOMPLETE)) continue;
                statusString = ATTACHMENTS_INCOMPLETE;
            }
        } else {
            statusString = ATTACHMENTS_NONE;
        }
        return statusString;
    }

    public void cleanupSpecialReviews(DevelopmentProposal srcProposal) {
        List<ProposalSpecialReview> srcSpecialReviews = srcProposal.getPropSpecialReviews();
        List<ProposalSpecialReview> dstSpecialReviews = this.getPropSpecialReviews();
        for (int i = 0; i < srcSpecialReviews.size(); ++i) {
            ProposalSpecialReview srcSpecialReview = srcSpecialReviews.get(i);
            ProposalSpecialReview dstSpecialReview = dstSpecialReviews.get(i);
            if (srcSpecialReview.getExemptionTypeCodes() != null) {
                ArrayList<String> exemptionCodeCopy = new ArrayList<String>();
                for (String s : srcSpecialReview.getExemptionTypeCodes()) {
                    exemptionCodeCopy.add(new String(s));
                }
                dstSpecialReview.setExemptionTypeCodes(exemptionCodeCopy);
            }
            dstSpecialReview.resetPersistenceState();
        }
    }

    public Sponsor getPrimeSponsor() {
        if (DevelopmentProposal.outOfSync(this.primeSponsorCode, this.primeSponsor)) {
            this.refreshReferenceObject("primeSponsor");
        }
        return this.primeSponsor;
    }

    private static boolean outOfSync(String code, Sponsor spon) {
        return spon == null && !StringUtils.isEmpty((String)code) || spon != null && !StringUtils.equals((String)spon.getSponsorCode(), (String)code) && !StringUtils.isEmpty((String)code);
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
        this.primeSponsorCode = primeSponsor != null ? primeSponsor.getSponsorCode() : null;
    }

    @Override
    public String getParentNumber() {
        return this.getProposalNumber();
    }

    @Override
    public String getParentPIName() {
        String proposalInvestigatorName = null;
        for (ProposalPerson pPerson : this.getProposalPersons()) {
            if (pPerson.getPersonId() == null || !pPerson.getProposalPersonRoleId().equals("PI")) continue;
            proposalInvestigatorName = pPerson.getFullName();
            break;
        }
        return proposalInvestigatorName;
    }

    @Override
    public String getParentTitle() {
        return this.getTitle();
    }

    @Override
    public String getIsOwnedByUnit() {
        HashMap<String, String> proposalNumberMap = new HashMap<String, String>();
        String proposalNumber = this.getProposalNumber();
        proposalNumberMap.put("proposalNumber", proposalNumber);
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        LookupableDevelopmentProposal lookupDevProposal = (LookupableDevelopmentProposal)businessObjectService.findByPrimaryKey(LookupableDevelopmentProposal.class, proposalNumberMap);
        if (lookupDevProposal != null) {
            return lookupDevProposal.getSponsor().getOwnedByUnit();
        }
        return "";
    }

    @Override
    public Integer getParentInvestigatorFlag(String personId, Integer flag) {
        for (ProposalPerson pPerson : this.getProposalPersons()) {
            if ((pPerson.getPersonId() == null || !pPerson.getPersonId().equals(personId)) && (pPerson.getRolodexId() == null || !pPerson.getRolodexId().equals(personId))) continue;
            flag = 2;
            if (!pPerson.getProposalPersonRoleId().equals("PI")) continue;
            flag = 1;
            break;
        }
        return flag;
    }

    @Override
    public String getParentTypeName() {
        return "Proposal";
    }

    @Override
    public String getProjectName() {
        return this.getTitle();
    }

    @Override
    public String getProjectId() {
        return this.getProposalNumber();
    }

    public void setBudgetChangeHistory(Map<String, List<BudgetChangedData>> budgetChangeHistory) {
        this.budgetChangeHistory = budgetChangeHistory;
    }

    public Map<String, List<BudgetChangedData>> getBudgetChangeHistory() {
        return this.budgetChangeHistory;
    }

    public void updateBudgetChangeHistory() {
        this.budgetChangeHistory = new TreeMap<String, List<BudgetChangedData>>();
        if (CollectionUtils.isNotEmpty(this.getBudgetChangedDataList())) {
            for (BudgetChangedData budgetChangedData : this.getBudgetChangedDataList()) {
                if (this.getBudgetChangeHistory().get(budgetChangedData.getEditableColumn().getColumnLabel()) == null) {
                    this.getBudgetChangeHistory().put(budgetChangedData.getEditableColumn().getColumnLabel(), new ArrayList());
                }
                this.getBudgetChangeHistory().get(budgetChangedData.getEditableColumn().getColumnLabel()).add(budgetChangedData);
            }
        }
    }

    public void setBudgetChangedDataList(List<BudgetChangedData> budgetChangedDataList) {
        this.budgetChangedDataList = budgetChangedDataList;
    }

    public List<BudgetChangedData> getBudgetChangedDataList() {
        return this.budgetChangedDataList;
    }

    @Override
    public KrmsRulesContext getKrmsRulesContext() {
        return this.getProposalDocument();
    }

    public String getLastSyncedBudgetDocumentNumber() {
        return this.lastSyncedBudgetDocumentNumber;
    }

    public void setLastSyncedBudgetDocumentNumber(String lastSyncedBudgetDocumentNumber) {
        this.lastSyncedBudgetDocumentNumber = lastSyncedBudgetDocumentNumber;
    }
}

