/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.bo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.KcAttachment;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.PropPerDocType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiographyAttachment;
import org.kuali.kra.service.KcAttachmentService;

public class ProposalPersonBiography
extends KraPersistableBusinessObjectBase
implements KcAttachment {
    private Integer proposalPersonNumber;
    private String personId;
    private String proposalNumber;
    private Integer biographyNumber;
    private Integer rolodexId;
    private String description;
    private String documentTypeCode;
    private String fileName;
    private String contentType;
    private transient FormFile personnelAttachmentFile;
    private List<ProposalPersonBiographyAttachment> personnelAttachmentList = new ArrayList<ProposalPersonBiographyAttachment>(1);
    private PropPerDocType propPerDocType;
    private Timestamp timestampDisplay;
    private String uploadUserDisplay;
    private String uploadUserFullName;
    private transient int positionNumber;

    public Integer getProposalPersonNumber() {
        return this.proposalPersonNumber;
    }

    public void setProposalPersonNumber(Integer proposalPersonNumber) {
        this.proposalPersonNumber = proposalPersonNumber;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocumentTypeCode() {
        return this.documentTypeCode;
    }

    public void setDocumentTypeCode(String documentTypeCode) {
        this.documentTypeCode = documentTypeCode;
    }

    public FormFile getPersonnelAttachmentFile() {
        return this.personnelAttachmentFile;
    }

    public void setPersonnelAttachmentFile(FormFile personnelAttachmentFile) {
        this.personnelAttachmentFile = personnelAttachmentFile;
    }

    public List<ProposalPersonBiographyAttachment> getPersonnelAttachmentList() {
        return this.personnelAttachmentList;
    }

    public void setPersonnelAttachmentList(List<ProposalPersonBiographyAttachment> personnelAttachmentList) {
        this.personnelAttachmentList = personnelAttachmentList;
    }

    public PropPerDocType getPropPerDocType() {
        return this.propPerDocType;
    }

    public void setPropPerDocType(PropPerDocType propPerDocType) {
        this.propPerDocType = propPerDocType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Integer getBiographyNumber() {
        return this.biographyNumber;
    }

    public void setBiographyNumber(Integer biographyNumber) {
        this.biographyNumber = biographyNumber;
    }

    public Timestamp getTimestampDisplay() {
        return this.timestampDisplay;
    }

    public void setTimestampDisplay(Timestamp timestampDisplay) {
        this.timestampDisplay = timestampDisplay;
    }

    public String getUploadUserDisplay() {
        return this.uploadUserDisplay;
    }

    public void setUploadUserDisplay(String uploadUserDisplay) {
        this.uploadUserDisplay = uploadUserDisplay;
    }

    public String getUploadUserFullName() {
        return this.uploadUserFullName;
    }

    public void setUploadUserFullName(String uploadUserFullName) {
        this.uploadUserFullName = uploadUserFullName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public byte[] getData() {
        if (this.getPersonnelAttachmentList().isEmpty()) {
            return null;
        }
        return this.getPersonnelAttachmentList().get(0).getContent();
    }

    @Override
    public String getName() {
        return this.getFileName();
    }

    @Override
    public String getType() {
        return this.getContentType();
    }

    @Override
    public String getIconPath() {
        return KraServiceLocator.getService(KcAttachmentService.class).getFileTypeIcon(this);
    }

    public int getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(int positionNumber) {
        this.positionNumber = positionNumber;
    }

    public void populateAttachment() {
        FormFile personnelFile = this.getPersonnelAttachmentFile();
        if (personnelFile == null) {
            return;
        }
        try {
            byte[] personnellFileData = personnelFile.getFileData();
            if (personnellFileData.length > 0) {
                ProposalPersonBiographyAttachment personnelAttachment;
                if (this.getPersonnelAttachmentList().isEmpty()) {
                    personnelAttachment = new ProposalPersonBiographyAttachment();
                    this.getPersonnelAttachmentList().add(personnelAttachment);
                } else {
                    personnelAttachment = this.getPersonnelAttachmentList().get(0);
                    if (personnelAttachment == null) {
                        personnelAttachment = new ProposalPersonBiographyAttachment();
                        this.getPersonnelAttachmentList().set(0, personnelAttachment);
                    }
                }
                String fileName = personnelFile.getFileName();
                personnelAttachment.setFileName(fileName);
                personnelAttachment.setContentType(personnelFile.getContentType());
                personnelAttachment.setBiographyData(personnelFile.getFileData());
                personnelAttachment.setProposalNumber(this.getProposalNumber());
                this.setFileName(personnelAttachment.getFileName());
                this.setContentType(personnelAttachment.getContentType());
            } else {
                this.getPersonnelAttachmentList().clear();
            }
        }
        catch (FileNotFoundException e) {
            this.getPersonnelAttachmentList().clear();
        }
        catch (IOException e) {
            this.getPersonnelAttachmentList().clear();
        }
    }
}

