/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.bo;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardAttachment;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardFiles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyMaintainable;

public class BudgetSubAwards
extends BudgetAssociate
implements HierarchyMaintainable,
Comparable<BudgetSubAwards> {
    private static final long serialVersionUID = -857485535655759499L;
    private String proposalNumber;
    private Integer subAwardNumber;
    private Integer budgetVersionNumber;
    private String comments;
    private String organizationId;
    private String organizationName;
    private Organization organization;
    private Integer subAwardStatusCode;
    private byte[] subAwardXfdFileData;
    private String subAwardXfdFileName;
    private String subAwardXmlFileData;
    private String translationComments;
    private Timestamp xfdUpdateTimestamp;
    private String xfdUpdateUser;
    private Timestamp xmlUpdateTimestamp;
    private String xmlUpdateUser;
    private String namespace;
    private String formName;
    private List<BudgetSubAwardAttachment> budgetSubAwardAttachments = new ArrayList<BudgetSubAwardAttachment>();
    private List<BudgetSubAwardFiles> budgetSubAwardFiles = new ArrayList<BudgetSubAwardFiles>();
    private List<BudgetSubAwardPeriodDetail> budgetSubAwardPeriodDetails = new ArrayList<BudgetSubAwardPeriodDetail>();
    private String hierarchyProposalNumber;
    private boolean hiddenInHierarchy;
    private transient boolean edit = false;
    private transient FormFile newSubAwardFile;
    private transient boolean newSubAwardFileError = false;

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }

    public Integer getBudgetVersionNumber() {
        return this.budgetVersionNumber;
    }

    public void setBudgetVersionNumber(Integer budgetVersionNumber) {
        this.budgetVersionNumber = budgetVersionNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getSubAwardStatusCode() {
        return this.subAwardStatusCode;
    }

    public void setSubAwardStatusCode(Integer subAwardStatusCode) {
        this.subAwardStatusCode = subAwardStatusCode;
    }

    public String getSubAwardXfdFileName() {
        return this.subAwardXfdFileName;
    }

    public void setSubAwardXfdFileName(String subAwardXfdFileName) {
        this.subAwardXfdFileName = subAwardXfdFileName;
    }

    public String getTranslationComments() {
        return this.translationComments;
    }

    public void setTranslationComments(String translationComments) {
        this.translationComments = translationComments;
    }

    public Timestamp getXfdUpdateTimestamp() {
        return this.xfdUpdateTimestamp;
    }

    public void setXfdUpdateTimestamp(Timestamp xfdUpdateTimestamp) {
        this.xfdUpdateTimestamp = xfdUpdateTimestamp;
    }

    public String getXfdUpdateUser() {
        return this.xfdUpdateUser;
    }

    public void setXfdUpdateUser(String xfdUpdateUser) {
        this.xfdUpdateUser = xfdUpdateUser;
    }

    public Timestamp getXmlUpdateTimestamp() {
        return this.xmlUpdateTimestamp;
    }

    public void setXmlUpdateTimestamp(Timestamp xmlUpdateTimestamp) {
        this.xmlUpdateTimestamp = xmlUpdateTimestamp;
    }

    public String getXmlUpdateUser() {
        return this.xmlUpdateUser;
    }

    public void setXmlUpdateUser(String xmlUpdateUser) {
        this.xmlUpdateUser = xmlUpdateUser;
    }

    public List<BudgetSubAwardAttachment> getBudgetSubAwardAttachments() {
        if (this.budgetSubAwardAttachments == null) {
            this.budgetSubAwardAttachments = new ArrayList<BudgetSubAwardAttachment>();
        }
        return this.budgetSubAwardAttachments;
    }

    public String getAttachmentContentIds() {
        String SEPARATOR = "; ";
        StringBuilder sb = new StringBuilder();
        for (BudgetSubAwardAttachment attachment : this.getBudgetSubAwardAttachments()) {
            sb.append(attachment.getContentId());
            sb.append("; ");
        }
        sb.deleteCharAt(sb.length() - 2);
        return sb.toString();
    }

    public void setBudgetSubAwardAttachments(List<BudgetSubAwardAttachment> budgetSubAwardAttachments) {
        this.budgetSubAwardAttachments = budgetSubAwardAttachments;
    }

    public byte[] getSubAwardXfdFileData() {
        return this.subAwardXfdFileData;
    }

    public void setSubAwardXfdFileData(byte[] subAwardXfdFileData) {
        this.subAwardXfdFileData = subAwardXfdFileData;
    }

    public String getSubAwardXmlFileData() {
        return this.subAwardXmlFileData;
    }

    public void setSubAwardXmlFileData(String subAwardXmlFileData) {
        this.subAwardXmlFileData = subAwardXmlFileData;
    }

    public List<BudgetSubAwardFiles> getBudgetSubAwardFiles() {
        return this.budgetSubAwardFiles;
    }

    public void setBudgetSubAwardFiles(List<BudgetSubAwardFiles> budgetSubAwardFiles) {
        this.budgetSubAwardFiles = budgetSubAwardFiles;
    }

    @Override
    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    @Override
    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formaName) {
        this.formName = formaName;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public FormFile getNewSubAwardFile() {
        return this.newSubAwardFile;
    }

    public void setNewSubAwardFile(FormFile newSubAwardFile) {
        this.newSubAwardFile = newSubAwardFile;
    }

    public boolean getNewSubAwardFileError() {
        return this.newSubAwardFileError;
    }

    public void setNewSubAwardFileError(boolean pNewSubAwardFileError) {
        this.newSubAwardFileError = pNewSubAwardFileError;
    }

    @Override
    public int compareTo(BudgetSubAwards o) {
        int retVal = -1;
        if (o != null && (retVal = ObjectUtils.compare((Comparable)((Object)this.getOrganizationName()), (Comparable)((Object)o.getOrganizationName()))) == 0 && (retVal = ObjectUtils.compare((Comparable)((Object)this.getComments()), (Comparable)((Object)o.getComments()))) == 0 && (retVal = ObjectUtils.compare((Comparable)((Object)this.getSubAwardXfdFileName()), (Comparable)((Object)o.getSubAwardXfdFileName()))) == 0) {
            retVal = ObjectUtils.compare((Comparable)this.getSubAwardNumber(), (Comparable)o.getSubAwardNumber());
        }
        return retVal;
    }

    public List<BudgetSubAwardPeriodDetail> getBudgetSubAwardPeriodDetails() {
        return this.budgetSubAwardPeriodDetails;
    }

    public void setBudgetSubAwardPeriodDetails(List<BudgetSubAwardPeriodDetail> budgetSubAwardPeriodDetails) {
        this.budgetSubAwardPeriodDetails = budgetSubAwardPeriodDetails;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        if (!StringUtils.equals((String)this.organizationId, (String)organizationId)) {
            this.organizationId = organizationId;
            this.refreshReferenceObject("organization");
            if (this.getOrganization() != null) {
                this.setOrganizationName(this.getOrganization().getOrganizationName());
            }
        }
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void computePeriodDetails() {
        for (BudgetSubAwardPeriodDetail detail : this.getBudgetSubAwardPeriodDetails()) {
            detail.computeTotal();
        }
    }

    public boolean hasModifiedAmounts() {
        for (BudgetSubAwardPeriodDetail detail : this.getBudgetSubAwardPeriodDetails()) {
            if (!detail.isAmountsModified()) continue;
            return true;
        }
        return false;
    }
}

