/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.budget.bo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetSubAwardsRule {
    public static final String SUBAWARD_ORG_NAME_FIELD_NAME = ".organizationName";
    private BudgetSubAwards budgetSubAwards;
    private BusinessObjectService businessObjectService;

    public BudgetSubAwardsRule(BudgetSubAwards budgetSubAwards) {
        this.budgetSubAwards = budgetSubAwards;
    }

    public boolean processApply() {
        this.budgetSubAwards.setNewSubAwardFileError(false);
        return this.verifyOrganizationName();
    }

    public boolean processNonXFDAttachment() {
        boolean nonXFD = this.verifyNonXFDAttachment();
        this.budgetSubAwards.setNewSubAwardFileError(!nonXFD);
        return this.verifyOrganizationName() && nonXFD;
    }

    public boolean processXFDAttachment() {
        boolean xfd = this.verifyXFDAttachment();
        this.budgetSubAwards.setNewSubAwardFileError(!xfd);
        return this.verifyOrganizationName() && xfd;
    }

    public boolean checkSpecialCharacters(String text) {
        if (this.getKcAttachmentService().getSpecialCharacter(text)) {
            GlobalVariables.getMessageMap().putWarning("subAwardFile", "newSubAward.subAwardFile.special.character", new String[0]);
            return true;
        }
        return false;
    }

    protected boolean verifyOrganizationName() {
        boolean success = true;
        if (StringUtils.isBlank((String)this.budgetSubAwards.getOrganizationName())) {
            GlobalVariables.getMessageMap().putError(SUBAWARD_ORG_NAME_FIELD_NAME, "newSubAward.organizationName.required", new String[0]);
            success = false;
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("organizationName", this.budgetSubAwards.getOrganizationName());
            Organization dbOrganization = (Organization)this.getBusinessObjectService().findByPrimaryKey(Organization.class, params);
            if (dbOrganization == null || !StringUtils.equals((String)dbOrganization.getOrganizationName(), (String)this.budgetSubAwards.getOrganizationName())) {
                GlobalVariables.getMessageMap().putError(SUBAWARD_ORG_NAME_FIELD_NAME, "newSubAward.organizationName.invalid", new String[0]);
                success = false;
            }
        }
        return success;
    }

    protected boolean verifyNonXFDAttachment() {
        boolean success = true;
        FormFile newBudgetSubAwardFile = this.budgetSubAwards.getNewSubAwardFile();
        try {
            if (ArrayUtils.isEmpty((byte[])newBudgetSubAwardFile.getFileData())) {
                GlobalVariables.getMessageMap().putError("subAwardFile", "newSubAward.subAwardFile.required", new String[0]);
                success = false;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            GlobalVariables.getMessageMap().putError("subAwardFile", "newSubAward.subAwardFile.required", new String[0]);
            success = false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            GlobalVariables.getMessageMap().putError("subAwardFile", "newSubAward.subAwardFile.required", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean verifyXFDAttachment() {
        boolean success = this.verifyNonXFDAttachment();
        if (success) {
            FormFile subAwardFile = this.budgetSubAwards.getNewSubAwardFile();
            String contentType = subAwardFile.getContentType();
            byte[] subAwardData = null;
            try {
                subAwardData = subAwardFile.getFileData();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            if (subAwardData == null || subAwardData.length == 0 || !contentType.equals("application/pdf")) {
                GlobalVariables.getMessageMap().putError("subAwardFile", "newSubAward.subAwardFile.required", new String[0]);
                success = false;
            } else if (this.budgetSubAwards.getBudgetSubAwardFiles().isEmpty() || this.budgetSubAwards.getBudgetSubAwardFiles().get(0).getSubAwardXmlFileData() == null) {
                success = false;
            }
        }
        return success;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public KcAttachmentService getKcAttachmentService() {
        return KraServiceLocator.getService(KcAttachmentService.class);
    }
}

